/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.notification.DeliverySchedule;
import com.cenqua.crucible.notification.NotificationEvent;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.crucible.notification.SharableContentType;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ShareContentNotificationEvent
extends NotificationEvent {
    private List<FecruUser> users;
    private List<String> emails;
    private String objectUrl;
    private String objectName;
    private String objectId;
    private String objectRepository;

    public ShareContentNotificationEvent() {
    }

    public ShareContentNotificationEvent(FecruUser actioner, List<FecruUser> users, List<String> emails, String objectUrl, String objectName, String objectRepository, String objectId, SharableContentType type, String note) {
        super(actioner);
        this.users = users;
        this.emails = emails;
        if (note == null) {
            this.setNote("");
        } else {
            this.setNote(note);
        }
        this.setObjectUrl(objectUrl);
        this.setRef1(type.ordinal());
        objectName = objectName.trim();
        this.setObjectName(objectName);
        this.objectRepository = objectRepository;
        this.objectId = objectId;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public String getObjectRepository() {
        return this.objectRepository;
    }

    public void setObjectRepository(String objectRepository) {
        this.objectRepository = objectRepository;
    }

    public String getObjectUrl() {
        return this.objectUrl;
    }

    public void setObjectUrl(String objectUrl) {
        this.objectUrl = objectUrl;
    }

    public SharableContentType getObjectType() {
        return SharableContentType.values()[this.getRef1()];
    }

    @Override
    public Integer getType() {
        return NotificationManager.TYPE_SHARE_CONTENT;
    }

    @Override
    public String getEmailSubject() {
        StringBuilder subject = new StringBuilder();
        if (!StringUtils.isEmpty((String)this.getObjectRepository())) {
            subject.append(this.getObjectRepository()).append(": ");
        }
        subject.append(this.getActioner().getDisplayName()).append(" shared the ").append(this.getObjectType().getName()).append(" ");
        if (this.getObjectName().trim().length() == 0) {
            subject.append(this.getObjectId());
        } else {
            subject.append("\"").append(this.getObjectName()).append("\"");
        }
        subject.append(" with you");
        return subject.toString();
    }

    @Override
    public String getDescription() {
        return "Content Shared";
    }

    @Override
    public Integer getEmailNotificationPref(FecruUser user) {
        return DeliverySchedule.IMMEDIATE;
    }

    @Override
    public void doNotify() {
        for (FecruUser user : this.users) {
            this.createAndAddRecipient(user);
        }
        for (String email : this.emails) {
            this.createAndAddRecipient(email);
        }
    }

    @Override
    protected boolean shouldNotify(FecruUser user) {
        return true;
    }
}

