/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.notification.ShareContentNotificationEvent;
import com.cenqua.crucible.notification.ShareNotificationEventFactory;
import java.util.List;

public enum SharableContentType {
    REPOSITORY("repository"){

        @Override
        public ShareContentNotificationEvent buildEvent(FecruUser actioner, List<FecruUser> users, List<String> emails, String url, String note, String entity1, String entity2, ShareNotificationEventFactory factory) {
            return factory.shareRepository(actioner, users, emails, url, note, entity1);
        }
    }
    ,
    CHANGESET("changeset"){

        @Override
        public ShareContentNotificationEvent buildEvent(FecruUser actioner, List<FecruUser> users, List<String> emails, String url, String note, String entity1, String entity2, ShareNotificationEventFactory factory) {
            return factory.shareChangeset(actioner, users, emails, url, note, entity1, entity2);
        }
    }
    ,
    SOURCE("file"){

        @Override
        public ShareContentNotificationEvent buildEvent(FecruUser actioner, List<FecruUser> users, List<String> emails, String url, String note, String entity1, String entity2, ShareNotificationEventFactory factory) {
            return factory.shareFile(actioner, users, emails, url, note, entity1, entity2);
        }
    }
    ,
    REVIEW("a", "review", true){

        @Override
        public ShareContentNotificationEvent buildEvent(FecruUser actioner, List<FecruUser> users, List<String> emails, String url, String note, String entity1, String entity2, ShareNotificationEventFactory factory) {
            return factory.shareReview(actioner, users, emails, url, note, Integer.parseInt(entity1));
        }
    };

    private final String singular;
    private final String name;
    private final boolean isCrucible;

    private SharableContentType(String name) {
        this("a", name, false);
    }

    private SharableContentType(String singular, String name, boolean isCrucible) {
        this.singular = singular;
        this.name = name;
        this.isCrucible = isCrucible;
    }

    public String getName() {
        return this.name;
    }

    public String getSingular() {
        return this.singular;
    }

    public String getProductName() {
        return this.isCrucible ? "Crucible" : "FishEye";
    }

    public abstract ShareContentNotificationEvent buildEvent(FecruUser var1, List<FecruUser> var2, List<String> var3, String var4, String var5, String var6, String var7, ShareNotificationEventFactory var8);
}

