/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.FRXRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.Role;
import com.cenqua.crucible.model.managers.FRXRevisionManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.notification.ForceCompleteStatusChangeNotificationEvent;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.fisheye.logging.Logs;
import java.util.LinkedList;
import java.util.List;

public class RevisionAddedNotificationEvent
extends ForceCompleteStatusChangeNotificationEvent {
    private FRXRevision frxRev;

    public RevisionAddedNotificationEvent() {
    }

    public RevisionAddedNotificationEvent(FecruUser actioner, Review review, FRXRevision frxRev) {
        super(actioner, review);
        this.setFRXRevision(frxRev);
    }

    public FRXRevision getFRXRevision() {
        if (this.frxRev == null) {
            FRXRevisionManager frxRevisionManager = new FRXRevisionManager();
            this.frxRev = frxRevisionManager.getById(this.getRef1());
            if (this.frxRev == null) {
                Logs.APP_LOG.debug((Object)("FRXRevision " + this.getRef1() + " doesn't exist."));
            }
        }
        return this.frxRev;
    }

    public void setFRXRevision(FRXRevision frxRev) {
        this.frxRev = frxRev;
        this.setRef1(frxRev.getId());
    }

    @Override
    protected boolean getResetCompletionPreference(FecruUser user) {
        return user.getUserProfile().getUncompleteOnRevisionAdded();
    }

    @Override
    public String getDescription() {
        return "Revision Added";
    }

    @Override
    public String getBody() {
        FileRevisionExtraInfo frx = this.getFrx();
        if (frx == null) {
            return "File revision has been deleted.";
        }
        return "File: " + frx.getFileRevision().getPath() + "; Revision: " + frx.getFileRevision().getRevisionDisplayName();
    }

    @Override
    public Integer getType() {
        return NotificationManager.TYPE_REVISION_ADDED;
    }

    @Override
    public FileRevisionExtraInfo getFrx() {
        FRXRevision frxRev = this.getFRXRevision();
        return frxRev == null ? null : frxRev.getFrx();
    }

    @Override
    public List<Role> getRolesToNotify() {
        LinkedList<Role> roles = new LinkedList<Role>();
        roles.add(ReviewManager.AUTHOR);
        roles.add(ReviewManager.MODERATOR);
        roles.add(ReviewManager.REVIEWER);
        return roles;
    }
}

