/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.Role;
import com.cenqua.crucible.model.managers.DefaultCommentManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.crucible.notification.ReviewCommentNotificationEvent;
import com.cenqua.fisheye.logging.Logs;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ReplyNotificationEvent
extends ReviewCommentNotificationEvent {
    private Comment comment;
    private Comment reply;

    public ReplyNotificationEvent() {
    }

    public ReplyNotificationEvent(Review review, Comment comment, Comment reply) {
        super(reply.getUser(), review);
        this.setComment(comment);
        this.setReply(reply);
        this.setReview(review);
    }

    @Override
    public Integer getType() {
        return NotificationManager.TYPE_REPLIED;
    }

    @Override
    public Comment getComment() {
        if (this.comment == null && this.getRef1() != null) {
            this.comment = DefaultCommentManager.getInstance().getById(this.getRef1());
            if (this.comment == null) {
                Logs.APP_LOG.warn((Object)("Comment " + this.getRef1() + "doesn't exist."));
            }
        }
        return this.comment;
    }

    public void setComment(Comment comment) {
        this.comment = comment;
        this.setRef1(comment.getId());
    }

    public Comment getReply() {
        if (this.reply == null && this.getRef2() != null) {
            this.reply = DefaultCommentManager.getInstance().getById(this.getRef2());
            if (this.reply == null) {
                Logs.APP_LOG.warn((Object)("Reply " + this.getRef2() + " doesn't exist."));
            }
        }
        return this.reply;
    }

    @Override
    public Long getLatestChangeTime() {
        Comment comment = this.getReply();
        Long updated = null;
        if (comment != null && (updated = comment.getUpdatedDateTime()) == null) {
            updated = comment.getCreateDateTime();
        }
        return updated;
    }

    public void setReply(Comment reply) {
        this.reply = reply;
        this.setRef2(reply.getId());
    }

    @Override
    public String getDescription() {
        return "Reply";
    }

    @Override
    public List<Role> getRolesToNotify() {
        LinkedList<Role> roles = new LinkedList<Role>();
        roles.add(ReviewManager.AUTHOR);
        roles.add(ReviewManager.MODERATOR);
        roles.add(ReviewManager.REVIEWER);
        return roles;
    }

    @Override
    public Set<FecruUser> getUsersToNotify() {
        HashSet<FecruUser> users = new HashSet<FecruUser>();
        users.addAll(super.getUsersToNotify());
        for (Comment comment = this.getComment(); comment != null; comment = comment.getReplyToComment()) {
            users.add(comment.getUser());
        }
        return users;
    }

    @Override
    public Integer getEmailNotificationPref(FecruUser user) {
        return user.getUserProfile().getReplyEmailNotification();
    }

    @Override
    protected boolean getResetCompletionPreference(FecruUser user) {
        return false;
    }
}

