/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.notification.DeliverySchedule;
import com.cenqua.crucible.notification.NotificationEvent;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.fisheye.logging.Logs;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Properties;

public class PluginNotificationEvent
extends NotificationEvent {
    public static final String GROUP_TYPE = "groupType";
    public static final String EMAIL_SUBJECT = "emailSubject";
    public static final String HTML_BODY = "htmlBody";
    public static final String TEXT_BODY = "textBody";

    public PluginNotificationEvent() {
    }

    public PluginNotificationEvent(FecruUser actioner, String groupType, String emailSubject, String htmlBody, String textBody) {
        super(actioner);
        Properties properties = new Properties();
        properties.put(GROUP_TYPE, groupType);
        properties.put(EMAIL_SUBJECT, emailSubject);
        properties.put(HTML_BODY, htmlBody);
        properties.put(TEXT_BODY, textBody);
        StringWriter writer = new StringWriter();
        try {
            properties.store(writer, "UTF-8");
            writer.close();
        }
        catch (IOException e2) {
            Logs.APP_LOG.error((Object)"Could not store the note values to the note property", (Throwable)e2);
        }
        this.setNote(writer.getBuffer().toString());
    }

    @Override
    public Integer getType() {
        return NotificationManager.TYPE_PLUGIN;
    }

    @Override
    public String getEmailSubject() {
        return (String)this.getProperties().get(EMAIL_SUBJECT);
    }

    public String getGroupType() {
        return (String)this.getProperties().get(GROUP_TYPE);
    }

    public String getHtmlBody() {
        return (String)this.getProperties().get(HTML_BODY);
    }

    public String getTextBody() {
        return (String)this.getProperties().get(TEXT_BODY);
    }

    private Properties getProperties() {
        Properties properties = new Properties();
        try {
            properties.load(new StringReader(this.getNote()));
        }
        catch (IOException e2) {
            Logs.APP_LOG.error((Object)"Could not load the note values from the note property", (Throwable)e2);
        }
        return properties;
    }

    @Override
    public String getDescription() {
        return this.getEmailSubject();
    }

    @Override
    public Integer getEmailNotificationPref(FecruUser user) {
        return DeliverySchedule.IMMEDIATE;
    }

    @Override
    public void doNotify() {
    }

    @Override
    protected boolean shouldNotify(FecruUser user) {
        return !user.getUserProfile().getDontSendMeMyNotifications() || !user.equals(this.getActioner());
    }
}

