/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.notification.DeliverySchedule;
import com.cenqua.crucible.notification.Notification;
import com.cenqua.crucible.notification.NotificationEventBase;

public abstract class NotificationEvent
extends NotificationEventBase {
    public NotificationEvent(FecruUser actioner) {
        super(actioner);
    }

    public NotificationEvent() {
    }

    public abstract Integer getType();

    public abstract String getEmailSubject();

    public abstract String getDescription();

    public abstract Integer getEmailNotificationPref(FecruUser var1);

    public abstract void doNotify();

    public void doNotify(FecruUser user) {
        this.createAndAddRecipient(user);
    }

    protected Notification createAndAddRecipient(FecruUser user) {
        Notification notification = null;
        if (this.shouldNotify(user)) {
            notification = new Notification();
            notification.setEmail(this.getEmailNotificationPref(user));
            notification.setRss(DeliverySchedule.IMMEDIATE);
            notification.setUser(user);
            notification.setUiACK(null);
            notification.setEvent(this);
            this.addNotification(notification);
            HibernateUtil.currentSession().save((Object)notification);
        }
        return notification;
    }

    protected Notification createAndAddRecipient(String emailAddress) {
        Notification notification = new Notification();
        notification.setEmail(DeliverySchedule.IMMEDIATE);
        notification.setUser(null);
        notification.setEmailAddress(emailAddress);
        notification.setUiACK(null);
        notification.setEvent(this);
        this.addNotification(notification);
        HibernateUtil.currentSession().save((Object)notification);
        return notification;
    }

    protected boolean shouldNotify(FecruUser user) {
        return !user.getUserProfile().getDontSendMeMyNotifications() || !user.equals(this.getActioner());
    }

    public String getBody() {
        return null;
    }

    public boolean needsCrucible() {
        return this.getReview() != null;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        NotificationEvent that = (NotificationEvent)o2;
        if (this.getId() == null || that.getId() == null) {
            return super.equals(o2);
        }
        return this.getId().equals(that.getId());
    }

    public int hashCode() {
        if (this.getId() == null) {
            return super.hashCode();
        }
        return this.getId();
    }
}

