/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification;

import com.atlassian.crucible.spi.PermId;
import com.atlassian.crucible.spi.data.CsCommentData;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.model.ChangesetComment;
import com.atlassian.fisheye.model.managers.ChangesetCommentManager;
import com.atlassian.fisheye.spi.data.ChangesetDataFE;
import com.atlassian.fisheye.spi.services.RevisionDataService;
import com.atlassian.fisheye.web.NavBuilder;
import com.cenqua.crucible.notification.MentionUserNotificationEvent;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.crucible.util.FreemarkerUtil;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.fisheye.web.WaybackSpec;
import org.springframework.beans.factory.annotation.Autowired;

public class MentionUserInChangesetCommentNotificationEvent
extends MentionUserNotificationEvent {
    @Autowired
    private ChangesetCommentManager changesetCommentManager;
    @Autowired
    private RevisionDataService revisionDataService;
    private ChangesetComment changesetComment;
    private ChangesetDataFE changesetDataFE;

    public MentionUserInChangesetCommentNotificationEvent(FecruUser actioner, String commentId, String objectUrl, FecruUser mentioned) {
        super(actioner, commentId, objectUrl, mentioned, NotificationManager.TYPE_MENTION_USER_IN_CHANGESET_COMMENT, "mention-user-in-changeset-comment-notification.ftl");
    }

    public MentionUserInChangesetCommentNotificationEvent() {
        this(null, null, null, null);
    }

    @Override
    public String getObjectDescription() {
        return "a comment on changeset " + this.getChangesetDataFE().getDisplayId() + " in repository " + this.getChangesetComment().getRepository();
    }

    public String getCommentId() {
        return this.getObjectName();
    }

    public ChangesetComment getChangesetComment() {
        if (this.changesetComment == null) {
            this.changesetComment = this.changesetCommentManager.getComment((PermId<CsCommentData>)new PermId(this.getCommentId()));
        }
        return this.changesetComment;
    }

    public ChangesetDataFE getChangesetDataFE() {
        if (this.changesetDataFE == null) {
            this.changesetDataFE = this.revisionDataService.getChangeset(this.getChangesetComment().getRepository(), this.getChangesetComment().getCsid());
        }
        return this.changesetDataFE;
    }

    public String getCommitMessage() {
        ChangesetDataFE cs = this.getChangesetDataFE();
        String message = cs.getComment();
        message = FreemarkerUtil.newLinesToSpaces(message).trim();
        message = StringUtil.truncate(message, 47, true);
        return message;
    }

    @Override
    public String getEmailSubject() {
        return this.getChangesetComment().getRepository() + ": " + this.getActioner().getDisplayName() + " mentioned you in the changeset \"" + this.getCommitMessage() + "\"";
    }

    public String getRepositoryBrowseUrl() {
        return NavBuilder.browseAbs(new WaybackSpec(), this.getChangesetComment().getRepository(), null);
    }
}

