/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.Role;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.notification.BaseReviewNotificationEvent;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.fisheye.util.StringUtil;
import java.util.LinkedList;
import java.util.List;

public class GeneralNotificationEvent
extends BaseReviewNotificationEvent {
    public GeneralNotificationEvent() {
    }

    public GeneralNotificationEvent(FecruUser actioner, Review review, String note) {
        super(actioner);
        this.setReview(review);
        this.setNote(note);
    }

    @Override
    public Integer getType() {
        return NotificationManager.TYPE_GENERAL;
    }

    @Override
    public String getDescription() {
        return StringUtil.firstLineOf(this.getNote(), 40, false, true, true);
    }

    @Override
    public List<Role> getRolesToNotify() {
        LinkedList<Role> roles = new LinkedList<Role>();
        roles.add(ReviewManager.AUTHOR);
        roles.add(ReviewManager.MODERATOR);
        roles.add(ReviewManager.REVIEWER);
        roles.add(ReviewManager.CREATOR);
        return roles;
    }

    @Override
    public Integer getEmailNotificationPref(FecruUser user) {
        return user.getUserProfile().getGeneralEmailNotification();
    }
}

