/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewParticipant;
import com.cenqua.crucible.model.managers.UnreadFileManager;
import com.cenqua.crucible.notification.BaseReviewNotificationEvent;
import com.cenqua.crucible.notification.Notification;
import com.cenqua.fisheye.config.SpringContext;
import java.util.Date;
import java.util.Set;

public abstract class ForceCompleteStatusChangeNotificationEvent
extends BaseReviewNotificationEvent {
    private UnreadFileManager unreadFileManager;

    protected ForceCompleteStatusChangeNotificationEvent() {
    }

    public ForceCompleteStatusChangeNotificationEvent(FecruUser actioner, Review review) {
        super(actioner);
        this.setReview(review);
    }

    @Override
    public void doNotify() {
        Set<FecruUser> users = this.getUsersToNotify();
        for (FecruUser user : users) {
            Notification r2;
            ReviewParticipant p2 = null;
            if (this.shouldNotify(user) && (r2 = this.createAndAddRecipient(user)) != null && this.getResetCompletionPreference(user) && (p2 = this.getReview().getParticipant(user)) != null) {
                FileRevisionExtraInfo frx = this.getFrx();
                if (frx != null && p2.isRead(frx)) {
                    r2.setPerUserFlag(1);
                }
                if (p2.isAllComplete()) {
                    r2.setPerUserFlag(2);
                }
            }
            if (!this.getResetCompletionPreference(user)) continue;
            if (p2 == null) {
                p2 = this.getReview().getParticipant(user);
            }
            this.uncheckFrxs(p2);
            this.getReview().setReviewerIncomplete(p2);
        }
    }

    protected void uncheckFrxs(ReviewParticipant p2) {
        if (p2 == null) {
            return;
        }
        FileRevisionExtraInfo frx = this.getFrx();
        if (frx != null) {
            this.getUnreadFileManager().markAsUnread(p2, frx, new Date(frx.getLatestRevisionAddDateTime()), false);
        }
    }

    private UnreadFileManager getUnreadFileManager() {
        if (this.unreadFileManager == null) {
            this.unreadFileManager = SpringContext.getComponentByClass(UnreadFileManager.class);
        }
        return this.unreadFileManager;
    }

    protected abstract boolean getResetCompletionPreference(FecruUser var1);

    @Override
    public String getDescription() {
        return "Review updated";
    }

    @Override
    public Integer getEmailNotificationPref(FecruUser user) {
        return user.getUserProfile().getAutoUncompleteEmailNotification();
    }
}

