/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.notification.SharableContentType;
import com.cenqua.crucible.notification.ShareContentNotificationEvent;
import com.cenqua.crucible.notification.ShareNotificationEventFactory;
import com.cenqua.crucible.util.FreemarkerUtil;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.util.StringUtil;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AvailableToPlugins
public class DefaultShareNotificationEventFactory
implements ShareNotificationEventFactory {
    private ReviewManager reviewManager;
    private RepositoryManager repositoryManager;
    private static final int MAX_TRUNCATED_LENGTH = 47;

    @Autowired
    public DefaultShareNotificationEventFactory(ReviewManager reviewManager, RepositoryManager repositoryManager) {
        this.reviewManager = reviewManager;
        this.repositoryManager = repositoryManager;
    }

    @Override
    public ShareContentNotificationEvent shareReview(FecruUser actioner, List<FecruUser> users, List<String> emails, String url, String note, Integer reviewId) {
        Review review = this.reviewManager.getReviewById(reviewId);
        String name = review.getName();
        return new ShareContentNotificationEvent(actioner, users, emails, url, this.truncate(name), null, review.getPermaId(), SharableContentType.REVIEW, note);
    }

    @Override
    public ShareContentNotificationEvent shareRepository(FecruUser actioner, List<FecruUser> users, List<String> emails, String url, String note, String repositoryName) {
        return new ShareContentNotificationEvent(actioner, users, emails, url, this.truncate(repositoryName), null, null, SharableContentType.REPOSITORY, note);
    }

    @Override
    public ShareContentNotificationEvent shareChangeset(FecruUser actioner, List<FecruUser> users, List<String> emails, String url, String note, String repositoryName, String csId) {
        RepositoryHandle repository = this.repositoryManager.getRepository(repositoryName);
        try {
            Object changeSet = repository.acquireEngine().getRevisionCache().getChangeSet(csId);
            String comment = changeSet.getComment();
            comment = FreemarkerUtil.newLinesToSpaces(comment).trim();
            return new ShareContentNotificationEvent(actioner, users, emails, url, this.truncate(comment), repositoryName, changeSet.getDisplayId(), SharableContentType.CHANGESET, note);
        }
        catch (RepositoryHandle.StateException e2) {
            Logs.APP_LOG.error((Object)("Failed to share changeset: " + repository + "@" + csId), (Throwable)((Object)e2));
            return null;
        }
    }

    @Override
    public ShareContentNotificationEvent shareFile(FecruUser actioner, List<FecruUser> users, List<String> emails, String url, String note, String repositoryName, String pathString) {
        Path path = new Path(pathString);
        String name = path.abbreviate(47 - path.getName().length()).getPath();
        return new ShareContentNotificationEvent(actioner, users, emails, url, name, repositoryName, null, SharableContentType.SOURCE, note);
    }

    private String truncate(String string) {
        return StringUtil.truncate(string, 47, true);
    }
}

