/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification;

import com.atlassian.crucible.event.AllReviewersCompletedEvent;
import com.atlassian.crucible.event.AllReviewersNoLongerCompletedEvent;
import com.atlassian.crucible.event.CommentCreatedEvent;
import com.atlassian.crucible.event.CommentPropertiesChangedEvent;
import com.atlassian.crucible.event.CommentUpdatedEvent;
import com.atlassian.crucible.event.ReviewCommentEvent;
import com.atlassian.crucible.event.ReviewEvent;
import com.atlassian.crucible.event.ReviewReminderEvent;
import com.atlassian.crucible.event.ReviewStateChangedEvent;
import com.atlassian.crucible.event.ReviewerCompletedEvent;
import com.atlassian.crucible.event.ReviewerUncompletedEvent;
import com.atlassian.crucible.event.cscomment.CsCommentEvent;
import com.atlassian.crucible.spi.PermId;
import com.atlassian.crucible.spi.TxCallback;
import com.atlassian.crucible.spi.data.CommentData;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.license.LicenseManager;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.UserProfileManager;
import com.atlassian.fisheye.event.ApplicationStartedEvent;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.fisheye.spi.data.MailMessageData;
import com.atlassian.fisheye.user.permissions.GlobalPermissionManager;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.atlassian.fugue.Function2;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.CrucibleSysProps;
import com.cenqua.crucible.hibernate.DBControlFactory;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.FRXRevision;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.StateManager;
import com.cenqua.crucible.notification.AllCompletedNotificationEvent;
import com.cenqua.crucible.notification.AllUncompletedNotificationEvent;
import com.cenqua.crucible.notification.CommentNotificationEvent;
import com.cenqua.crucible.notification.CommentPropertiesChangedNotificationEvent;
import com.cenqua.crucible.notification.CompletedNotificationEvent;
import com.cenqua.crucible.notification.CsCommentAddedEventNotificationCreator;
import com.cenqua.crucible.notification.DeliverySchedule;
import com.cenqua.crucible.notification.GeneralNotificationEvent;
import com.cenqua.crucible.notification.MentionUserNotificationEvent;
import com.cenqua.crucible.notification.Notification;
import com.cenqua.crucible.notification.NotificationEvent;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.crucible.notification.PluginNotificationEvent;
import com.cenqua.crucible.notification.ReplyNotificationEvent;
import com.cenqua.crucible.notification.ReviewCommentNotificationEvent;
import com.cenqua.crucible.notification.ReviewReminderNotificationEvent;
import com.cenqua.crucible.notification.RevisionAddedNotificationEvent;
import com.cenqua.crucible.notification.ShareContentNotificationEvent;
import com.cenqua.crucible.notification.StateNotificationEvent;
import com.cenqua.crucible.notification.UncompletedNotificationEvent;
import com.cenqua.crucible.notification.batch.Batch;
import com.cenqua.crucible.notification.batch.BatchCreatorType;
import com.cenqua.crucible.notification.batch.DefaultNotificationBatchProvider;
import com.cenqua.crucible.util.HqlBatchedInClauseHelper;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.mail.Mailer;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.ConfigurableThreadFactory;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.util.Pair;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;

@AvailableToPlugins(value=NotificationManager.class)
@Service(value="notificationManager")
public class DefaultNotificationManager
implements NotificationManager {
    private static final boolean DEBUGGING = CrucibleSysProps.DEBUG_NOTIFICATION_EMAILS;
    private static final long DEBUGGING_WAIT_TIME = 0L;
    private final UserProfileManager userProfileManager;
    private final DBControlFactory dbControlFactory;
    private final CsCommentAddedEventNotificationCreator csCommentAddedEventNotificationCreator;
    private final RootConfig rootConfig;
    private final EventPublisher eventPublisher;
    private final EffectiveUserProvider effectiveUserProvider;
    private final UserManager userManager;
    private final Mailer mailer;
    private final TxTemplate txTemplate;
    private final CommentManager commentManager;
    private final ReviewManager reviewManager;
    private final GlobalPermissionManager globalPermissionManager;
    private final ScheduledExecutorService notificationExecutor = Executors.newScheduledThreadPool(1, new ConfigurableThreadFactory("notificationManager", false));
    private Future<?> notifierTask;
    private Future<?> notifierCleanupTask;
    private Future<?> remindersTask;
    private static final long BATCH_WAIT_TIME = DEBUGGING ? 0L : 1800000L;
    private static final long IMMEDIATE_DIRECT_INITIAL_WAIT_TIME = DEBUGGING ? 0L : 120000L;
    private static final long IMMEDIATE_INDIRECT_INITIAL_WAIT_TIME = DEBUGGING ? 0L : 300000L;
    private static final long IMMEDIATE_INCREMENTAL_WAIT_TIME = DEBUGGING ? 0L : 120000L;
    private static final long IMMEDIATE_MAX_WAIT_TIME = DEBUGGING ? 0L : 600000L;

    public static NotificationManager getInstance() {
        return (NotificationManager)SpringContext.getComponent("notificationManager");
    }

    @Autowired
    public DefaultNotificationManager(DBControlFactory dbControlFactory, CsCommentAddedEventNotificationCreator csCommentAddedEventNotificationCreator, RootConfig rootConfig, UserProfileManager userProfileManager, EventPublisher eventPublisher, EffectiveUserProvider effectiveUserProvider, UserManager userManager, Mailer mailer, TxTemplate txTemplate, ReviewManager reviewManager, CommentManager commentManager, GlobalPermissionManager globalPermissionManager) {
        this.dbControlFactory = dbControlFactory;
        this.csCommentAddedEventNotificationCreator = csCommentAddedEventNotificationCreator;
        this.rootConfig = rootConfig;
        this.userProfileManager = userProfileManager;
        this.eventPublisher = eventPublisher;
        this.effectiveUserProvider = effectiveUserProvider;
        this.userManager = userManager;
        this.mailer = mailer;
        this.txTemplate = txTemplate;
        this.reviewManager = reviewManager;
        this.commentManager = commentManager;
        this.globalPermissionManager = globalPermissionManager;
        dbControlFactory.setNotificationManager(this);
    }

    @PostConstruct
    public void init() {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void applicationStarted(ApplicationStartedEvent applicationStartedEvent) {
        if (this.dbControlFactory != null && this.dbControlFactory.getCurrentControl().isRunning()) {
            this.start();
        } else {
            Logs.APP_LOG.warn((Object)"Notification Manager not starting. No database.");
        }
    }

    @EventListener
    public void didAddReviewComment(final ReviewStateChangedEvent event) {
        this.txTemplate.execute(new TxCallback<Void>(){

            @Override
            public Void doInTransaction(TransactionStatus status) throws Exception {
                Review review = DefaultNotificationManager.this.reviewManager.getReviewByPermaId(event.getReviewId().getId());
                FecruUser user = DefaultNotificationManager.this.userManager.getUser(event.getActioner().getUserName());
                StateNotificationEvent note = new StateNotificationEvent(user, review);
                DefaultNotificationManager.session().save((Object)note);
                ((NotificationEvent)note).doNotify();
                return null;
            }
        });
    }

    @EventListener
    public void onReviewerCompleted(ReviewerCompletedEvent e2) {
        this.saveNotification((ReviewEvent)e2, new Function2<FecruUser, Review, NotificationEvent>(){

            public NotificationEvent apply(FecruUser user, Review review) {
                return new CompletedNotificationEvent(user, review);
            }
        });
    }

    @EventListener
    public void onReviewerUncompleted(ReviewerUncompletedEvent e2) {
        this.saveNotification((ReviewEvent)e2, new Function2<FecruUser, Review, NotificationEvent>(){

            public NotificationEvent apply(FecruUser user, Review review) {
                return new UncompletedNotificationEvent(user, review);
            }
        });
    }

    @EventListener
    public void onAllReviewersCompleted(AllReviewersCompletedEvent e2) {
        this.saveNotification((ReviewEvent)e2, new Function2<FecruUser, Review, NotificationEvent>(){

            public NotificationEvent apply(FecruUser user, Review review) {
                return new AllCompletedNotificationEvent(user, review);
            }
        });
    }

    @EventListener
    public void onAllReviewersNoLongerCompleted(AllReviewersNoLongerCompletedEvent e2) {
        this.saveNotification((ReviewEvent)e2, new Function2<FecruUser, Review, NotificationEvent>(){

            public NotificationEvent apply(FecruUser user, Review review) {
                return new AllUncompletedNotificationEvent(user, review);
            }
        });
    }

    private void saveNotification(final ReviewEvent event, final Function2<FecruUser, Review, NotificationEvent> createNotificationFn) {
        this.txTemplate.execute(new TxCallback<Void>(){

            @Override
            public Void doInTransaction(TransactionStatus status) throws Exception {
                FecruUser user = DefaultNotificationManager.this.userManager.getUser(event.getActioner().getUserName());
                Review review = DefaultNotificationManager.this.reviewManager.getReviewByPermaId(event.getReviewId().getId());
                NotificationEvent note = (NotificationEvent)createNotificationFn.apply((Object)user, (Object)review);
                DefaultNotificationManager.session().save((Object)note);
                note.doNotify();
                return null;
            }
        });
    }

    @EventListener
    public void onReviewCommentCreated(CommentCreatedEvent event) {
        this.addCommentNotification((ReviewCommentEvent)event);
    }

    @EventListener
    public void onReviewCommentUpdated(CommentUpdatedEvent event) {
        this.addCommentNotification((ReviewCommentEvent)event);
    }

    private void addCommentNotification(final ReviewCommentEvent event) {
        this.txTemplate.execute(new TxCallback<Void>(){

            @Override
            public Void doInTransaction(TransactionStatus status) throws Exception {
                Comment comment = DefaultNotificationManager.this.commentManager.getByPermId((PermId<CommentData>)event.getCommentId());
                if (!comment.isDraft() && !comment.getReview().getState().isDraftState()) {
                    ReviewCommentNotificationEvent note = comment.getReplyToComment() != null ? new ReplyNotificationEvent(comment.getReview(), comment.getReplyToComment(), comment) : new CommentNotificationEvent(comment.getReview(), comment);
                    DefaultNotificationManager.session().save((Object)note);
                    ((NotificationEvent)note).doNotify();
                }
                return null;
            }
        });
    }

    @EventListener
    public void onReviewCommentPropertiesChanged(final CommentPropertiesChangedEvent event) {
        this.txTemplate.execute(new TxCallback<Void>(){

            @Override
            public Void doInTransaction(TransactionStatus status) throws Exception {
                Preconditions.checkState((event.getActioner() != null ? 1 : 0) != 0, (Object)"Actioner can't be null");
                Preconditions.checkState((event.getReviewId() != null ? 1 : 0) != 0, (Object)"Review Id can't be null");
                Preconditions.checkState((event.getCommentId() != null ? 1 : 0) != 0, (Object)"Comment Id can't be null");
                Preconditions.checkState((event.getHeaderNote() != null ? 1 : 0) != 0, (Object)"Header note can't be null");
                Preconditions.checkState((event.getCommentNote() != null ? 1 : 0) != 0, (Object)"Comment note can't be null");
                FecruUser actioner = DefaultNotificationManager.this.userManager.getLicensedUser(event.getActioner().getUserName());
                Review review = DefaultNotificationManager.this.reviewManager.getReviewByPermaId(event.getReviewId().getId());
                Comment comment = DefaultNotificationManager.this.commentManager.getByPermId((PermId<CommentData>)event.getCommentId());
                Preconditions.checkState((actioner != null ? 1 : 0) != 0, (Object)("User with the given username not found: " + event.getActioner().getUserName()));
                Preconditions.checkState((review != null ? 1 : 0) != 0, (Object)("Review with the given Id not found: " + event.getReviewId()));
                Preconditions.checkState((comment != null ? 1 : 0) != 0, (Object)("Comment with the given Id not found: " + event.getCommentId()));
                CommentPropertiesChangedNotificationEvent note = new CommentPropertiesChangedNotificationEvent(actioner, review, comment, event.getHeaderNote(), event.getCommentNote());
                DefaultNotificationManager.session().save((Object)note);
                ((NotificationEvent)note).doNotify();
                return null;
            }
        });
    }

    @EventListener
    public void didChangesetComment(final CsCommentEvent event) {
        this.txTemplate.execute(new TxCallback<Void>(){

            @Override
            public Void doInTransaction(TransactionStatus status) throws Exception {
                for (NotificationEvent note : DefaultNotificationManager.this.csCommentAddedEventNotificationCreator.createNotification(event)) {
                    DefaultNotificationManager.session().save((Object)note);
                    note.doNotify();
                }
                return null;
            }
        });
    }

    @EventListener
    public void requestedReviewReminder(final ReviewReminderEvent event) {
        this.txTemplate.execute(new TxCallback<Void>(){

            @Override
            public Void doInTransaction(TransactionStatus status) throws Exception {
                Review review = DefaultNotificationManager.this.reviewManager.getReviewByPermaId(event.getReviewId().getId());
                FecruUser sender = event.getActioner() == null ? null : DefaultNotificationManager.this.userManager.getUser(event.getActioner().getUserName());
                ReviewReminderNotificationEvent notification = new ReviewReminderNotificationEvent(sender, review);
                DefaultNotificationManager.session().save((Object)notification);
                ((NotificationEvent)notification).doNotify();
                return null;
            }
        });
    }

    @Override
    public void start() {
        this.startNotificationTasks();
    }

    @Override
    public void stop() {
        this.stopNotificationTasks();
    }

    private void startNotificationTasks() {
        this.notifierTask = this.notificationExecutor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                DefaultNotificationManager.this.processNotifications();
            }
        }, 15L, 15L, TimeUnit.SECONDS);
        this.notifierCleanupTask = this.notificationExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                DefaultNotificationManager.this.processCleanupNotifications();
            }
        }, 1L, 12L, TimeUnit.HOURS);
        this.remindersTask = this.notificationExecutor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                DefaultNotificationManager.this.findAndFireReminders();
            }
        }, 3L, 60L, TimeUnit.MINUTES);
    }

    private void stopNotificationTasks() {
        if (this.notifierTask != null) {
            this.notifierTask.cancel(false);
        }
        if (this.notifierCleanupTask != null) {
            this.notifierCleanupTask.cancel(false);
        }
        if (this.remindersTask != null) {
            this.remindersTask.cancel(false);
        }
    }

    @Override
    public List<Notification> getNotifications(boolean toSend, Long afterDate) {
        String queryString = "from Notification as notification inner join fetch notification.noteStore";
        if (toSend || afterDate != null) {
            queryString = queryString + " where ";
        }
        if (toSend) {
            queryString = queryString + "(notification.email = :immediate or notification.email = :batch)";
            if (afterDate != null) {
                queryString = queryString + " and ";
            }
        }
        if (afterDate != null) {
            queryString = queryString + "notification.noteStore.createDateTime > :startDate";
        }
        Query q2 = DefaultNotificationManager.session().createQuery(queryString);
        if (toSend) {
            q2.setInteger("immediate", DeliverySchedule.IMMEDIATE.intValue());
            q2.setInteger("batch", DeliverySchedule.BATCH.intValue());
        }
        if (afterDate != null) {
            q2.setLong("startDate", afterDate.longValue());
        }
        return q2.list();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNotifications() {
        try {
            Logs.APP_LOG.debug((Object)"Processing notifications");
            List<Notification> notifications = this.getNotifications(true, null);
            if (!notifications.isEmpty()) {
                HibernateUtil.beginTransaction();
                for (Notification notification : notifications) {
                    try {
                        SpringContext.autowireObject(notification.getEvent());
                        if (!this.shouldTrySend(notification)) continue;
                        this.processNotification(notification);
                    }
                    catch (Exception e2) {
                        notification.setEmail(DeliverySchedule.DISABLE);
                    }
                }
                HibernateUtil.commitTransaction();
            }
        }
        catch (Exception e3) {
            Logs.APP_LOG.error((Object)"Error while processing notifications: ", (Throwable)e3);
        }
        finally {
            HibernateUtil.closeSession();
        }
    }

    private boolean shouldTrySend(Notification notification) {
        if (notification.getUser() == null || notification.getEvent() instanceof ShareContentNotificationEvent || notification.getEvent() instanceof MentionUserNotificationEvent) {
            return true;
        }
        long waitTime = 0L;
        if (this.matchDeliverySchedule(DeliverySchedule.IMMEDIATE, notification)) {
            FecruUser user = notification.getUser();
            Review review = notification.getEvent().getReview();
            waitTime = review == null || user.equals(review.getCreator()) || user.equals(review.getAuthor()) || user.equals(review.getModerator()) || notification.getEvent() instanceof ReplyNotificationEvent && user.equals(((ReplyNotificationEvent)notification.getEvent()).getComment().getUser()) ? IMMEDIATE_DIRECT_INITIAL_WAIT_TIME : IMMEDIATE_INDIRECT_INITIAL_WAIT_TIME;
        } else if (this.matchDeliverySchedule(DeliverySchedule.BATCH, notification)) {
            waitTime = BATCH_WAIT_TIME;
        } else {
            return false;
        }
        return notification.getEvent().getCreateDateTime() < System.currentTimeMillis() - waitTime;
    }

    private boolean matchDeliverySchedule(Integer ds, Notification notification) {
        return ds.equals(notification.getEvent().getEmailNotificationPref(notification.getUser()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCleanupNotifications() {
        try {
            Logs.APP_LOG.debug((Object)"Processing notification cleanup");
            Session session = DefaultNotificationManager.session();
            Query q2 = session.createQuery("select notification.id from Notification notification, Review review, NotificationEventBase event where notification.noteStore = event and notification.email = :email and event.review = review and (review.stateName = :deadState or review.stateName = :closedState or review.stateName = :rejectedState)");
            q2.setInteger("email", DeliverySchedule.SENT.intValue());
            q2.setString("deadState", StateManager.INSTANCE.getDeadState().getName());
            q2.setString("closedState", StateManager.INSTANCE.getClosedState().getName());
            q2.setString("rejectedState", StateManager.INSTANCE.getRejectedState().getName());
            List recipients = q2.list();
            long start = System.currentTimeMillis();
            Query deleteQuery = session.createQuery("delete Notification n where n.id in (:ids)");
            HqlBatchedInClauseHelper helper = new HqlBatchedInClauseHelper(deleteQuery, "ids", recipients);
            helper.executeUpdate();
            Logs.APP_LOG.debug((Object)("Deleted " + recipients.size() + " stale notifications in " + (System.currentTimeMillis() - start) + "ms"));
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)"Error while processing notification cleanups: ", (Throwable)e2);
        }
        finally {
            HibernateUtil.rollbackTransactionIfNotCommitted();
            HibernateUtil.closeSession();
        }
    }

    private boolean shouldSend(List<Notification> notifications) {
        TreeSet<Long> times = new TreeSet<Long>();
        for (Notification notification : notifications) {
            times.add(notification.getEvent().getCreateDateTime());
        }
        long firstTime = (Long)times.first();
        if ((Long)times.last() < firstTime + IMMEDIATE_MAX_WAIT_TIME) {
            long currentTime = System.currentTimeMillis();
            long prevTime = firstTime;
            for (Long time : times) {
                if (time - prevTime < IMMEDIATE_INCREMENTAL_WAIT_TIME && currentTime - time < IMMEDIATE_INCREMENTAL_WAIT_TIME) {
                    return false;
                }
                prevTime = time;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void processNotification(Notification notification) {
        Integer resultDeliverySchedule = DeliverySchedule.SENT;
        HashSet<Notification> recipientsSent = new HashSet<Notification>();
        Disposer.pushThreadInstance();
        try {
            Pair<MailMessageData, Set<Notification>> batchMessage;
            if (DeliverySchedule.SENT.equals(notification.getEmail()) || DeliverySchedule.DISABLE.equals(notification.getEmail())) {
                return;
            }
            FecruUser recipient = notification.getUser();
            HashSet permissions = Sets.newHashSet((Object[])new GlobalPermissionType[]{LicenseManager.getLicensedGlobalPermissionType()});
            if (notification.getEvent().needsCrucible()) {
                permissions.add(GlobalPermissionType.CRUCIBLE_USER);
            }
            if (!this.isDirectEmailNotification(notification, recipient) && this.isEnabledUserWithPermissions(recipient, permissions)) {
                resultDeliverySchedule = DeliverySchedule.DISABLE;
                Logs.APP_LOG.info((Object)("Disabled notification by id: " + notification.getId() + " - recipient is disabled or unlicensed"));
                return;
            }
            List<Notification> notifications = this.getRelatedNotifications(notification);
            if (!(this.shouldSend(notifications) || notification.getUser() == null || notification.getEvent() instanceof ShareContentNotificationEvent || notification.getEvent() instanceof MentionUserNotificationEvent)) {
                resultDeliverySchedule = notification.getEmail();
                return;
            }
            DefaultNotificationBatchProvider batchManager = new DefaultNotificationBatchProvider();
            BatchCreatorType messageCreator = batchManager.getBatcher(notification.getEvent());
            boolean isHtml = this.isHtmlEmail(recipient);
            if (recipient != null) {
                try {
                    this.effectiveUserProvider.pushEffectivePrincipal(this.userManager.createTrustedUserLogin(recipient.getUsername()), recipient);
                    batchMessage = this.getBatchMessage(recipient.getUserProfile().getTimezone(), recipient.getEmail(), isHtml, notifications, messageCreator);
                }
                finally {
                    this.effectiveUserProvider.popEffectivePrincipal();
                }
            } else {
                batchMessage = this.getBatchMessage(null, notification.getEmailAddress(), true, notifications, messageCreator);
            }
            if (batchMessage == null) {
                return;
            }
            recipientsSent.addAll((Collection)batchMessage.getSecond());
            MailMessageData message = batchMessage.getFirst();
            this.mailer.sendMessage(message);
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)"Error processing notification", (Throwable)e2);
            resultDeliverySchedule = DeliverySchedule.DISABLE;
        }
        finally {
            try {
                recipientsSent.add(notification);
                for (Notification r2 : recipientsSent) {
                    r2.setEmail(resultDeliverySchedule);
                }
            }
            finally {
                Disposer.popThreadInstance();
            }
        }
    }

    private boolean isDirectEmailNotification(Notification notification, FecruUser recipient) {
        return recipient == null && !Strings.isNullOrEmpty((String)notification.getEmailAddress());
    }

    private boolean isEnabledUserWithPermissions(FecruUser recipient, Set<GlobalPermissionType> permissions) {
        return recipient == null || !recipient.isEnabled() || !this.globalPermissionManager.hasPermissions(recipient.getUsername(), permissions);
    }

    private Pair<MailMessageData, Set<Notification>> getBatchMessage(String timezone, String emailAddress, boolean isHtml, List<Notification> allNotifications, BatchCreatorType messageCreator) throws IOException, TemplateException {
        Batch emailSegment;
        ArrayList<Notification> notifications = new ArrayList<Notification>();
        for (Notification notification : allNotifications) {
            NotificationEvent note = notification.getEvent();
            if (!messageCreator.accepts(notifications.isEmpty() ? null : ((Notification)notifications.get(0)).getEvent(), note)) continue;
            notifications.add(notification);
        }
        String contentType = isHtml ? "text/html; charset=UTF-8" : "text/plain; charset=UTF-8";
        TimeZone tz = null;
        if (timezone != null) {
            tz = TimeZone.getTimeZone(timezone);
        }
        if (tz == null) {
            Logs.APP_LOG.debug((Object)"Failed to get user timezone. Using server timezone.");
            tz = this.rootConfig.getTimezone();
        }
        if ((emailSegment = messageCreator.getMessageCreator().getEmailSegment(notifications, tz, isHtml)) == null) {
            return null;
        }
        MailMessageData msg = new MailMessageData();
        msg.addRecipient(emailAddress);
        msg.setSubject(emailSegment.getSubject());
        msg.setBodyText(contentType, emailSegment.getBody());
        String threadId = emailSegment.getMailThreadId();
        if (threadId != null) {
            msg.addHeader("In-Reply-To", threadId);
            msg.addHeader("References", threadId);
        }
        FecruUser actioner = emailSegment.getCommonActioner();
        String newFromName = "";
        if (actioner == null) {
            HashSet<FecruUser> actioners = new HashSet<FecruUser>();
            for (Notification notification : notifications) {
                actioners.add(notification.getEvent().getActioner());
            }
            actioner = (FecruUser)actioners.iterator().next();
            if (actioners.size() > 1) {
                newFromName = " + " + (actioners.size() - 1) + ExpressionUtil.pluralise(" other", " others", actioners.size() - 1);
            }
        }
        newFromName = actioner == null ? "" : actioner.getDisplayName() + newFromName;
        msg.setFromDisplayName(newFromName);
        if (!this.mailer.getUseFrom() && actioner != null) {
            msg.setFrom(actioner.getEmail());
        }
        return Pair.newInstance(msg, emailSegment.getNotifications());
    }

    private boolean isHtmlEmail(FecruUser user) {
        if (user == null) {
            return true;
        }
        try {
            return this.userProfileManager.getProfile(user.getUsername()).isHtmlEmailFormat();
        }
        catch (DbException e2) {
            Logs.APP_LOG.error((Object)("Could not get user profile for " + user.getUsername()), (Throwable)e2);
            return false;
        }
    }

    private List<Notification> getRelatedNotifications(Notification notification) {
        Review review = notification.getEvent().getReview();
        if (review == null) {
            return Collections.singletonList(notification);
        }
        Query q2 = DefaultNotificationManager.session().createQuery("from Notification where (email = :immediate or email = :batch) and user = :user and noteStore.review = :review");
        q2.setInteger("immediate", DeliverySchedule.IMMEDIATE.intValue());
        q2.setInteger("batch", DeliverySchedule.BATCH.intValue());
        q2.setEntity("user", (Object)notification.getUser());
        q2.setEntity("review", (Object)review);
        List list = q2.list();
        for (Notification n2 : list) {
            SpringContext.autowireObject(n2.getEvent());
        }
        return list;
    }

    private static Session session() {
        return HibernateUtil.currentSession();
    }

    @PreDestroy
    public void onDestroy() {
        this.eventPublisher.unregister((Object)this);
    }

    @Override
    public void noteGeneralMsg(Review review, FecruUser user, FecruUser to, String message) {
        GeneralNotificationEvent note = new GeneralNotificationEvent(user, review, message);
        DefaultNotificationManager.session().save((Object)note);
        if (to == null) {
            ((NotificationEvent)note).doNotify();
        } else {
            note.doNotify(to);
        }
    }

    @Override
    public void noteFRXRevisionAdded(Review review, FRXRevision frxRev, FecruUser user) {
        if (!review.getState().isDraftState()) {
            RevisionAddedNotificationEvent note = new RevisionAddedNotificationEvent(user, review, frxRev);
            DefaultNotificationManager.session().save((Object)note);
            ((NotificationEvent)note).doNotify();
        }
    }

    @Override
    public void notePluginMsg(FecruUser actioner, Set<FecruUser> recipients, String groupType, String subject, String htmlBody, String textBody) {
        PluginNotificationEvent note = new PluginNotificationEvent(actioner, groupType, subject, htmlBody, textBody);
        DefaultNotificationManager.session().save((Object)note);
        for (FecruUser recipient : recipients) {
            note.doNotify(recipient);
        }
    }

    @Override
    public void doShareContent(final ShareContentNotificationEvent notificationEvent) {
        this.txTemplate.execute(new TxCallback<Void>(){

            @Override
            public Void doInTransaction(TransactionStatus status) throws Exception {
                DefaultNotificationManager.session().save((Object)notificationEvent);
                notificationEvent.doNotify();
                return null;
            }
        });
    }

    public static void deleteNotifications(Review review) {
        Query q2 = DefaultNotificationManager.session().createQuery("delete Notification notification where notification.noteStore in (select event from NotificationEventBase event where event.review = :review)");
        q2.setEntity("review", (Object)review);
        q2.executeUpdate();
        q2 = DefaultNotificationManager.session().createQuery("delete NotificationEventBase event where event.review = :review");
        q2.setEntity("review", (Object)review);
        q2.executeUpdate();
    }

    public void findAndFireReminders() {
        if (!this.mailer.isConfigured()) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        final long now = calendar.getTimeInMillis();
        calendar.add(10, -1);
        final long last = calendar.getTimeInMillis();
        this.txTemplate.execute(new TxCallback<Object>(){

            @Override
            public Object doInTransaction(TransactionStatus status) throws Exception {
                Query query = DefaultNotificationManager.session().createQuery("from Review review where review.dueDateTime is not null and review.stateName = :stateName and review.reviewType = :reviewType and (:min < review.reminderDateTime and review.reminderDateTime <= :max)").setLong("min", last).setLong("max", now).setString("stateName", StateManager.INSTANCE.getReviewState().getName()).setInteger("reviewType", Review.ReviewType.REVIEW.getId());
                HibernateUtil.withIterator(query, new Function<Iterator<Review>, Void>(){

                    public Void apply(Iterator<Review> it) {
                        while (it.hasNext()) {
                            Review review = it.next();
                            DefaultNotificationManager.this.eventPublisher.publish((Object)new ReviewReminderEvent(review.getPermId(), null));
                        }
                        return null;
                    }
                });
                return null;
            }
        });
    }
}

