/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification;

import com.atlassian.crucible.event.cscomment.CsCommentEvent;
import com.atlassian.crucible.spi.PermId;
import com.atlassian.crucible.spi.data.CsCommentData;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.model.ChangesetComment;
import com.atlassian.fisheye.model.managers.ChangesetCommentManager;
import com.atlassian.fisheye.user.permissions.GlobalPermissionManager;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.cenqua.crucible.notification.CsCommentNotificationEvent;
import com.cenqua.crucible.notification.NotificationEvent;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.UserManager;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CsCommentAddedEventNotificationCreator {
    private final ChangesetCommentManager changesetCommentManager;
    private final RepositoryManager repositoryManager;
    private final UserManager userManager;
    private final CommitterUserMappingManager committerUserMappingManager;
    private final GlobalPermissionManager globalPermissionManager;

    @Autowired
    public CsCommentAddedEventNotificationCreator(UserManager userManager, RepositoryManager repositoryManager, CommitterUserMappingManager committerUserMappingManager, ChangesetCommentManager changesetCommentManager, GlobalPermissionManager globalPermissionManager) {
        this.userManager = userManager;
        this.repositoryManager = repositoryManager;
        this.committerUserMappingManager = committerUserMappingManager;
        this.changesetCommentManager = changesetCommentManager;
        this.globalPermissionManager = globalPermissionManager;
    }

    public List<NotificationEvent> createNotification(CsCommentEvent event) {
        String repositoryName;
        RepositoryHandle rh;
        ChangesetComment comment = this.changesetCommentManager.getComment((PermId<CsCommentData>)event.getCommentId());
        ArrayList notificationEvents = Lists.newArrayList();
        if (comment != null && !comment.isDraft() && (rh = this.repositoryManager.getRepository(repositoryName = event.getRepositoryName())) != null) {
            try {
                Object cs = rh.acquireEngine().getRevisionCache().getChangeSet(event.getChangeSetId());
                if (cs != null) {
                    String author = cs.getAuthor();
                    Optional<FecruUser> mappedUser = Optional.ofNullable(this.committerUserMappingManager.getUserForCommitter(repositoryName, author));
                    HashSet<FecruUser> csParticipants = new HashSet<FecruUser>();
                    mappedUser.filter(user -> this.globalPermissionManager.hasPermission(user.getUsername(), GlobalPermissionType.CRUCIBLE_USER)).ifPresent(csParticipants::add);
                    List<ChangesetComment> commentsForChangeset = this.changesetCommentManager.getCommentsForChangeset(repositoryName, cs.getId());
                    for (ChangesetComment changesetComment : commentsForChangeset) {
                        csParticipants.add(changesetComment.getUser());
                    }
                    FecruUser actioner = this.userManager.getLicensedUser(event.getActioner().getUserName());
                    csParticipants.remove(actioner);
                    for (FecruUser csParticipant : csParticipants) {
                        notificationEvents.add(new CsCommentNotificationEvent(csParticipant, actioner, cs.getRepName(), cs.getId(), (PermId<CsCommentData>)event.getCommentId()));
                    }
                } else {
                    Logs.APP_LOG.warn((Object)("Changeset " + event.getChangeSetId() + " for comment event could not be found"));
                }
            }
            catch (Exception e2) {
                Logs.APP_LOG.error((Object)"Could not send changeset comment notification", (Throwable)e2);
            }
        }
        return notificationEvents;
    }
}

