/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.Role;
import com.cenqua.crucible.model.managers.DefaultCommentManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.notification.BaseReviewNotificationEvent;
import com.cenqua.crucible.notification.DeliverySchedule;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.crucible.util.HtmlAndTextPair;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class CommentPropertiesChangedNotificationEvent
extends BaseReviewNotificationEvent {
    private static final Logger log = Logs.loggerFor(CommentPropertiesChangedNotificationEvent.class);
    private static final String HEADER_NOTE_HTML = "headerNoteHtml";
    private static final String HEADER_NOTE_PLAIN_TEXT = "headerNotePlainText";
    private static final String COMMENT_NOTE_HTML = "commentNoteHtml";
    private static final String COMMENT_NOTE_PLAIN_TEXT = "commentNotePlainText";
    private Comment comment;
    private Properties changeDetails;

    public CommentPropertiesChangedNotificationEvent() {
    }

    public CommentPropertiesChangedNotificationEvent(FecruUser actioner, Review review, Comment comment, HtmlAndTextPair headerNote, HtmlAndTextPair commentNote) {
        super(actioner);
        this.setComment(comment);
        this.setReview(review);
        this.changeDetails = new Properties();
        this.changeDetails.put(HEADER_NOTE_HTML, headerNote.getHtml());
        this.changeDetails.put(HEADER_NOTE_PLAIN_TEXT, headerNote.getPlainText());
        this.changeDetails.put(COMMENT_NOTE_HTML, commentNote.getHtml());
        this.changeDetails.put(COMMENT_NOTE_PLAIN_TEXT, commentNote.getPlainText());
        StringWriter writer = new StringWriter();
        try {
            this.changeDetails.store(writer, "UTF-8");
            writer.close();
        }
        catch (IOException e2) {
            throw new RuntimeException("Could not store the note values to the note property", e2);
        }
        this.setNote(writer.toString());
    }

    @Override
    public Integer getType() {
        return NotificationManager.TYPE_COMMENT_PROPERTIES_CHANGE;
    }

    @Override
    public List<Role> getRolesToNotify() {
        return ImmutableList.of((Object)ReviewManager.AUTHOR, (Object)ReviewManager.MODERATOR, (Object)ReviewManager.REVIEWER);
    }

    @Override
    public Set<FecruUser> getUsersToNotify() {
        HashSet users = Sets.newHashSet();
        users.addAll(super.getUsersToNotify());
        for (Comment comment = this.getComment(); comment != null; comment = comment.getReplyToComment()) {
            users.add(comment.getUser());
        }
        return users;
    }

    @Override
    public String getDescription() {
        return "Comment properties change";
    }

    @Override
    public Integer getEmailNotificationPref(@Nonnull FecruUser user) {
        return DeliverySchedule.IMMEDIATE;
    }

    @Nonnull
    private Properties getChangeDetails() {
        if (this.changeDetails == null) {
            this.changeDetails = new Properties();
            try {
                this.changeDetails.load(new StringReader(this.getNote()));
            }
            catch (IOException e2) {
                log.error((Object)"Could not load the note values from the note property", (Throwable)e2);
            }
        }
        return this.changeDetails;
    }

    @Nullable
    public Comment getComment() {
        if (this.comment == null && this.getRef1() != null) {
            this.comment = DefaultCommentManager.getInstance().getById(this.getRef1());
            if (this.comment == null) {
                log.warn((Object)String.format("Comment with ID %d doesn't exist", this.getRef1()));
            }
        }
        return this.comment;
    }

    public void setComment(@Nonnull Comment comment) {
        this.comment = comment;
        this.setRef1(comment.getId());
    }

    @Nonnull
    public HtmlAndTextPair getHeaderNote() {
        return HtmlAndTextPair.of(this.getChangeDetails().getProperty(HEADER_NOTE_HTML), this.getChangeDetails().getProperty(HEADER_NOTE_PLAIN_TEXT));
    }

    @Nonnull
    public HtmlAndTextPair getCommentNote() {
        return HtmlAndTextPair.of(this.getChangeDetails().getProperty(COMMENT_NOTE_HTML), this.getChangeDetails().getProperty(COMMENT_NOTE_PLAIN_TEXT));
    }
}

