/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.Role;
import com.cenqua.crucible.model.managers.DefaultCommentManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.crucible.notification.ReviewCommentNotificationEvent;
import com.cenqua.fisheye.logging.Logs;
import java.util.LinkedList;
import java.util.List;

public class CommentNotificationEvent
extends ReviewCommentNotificationEvent {
    private Comment comment;

    public CommentNotificationEvent() {
    }

    public CommentNotificationEvent(Review review, Comment comment) {
        super(comment.getUser(), review);
        this.setComment(comment);
    }

    public boolean isDefect() {
        return this.comment.isDefectRaised();
    }

    @Override
    public Integer getType() {
        return NotificationManager.TYPE_COMMENTED;
    }

    @Override
    public Comment getComment() {
        if (this.comment == null) {
            this.comment = DefaultCommentManager.getInstance().getById(this.getRef1());
            if (this.comment == null) {
                Logs.APP_LOG.warn((Object)("Comment " + this.getRef1() + "doesn't exist."));
            }
        }
        return this.comment;
    }

    @Override
    public Long getLatestChangeTime() {
        Comment comment = this.getComment();
        Long updated = null;
        if (comment != null && (updated = comment.getUpdatedDateTime()) == null) {
            updated = comment.getCreateDateTime();
        }
        return updated;
    }

    public void setComment(Comment comment) {
        this.comment = comment;
        this.setRef1(comment.getId());
    }

    @Override
    public String getDescription() {
        return this.getComment() != null && this.getComment().isDefectRaised() ? "Defect" : "Comment";
    }

    @Override
    public List<Role> getRolesToNotify() {
        LinkedList<Role> roles = new LinkedList<Role>();
        roles.add(ReviewManager.AUTHOR);
        roles.add(ReviewManager.MODERATOR);
        roles.add(ReviewManager.REVIEWER);
        return roles;
    }

    @Override
    public Integer getEmailNotificationPref(FecruUser user) {
        return user.getUserProfile().getCommentEmailNotification();
    }

    @Override
    public FileRevisionExtraInfo getFrx() {
        Comment c2 = this.getComment();
        if (c2 == null) {
            return null;
        }
        return DefaultCommentManager.getInstance().getFrxForComment(c2);
    }

    @Override
    protected boolean getResetCompletionPreference(FecruUser user) {
        boolean resetCompletion = user.getUserProfile().getUncompleteOnDefect() && !this.getComment().getUser().equals(user);
        return this.getComment() != null && this.getComment().isDefectRaised() && resetCompletion;
    }

    @Override
    public String getBody() {
        FileRevisionExtraInfo frx = this.getFrx();
        if (frx == null) {
            return "";
        }
        return "File: " + frx.getFileRevision().getPath() + "; Revision: " + frx.getFileRevision().getRevisionDisplayName();
    }
}

