/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification;

import com.atlassian.crucible.spi.PermId;
import com.atlassian.crucible.spi.data.CsCommentData;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.model.ChangesetComment;
import com.atlassian.fisheye.model.managers.ChangesetCommentManager;
import com.cenqua.crucible.notification.NotificationEvent;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.web.util.CheckinCommentFormatter;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

public abstract class BaseCsCommentNotificationEvent
extends NotificationEvent {
    private ChangesetComment comment;
    private FecruUser recipient;
    private ChangeSet changeSet;
    private RepositoryEngine repositoryEngine;

    public BaseCsCommentNotificationEvent() {
    }

    public BaseCsCommentNotificationEvent(FecruUser recipient, FecruUser actioner, String repo, String csid, PermId<CsCommentData> commentId) {
        super(actioner);
        this.recipient = recipient;
        this.setNote(repo + "|" + csid + "|" + commentId.getId());
    }

    public ChangesetComment getComment() {
        if (this.comment == null && this.getPermId() != null) {
            this.comment = SpringContext.getComponentByClass(ChangesetCommentManager.class).getComment(this.getPermId());
            if (this.comment == null) {
                Logs.APP_LOG.warn((Object)("Comment " + this.getPermId() + " doesn't exist."));
            }
        }
        return this.comment;
    }

    public void setComment(ChangesetComment comment) {
        this.comment = comment;
        this.setRef1(comment.getId());
    }

    public String getRepository() {
        return this.getNoteSeg(0);
    }

    public String getCsid() {
        return this.getNoteSeg(1);
    }

    private PermId<CsCommentData> getPermId() {
        String id = this.getNoteSeg(2);
        return id == null ? null : new PermId(id);
    }

    private String getNoteSeg(int n2) {
        String[] segs = StringUtils.defaultString((String)this.getNote()).split("\\|");
        if (segs.length > n2) {
            return segs[n2];
        }
        return null;
    }

    public RepositoryConfig getRepConfig() {
        return this.getRepositoryEngine().getCfg();
    }

    private RepositoryEngine getRepositoryEngine() {
        if (this.repositoryEngine == null) {
            try {
                RepositoryHandle repHandle = AppConfig.getsConfig().getRepositoryManager().getRepository(this.getRepository());
                this.repositoryEngine = repHandle.acquireEngine();
            }
            catch (RepositoryHandle.StateException e2) {
                Logs.APP_LOG.error((Object)"Could not aquire repository engine", (Throwable)((Object)e2));
            }
        }
        return this.repositoryEngine;
    }

    public ChangeSet getChangeSet() {
        if (this.changeSet == null) {
            try {
                this.changeSet = this.getRepositoryEngine().getRevisionCache().getChangeSet(this.getCsid());
            }
            catch (DbException e2) {
                Logs.APP_LOG.error((Object)"Could not retrieve changeset", (Throwable)e2);
            }
        }
        return this.changeSet;
    }

    @Override
    public String getEmailSubject() {
        ChangeSet cs = this.getChangeSet();
        String message = "";
        try {
            message = ": " + CheckinCommentFormatter.format(this.getRepositoryEngine().getCfg(), cs.getComment(), cs.getDateValue(), 80, false, false);
        }
        catch (IOException e2) {
            Logs.APP_LOG.error((Object)"Could not format changeset comment", (Throwable)e2);
        }
        return this.getRepository() + ":/" + cs.getDisplayId() + " by " + cs.getAuthor() + message;
    }

    public String getThreadKey() {
        return this.getRepository() + "-" + this.getChangeSet().getId();
    }

    @Override
    public String getDescription() {
        return "Changeset comment " + (this.getComment() == null ? "deleted" : "added");
    }

    @Override
    public void doNotify() {
        this.createAndAddRecipient(this.recipient);
    }

    @Override
    public Integer getEmailNotificationPref(FecruUser user) {
        return user.getUserProfile().getCommentEmailNotification();
    }
}

