/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers.impl;

import com.atlassian.fisheye.StoppableVisitor;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.model.managers.SecureProjectManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.util.HqlBatchedInClauseHelper;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.user.GroupMembershipManager;
import com.cenqua.fisheye.user.UserManager;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins
@Component(value="secureProjectManager")
public class DefaultSecureProjectManager
implements SecureProjectManager {
    private final PermissionManager permissionManager;
    private final GroupMembershipManager groupMembershipManager;
    private final ProjectManager projectManager;
    private final RootConfig rootConfig;
    private final CurrentSessionProvider currentSessionProvider;

    @Autowired
    public DefaultSecureProjectManager(PermissionManager permissionManager, GroupMembershipManager groupMembershipManager, ProjectManager projectManager, RootConfig rootConfig, CurrentSessionProvider currentSessionProvider) {
        this.permissionManager = permissionManager;
        this.groupMembershipManager = groupMembershipManager;
        this.projectManager = projectManager;
        this.rootConfig = rootConfig;
        this.currentSessionProvider = currentSessionProvider;
    }

    @Override
    public List<Project> getProjectsCanCreateIn(Principal principal) {
        return this.getProjectsCanDoActionIn(principal, UserActionManager.Action.ACTION_CREATE);
    }

    @Override
    public List<Project> getVisibleProjects(Principal principal) {
        return this.getProjectsCanDoActionIn(principal, UserActionManager.Action.ACTION_VIEW);
    }

    private boolean isAdmin(Principal principal) {
        return Principal.SuperUser.isSuperUser((Principal)principal);
    }

    @Override
    public List<Project> getProjectsCanDoActionIn(Principal principal, UserActionManager.Action action) {
        List<String> groups;
        if (this.isAdmin(principal)) {
            return this.projectManager.getAllProjects();
        }
        if (this.permissionManager.isActionPreventedByLicense(action.getName(), principal == null ? null : principal)) {
            return Collections.emptyList();
        }
        if (Principal.Anonymous.isAnon((Principal)principal)) {
            if (this.rootConfig.isAnonAccessAllowed() && this.rootConfig.isCruAnonAccessAllowed()) {
                return HibernateUtil.typedList(this.anonPermsQuery(action).setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY));
            }
            if (!this.rootConfig.isCruAnonAccessAllowed()) {
                return Collections.emptyList();
            }
        }
        if ((groups = this.getNormalisedGroupsForUser(principal.getUserName())).isEmpty()) {
            Query q2 = this.anonAllUserSpecificUserQuery(principal, action);
            q2.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
            return HibernateUtil.typedList(q2);
        }
        Query q3 = this.anonAllUserSpecificUserGroupsQuery(principal, action);
        final LinkedHashSet results = new LinkedHashSet();
        HqlBatchedInClauseHelper<String> batcher = new HqlBatchedInClauseHelper<String>(q3, "groups", groups);
        batcher.execute(new StoppableVisitor<Project>(){

            @Override
            public boolean visit(Project project) {
                results.add(project);
                return true;
            }
        }, false);
        return Lists.newArrayList(results);
    }

    private List<String> getNormalisedGroupsForUser(String userName) {
        return this.groupMembershipManager.getGroupsForUser(userName).stream().map(UserManager.GROUPNAME_NORMALIZATION).collect(Collectors.toList());
    }

    @Override
    public boolean isAtLeastOneProjectCanDoActionIn(Principal principal, UserActionManager.Action action) {
        if (Principal.SuperUser.isSuperUser((Principal)principal)) {
            return true;
        }
        if (this.permissionManager.isActionPreventedByLicense(action.getName(), principal)) {
            return false;
        }
        if (Principal.Anonymous.isAnon((Principal)principal) && this.rootConfig.isAnonAccessAllowed() && this.rootConfig.isCruAnonAccessAllowed()) {
            return this.anonPermsQuery(action).setMaxResults(1).uniqueResult() != null;
        }
        List<String> groups = this.getNormalisedGroupsForUser(principal.getUserName());
        if (groups.isEmpty()) {
            return this.anonAllUserSpecificUserQuery(principal, action).setMaxResults(1).uniqueResult() != null;
        }
        Query q2 = this.anonAllUserSpecificUserGroupsQuery(principal, action);
        HqlBatchedInClauseHelper<String> batcher = new HqlBatchedInClauseHelper<String>(q2, "groups", groups);
        AtomicBoolean result = new AtomicBoolean(false);
        batcher.execute(project -> {
            result.set(true);
            return false;
        }, true);
        return result.get();
    }

    private Query anonAllUserSpecificUserGroupsQuery(Principal principal, UserActionManager.Action action) {
        Query q2 = this.currentSessionProvider.currentSession().createQuery("select project from Project project left outer join project.permissionScheme.anonymousPAs anon left outer join project.permissionScheme.allUsersPAs allusers left outer join project.permissionScheme.userPAs user left outer join project.permissionScheme.groupPAs grp where (anon.actionName = :action) or (allusers.actionName = :action) or (user.actionName = :action and user.pid = :username) or (grp.actionName = :action and grp.pid in (:groups)) order by project.projKey").setCacheable(true);
        q2.setString("action", action.getName());
        q2.setString("username", UserManager.USERNAME_NORMALIZATION.apply(principal.getUserName()));
        q2.setCacheable(true);
        return q2;
    }

    private Query anonAllUserSpecificUserQuery(Principal principal, UserActionManager.Action action) {
        Query q2 = this.currentSessionProvider.currentSession().createQuery("select project from Project project left outer join project.permissionScheme.anonymousPAs anon left outer join project.permissionScheme.allUsersPAs allusers left outer join project.permissionScheme.userPAs users where (anon.actionName = :action) or (allusers.actionName = :action) or (users.actionName = :action and users.pid = :username) order by project.projKey").setCacheable(true);
        q2.setString("action", action.getName());
        q2.setString("username", UserManager.USERNAME_NORMALIZATION.apply(principal.getUserName()));
        q2.setCacheable(true);
        return q2;
    }

    private Query anonPermsQuery(UserActionManager.Action action) {
        Query q2 = this.currentSessionProvider.currentSession().createQuery("select project from Project project, AnonymousPA pa where pa.actionName = :action and project.permissionScheme = pa.ps order by project.projKey").setCacheable(true);
        q2.setString("action", action.getName());
        q2.setCacheable(true);
        return q2;
    }
}

