/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers.impl;

import com.atlassian.crucible.spi.TxCallback;
import com.atlassian.crucible.spi.services.NotFoundException;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.fugue.Option;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.model.PermaIdFormatException;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewProperty;
import com.cenqua.crucible.model.dao.ReviewPropertyDAO;
import com.cenqua.crucible.model.dao.ReviewPropertyDAOSearchCriteria;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.ReviewPropertiesManager;
import com.cenqua.crucible.model.managers.ReviewPropertiesSearchCriteria;
import com.cenqua.crucible.model.managers.ReviewPropertyData;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;

@Component
@AvailableToPlugins
public class DefaultReviewPropertiesManager
implements ReviewPropertiesManager {
    private final ReviewPropertyDAO reviewPropertyDAO;
    private final ReviewManager reviewManager;
    private final TxTemplate txTemplate;

    @Autowired
    public DefaultReviewPropertiesManager(ReviewPropertyDAO reviewPropertyDAO, ReviewManager reviewManager, TxTemplate txTemplate) {
        this.reviewPropertyDAO = reviewPropertyDAO;
        this.reviewManager = reviewManager;
        this.txTemplate = txTemplate;
    }

    @Override
    public String get(final String reviewPermaId, final String name) {
        return this.txTemplate.execute(new TxCallback<String>(){

            @Override
            public String doInTransaction(TransactionStatus status) throws Exception {
                Review review = DefaultReviewPropertiesManager.this.getRequiredReview(reviewPermaId);
                Option<ReviewProperty> reviewProperty = DefaultReviewPropertiesManager.this.reviewPropertyDAO.get(review, name);
                return DefaultReviewPropertiesManager.this.getValue((Option<ReviewProperty>)reviewProperty);
            }
        });
    }

    @Override
    public String put(final String reviewPermaId, final String name, final String value) {
        return this.txTemplate.execute(new TxCallback<String>(){

            @Override
            public String doInTransaction(TransactionStatus status) throws Exception {
                Review review = DefaultReviewPropertiesManager.this.getRequiredReview(reviewPermaId);
                return (String)DefaultReviewPropertiesManager.this.reviewPropertyDAO.put(review, name, value).getOrNull();
            }
        });
    }

    @Override
    public String remove(final String reviewPermaId, final String name) {
        return this.txTemplate.execute(new TxCallback<String>(){

            @Override
            public String doInTransaction(TransactionStatus status) throws Exception {
                Review review = DefaultReviewPropertiesManager.this.getRequiredReview(reviewPermaId);
                return (String)DefaultReviewPropertiesManager.this.reviewPropertyDAO.remove(review, name).getOrNull();
            }
        });
    }

    @Override
    public Iterable<ReviewPropertyData> list(final ReviewPropertiesSearchCriteria searchCriteria) {
        return this.txTemplate.execute(new TxCallback<List<ReviewPropertyData>>(){

            @Override
            public List<ReviewPropertyData> doInTransaction(TransactionStatus status) throws Exception {
                Review review;
                if (searchCriteria.getReviewPermaId() != null) {
                    review = DefaultReviewPropertiesManager.this.getRequiredReview(searchCriteria.getReviewPermaId());
                    if (review == null) {
                        return Collections.emptyList();
                    }
                } else {
                    review = null;
                }
                Iterable reviewStates = searchCriteria.getReviewStates() != null ? Iterables.transform(searchCriteria.getReviewStates(), (Function)Functions.toStringFunction()) : null;
                ReviewPropertyDAOSearchCriteria daoSearchCriteria = new ReviewPropertyDAOSearchCriteria(review, searchCriteria.getNames(), searchCriteria.getNamePrefix(), reviewStates, searchCriteria.getLimit());
                List<ReviewProperty> reviewProperties = DefaultReviewPropertiesManager.this.reviewPropertyDAO.list(daoSearchCriteria);
                return ImmutableList.copyOf((Iterable)Iterables.transform(reviewProperties, (Function)new Function<ReviewProperty, ReviewPropertyData>(){

                    public ReviewPropertyData apply(ReviewProperty reviewProperty) {
                        return new ReviewPropertyData(reviewProperty.getReview().getPermaId(), reviewProperty.getName(), reviewProperty.getValue());
                    }
                }));
            }
        });
    }

    private Review getRequiredReview(String reviewPermaId) throws NotFoundException {
        try {
            return this.reviewManager.getReviewByPermaId(reviewPermaId);
        }
        catch (PermaIdFormatException e2) {
            return null;
        }
    }

    private String getValue(Option<ReviewProperty> reviewProperty) {
        return reviewProperty.isEmpty() ? null : ((ReviewProperty)reviewProperty.get()).getValue();
    }
}

