/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers.impl;

import com.atlassian.crucible.activity.lucene.ReviewItemIndexer;
import com.atlassian.crucible.activity.review.CrucibleReviewQueryBuilder;
import com.atlassian.crucible.configuration.metrics.MetricsManager;
import com.atlassian.crucible.event.ReviewCreatedEventImpl;
import com.atlassian.crucible.event.ReviewDeletedEventImpl;
import com.atlassian.crucible.spi.PermId;
import com.atlassian.crucible.spi.data.ReviewData;
import com.atlassian.crucible.spi.impl.SPIUserUtils;
import com.atlassian.crucible.spi.services.AuthorizationException;
import com.atlassian.crucible.spi.services.NotFoundException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.review.ParticipantDAO;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.Visitor;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FRXRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Patch;
import com.cenqua.crucible.model.PermaIdFormatException;
import com.cenqua.crucible.model.PermaIdKey;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewParticipant;
import com.cenqua.crucible.model.Role;
import com.cenqua.crucible.model.State;
import com.cenqua.crucible.model.StateChangeLog;
import com.cenqua.crucible.model.StateTransition;
import com.cenqua.crucible.model.dao.CrucibleActivityItemDAO;
import com.cenqua.crucible.model.dao.FileRevisionExtraInfoDAO;
import com.cenqua.crucible.model.dao.ReviewDAO;
import com.cenqua.crucible.model.dao.ReviewPermaIdDAO;
import com.cenqua.crucible.model.dao.ReviewPropertyDAO;
import com.cenqua.crucible.model.dao.StateChangeLogDAO;
import com.cenqua.crucible.model.managers.ActionManager;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.FileRevisionManager;
import com.cenqua.crucible.model.managers.InviteManager;
import com.cenqua.crucible.model.managers.LogManager;
import com.cenqua.crucible.model.managers.LogRecordProcessor;
import com.cenqua.crucible.model.managers.ParticipantManager;
import com.cenqua.crucible.model.managers.PatchManager;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.model.managers.ReviewIterator;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.StateManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.notification.DefaultNotificationManager;
import com.cenqua.crucible.tags.ReviewUtil;
import com.cenqua.crucible.upload.UploadItem;
import com.cenqua.crucible.upload.UploadManager;
import com.cenqua.crucible.util.ReviewSort;
import com.cenqua.crucible.view.reviewfilters.ReviewFilterDef;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.util.DateHelper;
import com.cenqua.fisheye.util.ISO8601DateHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.HibernateException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AvailableToPlugins
public class DefaultReviewManager
implements ReviewManager {
    private static final int COUNT_WARNING = 500;
    private final EventPublisher eventPublisher;
    private final ParticipantDAO participantDAO;
    private ReviewItemIndexer reviewItemIndexer;
    private final ActionManager actionManager;
    private SPIUserUtils spiUserUtils;
    private final CommentManager commentManager;
    private final ReviewPropertyDAO reviewPropertyDAO;
    private final ReviewDAO reviewDAO;
    private final StateChangeLogDAO stateChangeLogDAO;
    private final FileRevisionExtraInfoDAO fileRevisionExtraInfoDAO;
    private final CrucibleActivityItemDAO crucibleActivityItemDAO;
    private final ReviewPermaIdDAO reviewPermaIdDAO;
    private final PatchManager patchManager;
    private final TxTemplate txTemplate;
    private static final Map<String, Role> ROLE_BY_LOWER_CASE_NAME = ImmutableMap.of((Object)AUTHOR.getName().toLowerCase(Locale.US), (Object)AUTHOR, (Object)MODERATOR.getName().toLowerCase(Locale.US), (Object)MODERATOR, (Object)REVIEWER.getName().toLowerCase(Locale.US), (Object)REVIEWER, (Object)CREATOR.getName().toLowerCase(Locale.US), (Object)CREATOR);
    private static final EnumMap<ReviewSort, Sort> LUCENE_SORT_FIELDS = new EnumMap<ReviewSort, Sort>(ReviewSort.class){
        {
            this.put(ReviewSort.STATE, new Sort(new SortField("state", 3)));
            this.put(ReviewSort.REVIEW, new Sort(new SortField[]{new SortField("projectKey", 3), new SortField("permaIdNumber", 4)}));
            this.put(ReviewSort.OWNER, new Sort(new SortField("owner", 3)));
            this.put(ReviewSort.NAME, new Sort(new SortField("reviewTitleSort", 3)));
            this.put(ReviewSort.FILES, new Sort(new SortField("countFrxs", 4)));
            this.put(ReviewSort.COMMENTS, new Sort(new SortField("countComments", 4)));
            this.put(ReviewSort.AGE, new Sort(new SortField("createTime", 6)));
            this.put(ReviewSort.DUE, new Sort(new SortField[]{new SortField("dueTime", 6), new SortField("createTime", 6)}));
            this.put(ReviewSort.REVIEWERS, new Sort(new SortField("countReviewers", 4)));
        }
    };
    private static ReviewManager instance;

    private static Sort getLuceneSort(ReviewSort reviewSort) {
        Sort sort = LUCENE_SORT_FIELDS.get((Object)reviewSort);
        if (sort != null) {
            return sort;
        }
        return LUCENE_SORT_FIELDS.get((Object)ReviewSort.DUE);
    }

    @Autowired
    public DefaultReviewManager(EventPublisher eventPublisher, ActionManager actionManager, SPIUserUtils spiUserUtils, CommentManager commentManager, ParticipantDAO participantDAO, ReviewPropertyDAO reviewPropertyDAO, ReviewDAO reviewDAO, StateChangeLogDAO stateChangeLogDAO, FileRevisionExtraInfoDAO fileRevisionExtraInfoDAO, CrucibleActivityItemDAO crucibleActivityItemDAO, ReviewPermaIdDAO reviewPermaIdDAO, PatchManager patchManager, TxTemplate txTemplate) {
        this.eventPublisher = eventPublisher;
        this.actionManager = actionManager;
        this.spiUserUtils = spiUserUtils;
        this.commentManager = commentManager;
        this.participantDAO = participantDAO;
        this.reviewPropertyDAO = reviewPropertyDAO;
        this.reviewDAO = reviewDAO;
        this.stateChangeLogDAO = stateChangeLogDAO;
        this.fileRevisionExtraInfoDAO = fileRevisionExtraInfoDAO;
        this.crucibleActivityItemDAO = crucibleActivityItemDAO;
        this.reviewPermaIdDAO = reviewPermaIdDAO;
        this.patchManager = patchManager;
        this.txTemplate = txTemplate;
        DefaultReviewManager.set(this);
    }

    @Autowired
    public void setReviewItemIndexer(ReviewItemIndexer reviewItemIndexer) {
        this.reviewItemIndexer = reviewItemIndexer;
    }

    public static ReviewManager get() {
        if (instance == null) {
            instance = SpringContext.getComponentByClass(ReviewManager.class);
        }
        return instance;
    }

    public static void set(ReviewManager reviewManager) {
        instance = reviewManager;
    }

    @Override
    public Review createSnippetReviewWithDefaults(ProjectManager projectManager, Project project, String name, FecruUser creator) {
        Review review = this.doCreateReview(projectManager, project, Review.ReviewType.SNIPPET, name, creator, StateManager.INSTANCE.getSnippetOpenState());
        if (!StringUtils.isEmpty((String)project.getDefaultRepositoryName())) {
            review.setDefaultSource(project.getDefaultRepositoryName());
        }
        review.setAllowReviewerToJoin(true);
        review.setDescription(StringUtils.defaultString((String)project.getDefaultObjectives()));
        this.sendReviewCreatedEvent(review, creator);
        return review;
    }

    @Override
    public Review createReviewWithDefaults(ProjectManager projectManager, Project project, String name, FecruUser creator) throws DbException {
        Review review = this.doCreateReview(projectManager, project, Review.ReviewType.REVIEW, name, creator);
        if (project.isModeratorEnabled()) {
            if (project.getDefaultModerator() != null) {
                review.setModerator(project.getDefaultModerator());
            } else {
                review.setModerator(creator);
            }
        }
        if (!StringUtils.isEmpty((String)project.getDefaultRepositoryName())) {
            review.setDefaultSource(project.getDefaultRepositoryName());
        }
        Set<FecruUser> reviewers = project.getDefaultReviewers();
        for (FecruUser reviewer : reviewers) {
            this.addReviewer(review, reviewer);
        }
        Date nowRounded = DateHelper.getNearestHalfHour(new Date());
        Date dueDate = null;
        Date reminderDate = null;
        Integer duration = project.getDefaultDuration();
        if (duration != null && duration > 0) {
            TimeZone timeZone = AppConfig.getUserTimeZone(creator.getUsername());
            dueDate = ISO8601DateHelper.addWorkingDays(nowRounded, duration, timeZone);
            if (duration > 1) {
                reminderDate = ISO8601DateHelper.addWorkingDays(dueDate, -1, timeZone);
            }
        }
        review.setDueDate(dueDate);
        review.setReminderDate(reminderDate);
        review.setAllowReviewerToJoin(project.isAllowReviewersToJoin());
        review.setDescription(project.getDefaultObjectives());
        this.sendReviewCreatedEvent(review, creator);
        return review;
    }

    private void sendReviewCreatedEvent(Review review, FecruUser user) {
        this.eventPublisher.publish((Object)new ReviewCreatedEventImpl(review.getPermId(), this.spiUserUtils.createUserData(user), review.getType().getApiReviewType()));
    }

    @Override
    public Review createReview(ProjectManager projectManager, Project project, String name, FecruUser creator) {
        Review r2 = this.doCreateReview(projectManager, project, Review.ReviewType.REVIEW, name, creator);
        this.sendReviewCreatedEvent(r2, creator);
        return r2;
    }

    private Review doCreateReview(ProjectManager projectManager, Project project, Review.ReviewType type, String name, FecruUser creator) {
        return this.doCreateReview(projectManager, project, type, name, creator, StateManager.INSTANCE.getFirstState());
    }

    private Review doCreateReview(ProjectManager projectManager, Project project, Review.ReviewType type, String name, FecruUser creator, State firstState) {
        Review review = new Review(projectManager, project, type, name, firstState);
        this.reviewDAO.add(review);
        review.addPermaId(projectManager, project);
        review.setProject(project);
        LogManager.logStateChange(review.getStateName(), review.getId(), creator);
        LogManager.logReviewCreated(review, creator);
        review.setMetricsVersion(MetricsManager.INSTANCE.getLatestVersion());
        review.setCreator(creator);
        return review;
    }

    @Override
    public Collection<Review> getReviews() {
        String[] states = new String[]{StateManager.INSTANCE.getDeadState().getName()};
        return this.reviewDAO.listReviewsInStateOrderedByCreateDateTime(states, false);
    }

    @Override
    public void visitAllReviews(Visitor<Review> visitor) {
        this.reviewDAO.visitAllReviews(visitor);
    }

    @Override
    public int getMatchingReviewCount(ReviewFilterDef filter) {
        return this.getMatchingReviewCount(filter, null);
    }

    @Override
    public Object2LongMap<String> getReviewCountForUsers(Path path, String repoName, Set<String> users) {
        return this.reviewDAO.getReviewCountForUsers(path, repoName, users);
    }

    @Override
    public Collection<Review> getMatchingReviews(ReviewFilterDef f2, String title) {
        return this.getReviewsByIds((Collection)this.getMatchingReviewIds(f2, title));
    }

    private List<BooleanQuery> createQueries(ReviewFilterDef f2, String title) {
        if (f2.isContainer()) {
            ArrayList<BooleanQuery> queries = new ArrayList<BooleanQuery>();
            for (ReviewFilterDef childFilter : f2.getFilters()) {
                queries.addAll(this.createQueries(childFilter, title));
            }
            return queries;
        }
        CrucibleReviewQueryBuilder queryBuilder = CrucibleReviewQueryBuilder.newBuilder();
        if (!StringUtils.isEmpty((String)title)) {
            queryBuilder.title(title);
        }
        queryBuilder.states(f2.state);
        queryBuilder.participants(f2.creator, f2.author, f2.moderator, f2.reviewer, f2.orRoles, f2.complete);
        queryBuilder.allComplete(f2.allReviewersComplete);
        queryBuilder.moderatorIsNotAuthor(f2.moderatorIsNotAuthor, f2.author);
        if (f2.fromDate > 0L || f2.toDate > 0L) {
            Date from = f2.fromDate > 0L ? new Date(f2.fromDate) : null;
            Date to = f2.toDate > 0L ? new Date(f2.toDate) : null;
            queryBuilder.dateRange(from, to);
        }
        if (f2.project != null) {
            queryBuilder.projectId(f2.project.getId());
        }
        if (f2.reviewType != null) {
            queryBuilder.reviewType(f2.reviewType);
        }
        return Arrays.asList(queryBuilder.build());
    }

    private BooleanQuery createQuery(ReviewFilterDef f2, String title) {
        BooleanQuery query;
        List<BooleanQuery> queries = this.createQueries(f2, title);
        if (queries.size() == 1) {
            query = queries.get(0);
        } else {
            query = new BooleanQuery();
            for (BooleanQuery q2 : queries) {
                query.add((Query)q2, BooleanClause.Occur.SHOULD);
            }
        }
        return query;
    }

    @Override
    public List<Integer> getMatchingReviewIds(ReviewFilterDef f2, String title, ReviewSort sort) {
        BooleanQuery mainQuery = this.createQuery(f2, title);
        try {
            if (sort != null) {
                return this.reviewItemIndexer.findIds((Query)mainQuery, "reviewPK", Integer.MAX_VALUE, DefaultReviewManager.getLuceneSort(sort));
            }
            return this.reviewItemIndexer.findIds((Query)mainQuery, "reviewPK");
        }
        catch (DbException e2) {
            Logs.APP_LOG.error((Object)"Exception", (Throwable)e2);
            return Collections.emptyList();
        }
    }

    @Override
    public Collection<Integer> getMatchingReviewIds(ReviewFilterDef f2, String title) {
        return this.getMatchingReviewIds(f2, title, null);
    }

    @Override
    public int getMatchingReviewCount(ReviewFilterDef f2, String title) {
        BooleanQuery mainQuery = this.createQuery(f2, title);
        try {
            return this.reviewItemIndexer.countHits((Query)mainQuery);
        }
        catch (DbException e2) {
            Logs.APP_LOG.error((Object)"Exception", (Throwable)e2);
        }
        catch (IllegalStateException e3) {
            Logs.APP_LOG.debug((Object)("Review counts unavailable because review indexer is unavailable: " + e3.getMessage()));
        }
        return 0;
    }

    @Override
    public List<Review> findReviewsByDueDate(Project p2, Date dueBefore) {
        return this.reviewDAO.listReviewsByDueDate(p2, dueBefore);
    }

    @Override
    public Set searchReviewForTerm(String term, String selector, String grouper, Integer limit) {
        return new HashSet(this.searchReviewForTerms(Collections.singletonList(term), selector, grouper, limit, null));
    }

    @Override
    public List searchReviewForTerms(List<String> terms, String selector, String grouper, Integer limit, String projectKey) {
        return this.reviewDAO.searchReviewForTerms(terms, selector, grouper, limit, Project.upperCaseProjectKey(projectKey));
    }

    @Override
    public Role ensureReviewRoleExists(String roleName) throws NotFoundException {
        Preconditions.checkNotNull((Object)roleName);
        Role role = ROLE_BY_LOWER_CASE_NAME.get(roleName.toLowerCase(Locale.US));
        if (role == null) {
            throw new NotFoundException(String.format("Role: %s not found.", roleName));
        }
        return role;
    }

    @Override
    public List<Review> getReviewsWithLinkedJira(String key) {
        return this.reviewDAO.listWithJiraIssueKey(key);
    }

    @Override
    public Map<String, Long> countStatesOn(Date date, Project project) {
        return this.stateChangeLogDAO.countStatesOn(date, project);
    }

    @Override
    public void processLogRecords(Date from, Date to, Project project, LogRecordProcessor processor) {
        List<StateChangeLog> stateChangeLogs = this.stateChangeLogDAO.list(from, to, project);
        for (StateChangeLog log : stateChangeLogs) {
            processor.handle(log);
        }
        processor.afterFinalRecord();
    }

    @Override
    public Collection<Review> getReviewsInStates(String[] states) {
        return this.getReviewsInState(null, states);
    }

    @Override
    public Collection<Review> getReviewsInStates(Project project, String[] states) {
        return this.getReviewsInState(project, states);
    }

    private Collection<Review> getReviewsInState(Project project, String[] states) {
        if (states == null || states.length == 0) {
            return null;
        }
        CrucibleReviewQueryBuilder queryBuilder = CrucibleReviewQueryBuilder.newBuilder();
        queryBuilder.states(states);
        if (project != null) {
            queryBuilder.projectId(project.getId());
        }
        try {
            return this.getReviewsByIds((Collection)this.reviewItemIndexer.findIds((Query)queryBuilder.build(), "reviewPK"));
        }
        catch (DbException e2) {
            e2.printStackTrace();
            return Collections.emptyList();
        }
    }

    @Override
    public List<Object[]> getRevisionDetailsConsideredInReviews(String repname) {
        return this.fileRevisionExtraInfoDAO.getRevisionDetailsConsideredInReviews(repname);
    }

    @Override
    public boolean isConsideredInReview(CrucibleRevision fr, Integer reviewId) {
        Review review = this.getReviewById(reviewId);
        if (review == null) {
            return false;
        }
        FileRevisionExtraInfo frx = review.getFRX(fr);
        if (frx == null) {
            return false;
        }
        FRXRevision frxRev = frx.getFRXRevision(fr);
        if (frxRev == null) {
            return false;
        }
        int numRevs = frx.getFrxRevisions().size();
        return frx.getShowAsDiff() == false || frxRev.getOrder() != 0 || numRevs == 1;
    }

    @Override
    public int countReviewsCreatedInPeriod(Date startDate, Date endDate, Project project) {
        return this.reviewDAO.countReviewsCreatedInPeriod(startDate, endDate, project);
    }

    @Override
    public List<Review> getReviewChildren(Review parent) {
        return this.getReviewChildren(parent, new String[]{StateManager.INSTANCE.getDeadState().getName()}, false);
    }

    @Override
    public List<Review> getReviewChildren(Review parent, String[] states, boolean inState) {
        return this.reviewDAO.getReviewChildren(parent, states, inState);
    }

    @Override
    public Review getReviewById(int id) {
        return this.getReviewById((Integer)id);
    }

    @Override
    public Review getReviewByPermaId(String permaId) throws PermaIdFormatException {
        if (permaId == null) {
            throw new PermaIdFormatException("Null Review PermaId");
        }
        PermaIdKey permaKey = this.parsePermaId(permaId);
        if (permaKey != null) {
            return this.getReviewByPermaId(permaKey);
        }
        throw new PermaIdFormatException("'" + permaId + "' is an invalid Review PermaId");
    }

    @Override
    public PermaIdKey parsePermaId(String permaId) {
        Matcher m2 = PERMAID_PROG.matcher(PermaIdKey.upperCasePermaId(permaId));
        if (m2.matches()) {
            return new PermaIdKey(m2.group(1), Integer.parseInt(m2.group(2)));
        }
        return null;
    }

    @Override
    public Review getReviewByPermaId(PermaIdKey permaKey) {
        return this.reviewPermaIdDAO.getReviewByPermaId(permaKey);
    }

    @Override
    public boolean reviewExists(String permaId) {
        return this.reviewExists(this.parsePermaId(permaId));
    }

    @Override
    public boolean reviewExists(PermaIdKey permaKey) {
        if (permaKey == null) {
            return false;
        }
        return this.reviewPermaIdDAO.getReviewByPermaId(permaKey) != null;
    }

    @Override
    public ReviewIterator getReviewIteratorForIds(Collection<Integer> ids) {
        return new ReviewIterator(ids, this);
    }

    @Override
    public ReviewIterator getReviewIteratorForIds(Collection<Integer> ids, int prefetchSize) {
        return new ReviewIterator(ids, this, prefetchSize);
    }

    @Override
    public List<Review> getReviewsOrderedByIds(List<Integer> ids) {
        Collection reviews = this.getReviewsByIds(ids);
        ImmutableMap idToReview = Maps.uniqueIndex((Iterable)reviews, Review.TO_ID);
        ImmutableList.Builder orderedReviews = ImmutableList.builder();
        for (int id : ids) {
            orderedReviews.add(idToReview.get(id));
        }
        return orderedReviews.build();
    }

    public List<Review> getReviewsByIds(Collection<Integer> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        if (ids.size() > 500) {
            Logs.APP_LOG.info((Object)String.format("Requesting more than %d reviews may have a negative impact on performance and memory usage of Crucible. %d reviews selected.", 500, ids.size()));
        }
        return this.reviewDAO.getReviewsByIds(ids);
    }

    @Override
    public Review getReviewById(Integer id) {
        return this.reviewDAO.getById(id);
    }

    @Override
    public boolean isVisible(Review r2, Principal p2) {
        return ReviewUtil.principalCanDoReviewAction(p2, null, UserActionManager.ACTION_VIEW, r2);
    }

    @Override
    public ReviewParticipant addReviewer(Review review, FecruUser user) {
        ReviewParticipant p2 = this.participantDAO.getOrCreateParticipant(review, user);
        if (!p2.isAuthor() && !p2.isModerator()) {
            p2.setReviewer(true);
            review.getParticipants().add(p2);
        }
        return p2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteReview(Review review, FecruUser deleter) {
        String permaId = review.getPermaId();
        int id = review.getId();
        try {
            HibernateUtil.beginTransaction();
            DefaultNotificationManager.deleteNotifications(review);
            review.deleteAllComments();
            HibernateUtil.bounceTransaction();
            review = this.getReviewById(id);
            this.commentManager.cleanReviewComments(review);
            review.setParentReview(null);
            for (ReviewParticipant p2 : review.getParticipants()) {
                ParticipantManager.deleteParticipant(p2);
            }
            review.getParticipants().clear();
            this.clearChildren(review);
            HibernateUtil.bounceTransaction();
            review = this.getReviewById(id);
            this.removeRevisions(review);
            this.deletePatchRevisions(review);
            this.deleteUploadRevisions(review);
            this.crucibleActivityItemDAO.deleteWithReview(review);
            this.reviewPropertyDAO.remove(review);
            review.getProject().removeReview(review);
            this.reviewDAO.delete(review);
            HibernateUtil.commitTransaction();
            LogManager.logStateChange("Deleted", id, deleter);
            Logs.APP_LOG.info((Object)("Deleted review " + permaId));
            this.eventPublisher.publish((Object)new ReviewDeletedEventImpl((PermId<ReviewData>)new PermId(permaId), this.spiUserUtils.createUserData(deleter)));
            boolean bl = true;
            return bl;
        }
        catch (HibernateException e2) {
            Logs.APP_LOG.error((Object)("Trying to delete review " + permaId + "(" + id + ")"), (Throwable)e2);
            boolean bl = false;
            return bl;
        }
        finally {
            HibernateUtil.rollbackTransactionIfNotCommitted();
        }
    }

    @Override
    public void changeState(Review review, String action, FecruUser currentUser) throws Exception {
        StateTransition st;
        if (ReviewUtil.canDoReviewAction(action, review)) {
            st = review.getState().getTransition(action);
            if (st == null) {
                throw new AuthorizationException("You can't do " + action + " in state " + review.getState().getName());
            }
        } else {
            throw new AuthorizationException("User " + currentUser + " is not permitted to execute action " + action + " on review " + review.getPermaId() + " (" + review.getStateName() + ").");
        }
        LogManager.logReviewStateChange(review, currentUser, action, st.getNextState());
        review.setState(st.getNextState());
        LogManager.logStateChange(review.getState().toString(), review.getId(), currentUser);
        review.getState().processEntryScripts(currentUser, review, this.actionManager);
        InviteManager.processReviewStateChange(st, review, currentUser);
    }

    @Override
    public void completeReview(Review review, FecruUser user, boolean complete) {
        this.txTemplate.execute(status -> {
            ReviewParticipant participant = review.getParticipant(user);
            if (complete) {
                review.setReviewerComplete(participant);
            } else {
                review.setReviewerIncomplete(participant);
            }
            return null;
        });
    }

    private void clearChildren(Review review) {
        List<Review> children = this.getReviewChildren(review, new String[0], false);
        for (Review child : children) {
            child.setParentReview(null);
        }
    }

    private void removeRevisions(Review review) {
        for (FileRevisionExtraInfo frx : new ArrayList<FileRevisionExtraInfo>(review.getFrxs())) {
            for (FRXRevision frxRevision : new ArrayList<FRXRevision>(frx.getFrxRevisions())) {
                RevInfoKey revKey = frxRevision.getRevision().getRevInfoKey();
                if (review.removeFRXRevision(frxRevision)) continue;
                Logs.APP_LOG.warn((Object)("Couldn't remove revision " + revKey + " from review " + review.getPermaId() + " while deleting review"));
            }
        }
    }

    private void deletePatchRevisions(Review review) {
        List<Patch> patches = this.patchManager.findReviewPatches(review);
        for (Patch patch : patches) {
            for (CrucibleRevision cruRev : patch.getFileRevisions()) {
                FileRevisionManager.deleteCruRevision(cruRev);
            }
            patch.getFileRevisions().clear();
            UploadItem ui = patch.getUploadItem();
            try {
                patch.setUploadItem(null);
            }
            catch (IOException e2) {
                Logs.APP_LOG.error((Object)"Exception", (Throwable)e2);
            }
            UploadManager.deleteUpload(ui);
        }
        this.patchManager.deleteReviewPatches(review);
    }

    private void deleteUploadRevisions(Review review) {
        List<CrucibleRevision> uploadRevs = FileRevisionManager.getRevisions("UPLOAD:" + review.getId());
        for (CrucibleRevision cruRev : uploadRevs) {
            UploadItem ui = cruRev.getUploadItem();
            cruRev.setUploadItem(null);
            if (ui != null) {
                UploadManager.deleteUpload(ui);
            }
            FileRevisionManager.deleteCruRevision(cruRev);
        }
    }
}

