/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers.impl;

import com.atlassian.crucible.spi.services.ProjectSearchCriteria;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.page.Page;
import com.atlassian.fecru.page.PageRequest;
import com.atlassian.fecru.page.PagedResourceIterable;
import com.atlassian.fecru.tx.NonTransactional;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.event.RepositoryDeletedEvent;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewPermaId;
import com.cenqua.crucible.model.dao.ContentRootDAO;
import com.cenqua.crucible.model.dao.ProjectDAO;
import com.cenqua.crucible.model.dao.ReviewDAO;
import com.cenqua.crucible.model.dao.ReviewPermaIdDAO;
import com.cenqua.crucible.model.managers.PermaIdCacheManager;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.model.ContentRoot;
import com.cenqua.fisheye.user.GroupMembershipManager;
import com.cenqua.fisheye.user.UserManager;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="projectManager")
@AvailableToPlugins
public class DefaultProjectManager
implements ProjectManager {
    private static final Pattern PROJECT_KEY_PATTERN = Pattern.compile("([A-Z0-9\\-]+)");
    public static final String DEFAULT_PROJECT_KEY = "CR";
    public static final String DEFAULT_PROJECT_NAME = "Default Project";
    private final EventPublisher eventPublisher;
    private GroupMembershipManager groupMembershipManager;
    private PermissionManager permissionManager;
    private final ProjectDAO projectDAO;
    private final ReviewDAO reviewDAO;
    private final ReviewPermaIdDAO reviewPermaIdDAO;
    private final ContentRootDAO contentRootDAO;
    private final PermaIdCacheManager permaIdCacheManager;
    @Resource(name="projectManager")
    private ProjectManager self;

    @Autowired
    public DefaultProjectManager(ProjectDAO projectDAO, ReviewDAO reviewDAO, ReviewPermaIdDAO reviewPermaIdDAO, ContentRootDAO contentRootDAO, EventPublisher eventPublisher, PermaIdCacheManager permaIdCacheManager) {
        this.projectDAO = projectDAO;
        this.reviewDAO = reviewDAO;
        this.reviewPermaIdDAO = reviewPermaIdDAO;
        this.contentRootDAO = contentRootDAO;
        this.eventPublisher = eventPublisher;
        this.permaIdCacheManager = permaIdCacheManager;
    }

    @Autowired(required=false)
    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    @Autowired(required=false)
    public void setGroupMembershipManager(GroupMembershipManager groupMembershipManager) {
        this.groupMembershipManager = groupMembershipManager;
    }

    @PostConstruct
    public void afterPropertiesSet() {
        if (HibernateUtil.isRunning()) {
            try {
                this.self.getDefaultProject();
            }
            finally {
                HibernateUtil.closeSession();
            }
        }
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    @Override
    @Transactional(readOnly=true)
    public Page<Project> searchAllProjects(ProjectSearchCriteria projectSearchCriteria, PageRequest pageRequest) {
        List<Project> projects = this.projectDAO.list(projectSearchCriteria, pageRequest.getStart(), pageRequest.getLimit() + 1);
        new Page.Builder();
        return Page.Builder.buildFromLimitPlusOneCollection(projects, (PageRequest)pageRequest);
    }

    @Override
    @NonTransactional
    public PagedResourceIterable<Project> searchAllProjectsIterable(ProjectSearchCriteria projectSearchCriteria) {
        return new PagedResourceIterable<Project>(pageRequest -> this.self.searchAllProjects(projectSearchCriteria, pageRequest));
    }

    @Override
    @Transactional
    public List<Project> getAllProjects() {
        return this.projectDAO.list();
    }

    @Override
    @Transactional
    public List<Project> getProjects(Predicate<Project> predicate) {
        List<Project> projects = this.self.getAllProjects();
        return Lists.newArrayList((Iterable)Iterables.filter(projects, predicate));
    }

    @Override
    @Transactional
    public void removeRepositoryMappings(String repName) {
        List<ContentRoot> paths = this.contentRootDAO.listWithRepositoryName(repName);
        for (ContentRoot toDelete : paths) {
            if (toDelete == null) continue;
            toDelete.getProject().removeContentRoot(toDelete);
            this.contentRootDAO.delete(toDelete);
        }
        List<Project> projects = this.projectDAO.listWithDefaultRepositoryName(repName);
        for (Project project : projects) {
            project.setDefaultRepositoryName(null);
        }
    }

    @Override
    @Transactional
    public Project getProjectById(int id) {
        return this.projectDAO.getById(id);
    }

    @Override
    @Transactional
    public Page<FecruUser> getProjectDefaultReviewerUsers(String projectKey, PageRequest pageRequest) {
        DefaultProjectManager.validateProjectKey(projectKey);
        Project project = this.projectDAO.ensureProjectExists(projectKey);
        new Page.Builder();
        return Page.Builder.buildFromAllDataIterable((Iterable)ImmutableSortedSet.copyOf(project.getDefaultReviewerUsers()), (PageRequest)pageRequest);
    }

    @Override
    @Transactional
    public boolean addProjectDefaultReviewerUser(String projectKey, FecruUser user) {
        DefaultProjectManager.validateProjectKey(projectKey);
        Project project = this.projectDAO.ensureProjectExists(projectKey);
        return project.getDefaultReviewerUsers().add(user);
    }

    @Override
    @Transactional
    public boolean deleteProjectDefaultReviewerUser(String projectKey, FecruUser user) {
        DefaultProjectManager.validateProjectKey(projectKey);
        Project project = this.projectDAO.ensureProjectExists(projectKey);
        return project.getDefaultReviewerUsers().remove(user);
    }

    @Override
    @Transactional
    public Page<String> getProjectDefaultReviewerGroups(String projectKey, PageRequest pageRequest) {
        DefaultProjectManager.validateProjectKey(projectKey);
        Project project = this.projectDAO.ensureProjectExists(projectKey);
        new Page.Builder();
        return Page.Builder.buildFromAllDataIterable((Iterable)ImmutableSortedSet.copyOf(project.getDefaultReviewerGroups()), (PageRequest)pageRequest);
    }

    @Override
    @Transactional
    public boolean addProjectDefaultReviewerGroup(String projectKey, String groupName) {
        DefaultProjectManager.validateProjectKey(projectKey);
        Project project = this.projectDAO.ensureProjectExists(projectKey);
        return project.getDefaultReviewerGroups().add(UserManager.GROUPNAME_NORMALIZATION.apply(groupName));
    }

    @Override
    @Transactional
    public boolean deleteProjectDefaultReviewerGroup(String projectKey, String groupName) {
        DefaultProjectManager.validateProjectKey(projectKey);
        Project project = this.projectDAO.ensureProjectExists(projectKey);
        return project.getDefaultReviewerGroups().remove(UserManager.GROUPNAME_NORMALIZATION.apply(groupName));
    }

    @Override
    @Transactional
    public Page<FecruUser> getProjectAllowedReviewerUsers(String projectKey, PageRequest pageRequest) {
        DefaultProjectManager.validateProjectKey(projectKey);
        Project project = this.projectDAO.ensureProjectExists(projectKey);
        new Page.Builder();
        return Page.Builder.buildFromAllDataIterable((Iterable)ImmutableSortedSet.copyOf(project.getAllowedReviewerUsers()), (PageRequest)pageRequest);
    }

    @Override
    @Transactional
    public boolean addProjectAllowedReviewerUser(String projectKey, FecruUser user) {
        DefaultProjectManager.validateProjectKey(projectKey);
        Project project = this.projectDAO.ensureProjectExists(projectKey);
        return project.getAllowedReviewerUsers().add(user);
    }

    @Override
    @Transactional
    public boolean deleteProjectAllowedReviewerUser(String projectKey, FecruUser user) {
        DefaultProjectManager.validateProjectKey(projectKey);
        Project project = this.projectDAO.ensureProjectExists(projectKey);
        return project.getAllowedReviewerUsers().remove(user);
    }

    @Override
    @Transactional
    public Page<String> getProjectAllowedReviewerGroups(String projectKey, PageRequest pageRequest) {
        DefaultProjectManager.validateProjectKey(projectKey);
        Project project = this.projectDAO.ensureProjectExists(projectKey);
        new Page.Builder();
        return Page.Builder.buildFromAllDataIterable((Iterable)ImmutableSortedSet.copyOf(project.getAllowedReviewerGroups()), (PageRequest)pageRequest);
    }

    @Override
    @Transactional
    public boolean addProjectAllowedReviewerGroup(String projectKey, String groupName) {
        DefaultProjectManager.validateProjectKey(projectKey);
        Project project = this.projectDAO.ensureProjectExists(projectKey);
        return project.getAllowedReviewerGroups().add(UserManager.GROUPNAME_NORMALIZATION.apply(groupName));
    }

    @Override
    @Transactional
    public boolean deleteProjectAllowedReviewerGroup(String projectKey, String groupName) {
        DefaultProjectManager.validateProjectKey(projectKey);
        Project project = this.projectDAO.ensureProjectExists(projectKey);
        return project.getAllowedReviewerGroups().remove(UserManager.GROUPNAME_NORMALIZATION.apply(groupName));
    }

    @Override
    @Transactional
    @Deprecated
    public boolean deleteProject(Project project) {
        return this.self.deleteProjectByKey(project.getProjKey());
    }

    @Override
    @Transactional
    public boolean deleteProjectByKey(String projectKey) {
        Project project;
        DefaultProjectManager.validateProjectKey(projectKey);
        if (!this.isDefaultProject(projectKey) && this.reviewDAO.countReviewsInProject(project = this.projectDAO.getByKey(projectKey)) == 0) {
            this.projectDAO.delete(project);
            this.permaIdCacheManager.removePermaIdFromCache(project.getProjKey());
            return true;
        }
        return false;
    }

    @Override
    @Transactional
    public void changeProjectKey(Project existingProject, String newProjectKey) {
        DefaultProjectManager.validateProjectKey(newProjectKey);
        String oldProjectKey = existingProject.getProjKey();
        this.projectDAO.ensureInSession(existingProject);
        this.reviewPermaIdDAO.deleteWithProjectKey(newProjectKey);
        List<ReviewPermaId> reviewPermaIds = this.reviewPermaIdDAO.listWithProjectKey(oldProjectKey);
        for (ReviewPermaId oldpid : reviewPermaIds) {
            if (oldpid.getReview() == null) continue;
            ReviewPermaId newpid = new ReviewPermaId(oldpid.getReview(), newProjectKey, oldpid.getPermaIdKey().getNumber());
            oldpid.getReview().getPermaIdHistory().add(newpid);
        }
        this.permaIdCacheManager.removePermaIdFromCache(oldProjectKey);
        existingProject.setProjKey(newProjectKey);
    }

    @Override
    @Transactional
    public Project createProject(String name, String key) {
        DefaultProjectManager.validateProjectKey(key);
        Project existing = this.getProjectByKey(key);
        if (existing != null) {
            return existing;
        }
        if (this.permissionManager == null) {
            throw new IllegalStateException("A permissionManager must be configured to create new projects");
        }
        Project p2 = new Project();
        p2.setProjKey(key);
        p2.setName(name);
        p2.setStoreRevisions(true);
        p2.setPermissionScheme(this.permissionManager.getDefaultPermissionScheme());
        p2.setModeratorDisabled(false);
        this.projectDAO.add(p2);
        return p2;
    }

    @Override
    @Transactional
    public Project getProjectByKey(String key) {
        DefaultProjectManager.validateProjectKey(key);
        return this.projectDAO.getByKey(key);
    }

    @Override
    @Transactional
    public Project getDefaultProject() {
        Project p2 = this.self.getProjectById(1);
        if (p2 == null) {
            return this.createProject(DEFAULT_PROJECT_NAME, DEFAULT_PROJECT_KEY);
        }
        return p2;
    }

    @Override
    @Transactional
    public boolean isDefaultProject(String key) {
        DefaultProjectManager.validateProjectKey(key);
        return key.equals(this.self.getDefaultProject().getProjKey());
    }

    @Override
    @Transactional
    public ReviewPermaId getNextPermaId(Project p2, Review review) {
        int num = this.permaIdCacheManager.getNextPermaId(p2.getProjKey());
        ReviewPermaId key = new ReviewPermaId(null, p2.getProjKey(), num);
        this.reviewPermaIdDAO.add(key);
        key.setReview(review);
        return key;
    }

    @EventListener
    public void onRepositoryDeleted(RepositoryDeletedEvent e2) {
        this.self.removeRepositoryMappings(e2.getRepositoryName());
    }

    @Override
    @Transactional
    public List<String> getAllCurrentAndHistoricalProjectKeys() {
        LinkedHashSet<String> result = new LinkedHashSet<String>(this.getAllCurrentProjectKeys());
        result.addAll(this.reviewPermaIdDAO.listProjectKeys());
        return new ArrayList<String>(result);
    }

    @Override
    @Transactional
    public List<String> getAllCurrentProjectKeys() {
        return this.projectDAO.listProjectKeys();
    }

    @Override
    @Transactional
    public void moveAllReviews(@Nonnull Project fromProject, @Nonnull Project toProject) {
        Preconditions.checkArgument((!fromProject.getId().equals(toProject.getId()) ? 1 : 0) != 0, (String)"Moving reviews within same project is not allowed (%s to %s)", (Object[])new Object[]{fromProject.getProjKey(), toProject.getProjKey()});
        List<Review> reviews = this.reviewDAO.listWithProject(fromProject);
        for (Review r2 : reviews) {
            this.moveReviewInternal(r2, toProject);
        }
    }

    @Override
    @Transactional
    public void moveReviewToProject(Review review, Project toProject) {
        this.moveReviewInternal(review, toProject);
    }

    private void moveReviewInternal(Review review, Project toProject) {
        review.setProject(toProject);
        review.addPermaId(this, toProject);
        if (toProject.isModeratorEnabled() && (review.getModerator() == null || !this.self.isAllowedReviewer(toProject, review.getModerator())) && toProject.getDefaultModerator() != null) {
            review.setModerator(toProject.getDefaultModerator());
        }
        review.setAllowReviewerToJoin(toProject.isAllowReviewersToJoin());
        Set<FecruUser> currentReviewers = review.getReviewers();
        for (FecruUser cu : currentReviewers) {
            if (this.isAllowedReviewer(toProject, cu)) continue;
            review.removeReviewer(cu);
        }
        if (review.getCountAllReviewers() == 0) {
            Set<FecruUser> defaultReviewers = toProject.getDefaultReviewers();
            for (FecruUser cu : defaultReviewers) {
                review.addReviewer(cu);
            }
        }
    }

    @Override
    @Transactional
    public void deleteAllReviews(Project fromProject, FecruUser deleter, ReviewManager reviewManager) {
        Preconditions.checkNotNull((Object)fromProject, (Object)"From project is null");
        Preconditions.checkNotNull((Object)deleter, (Object)"User deleter is null");
        Preconditions.checkNotNull((Object)reviewManager, (Object)"ReviewManager is null");
        List<Review> reviews = this.reviewDAO.listWithProject(fromProject);
        for (Review r2 : new ArrayList<Review>(reviews)) {
            if (reviewManager.deleteReview(r2, deleter)) continue;
            throw new RuntimeException("problem deleting review " + r2.getPermaId());
        }
    }

    @Override
    @Transactional
    public int countReviewsInProject(Project project) {
        return this.reviewDAO.countReviewsInProject(project);
    }

    @Override
    @Transactional
    public ContentRoot addRepToProject(String projectKey, String repname) {
        return this.self.addPathToProject(projectKey, repname, "/");
    }

    @Override
    @NonTransactional
    public Set<String> getAllRepositoriesInProject(Project project) {
        Set<ContentRoot> contentRoots = project.getContentRoots();
        HashSet<String> reps = new HashSet<String>();
        for (ContentRoot cr : contentRoots) {
            reps.add(cr.getRepName());
        }
        return reps;
    }

    @Override
    @Transactional
    public ContentRoot addPathToProject(String projectKey, String repname, String path) {
        DefaultProjectManager.validateProjectKey(projectKey);
        DefaultProjectManager.assertStringsNotNullOrEmpty(projectKey, repname, path);
        Project project = this.projectDAO.getByKey(projectKey);
        Preconditions.checkArgument((project != null ? 1 : 0) != 0, (String)"Project with key: %s doesn't exist.", (Object[])new Object[]{projectKey});
        ContentRoot existingContentRoot = this.contentRootDAO.getByProjectRepositoryPath(project, repname, path);
        if (existingContentRoot != null) {
            return existingContentRoot;
        }
        ContentRoot newContentRoot = new ContentRoot(project, repname, path);
        project.addContentRoot(newContentRoot);
        return newContentRoot;
    }

    @Override
    @Transactional
    public void deletePathFromProject(String projectKey, String repositoryName, String path) {
        DefaultProjectManager.validateProjectKey(projectKey);
        DefaultProjectManager.assertStringsNotNullOrEmpty(projectKey, repositoryName, path);
        Project project = this.projectDAO.getByKey(projectKey);
        Preconditions.checkArgument((project != null ? 1 : 0) != 0, (String)"Project with key: %s doesn't exist.", (Object[])new Object[]{projectKey});
        project.getContentRoots().remove(new ContentRoot(project, repositoryName, path));
        this.contentRootDAO.deleteByProjectIdRepositoryPath(project.getId(), repositoryName, path);
    }

    @Override
    @Transactional
    public boolean projectExists(int id) {
        return this.self.getProjectById(id) != null;
    }

    @Override
    @Transactional
    public boolean projectExists(String key) {
        DefaultProjectManager.validateProjectKey(key);
        return this.self.getProjectByKey(key) != null;
    }

    @Override
    @Transactional
    public boolean isAllowedReviewer(Project project, FecruUser user) {
        Set<FecruUser> reviewers = project.getAllowedReviewerUsers();
        Set<String> reviewerGroups = project.getAllowedReviewerGroups();
        if (reviewers.isEmpty() && reviewerGroups.isEmpty()) {
            return true;
        }
        if (user != null) {
            if (reviewers.contains(user)) {
                return true;
            }
            for (String group : reviewerGroups) {
                if (!this.groupMembershipManager.isUserInGroup(group, user.getUsername())) continue;
                return true;
            }
        }
        if (Logs.APP_LOG.isDebugEnabled()) {
            String reviewersNote = reviewers.isEmpty() ? "" : "they are not one of the allowed users: " + reviewers.stream().map(r2 -> r2.toString()).collect(Collectors.joining(", "));
            String groupsNote = reviewerGroups.isEmpty() ? "" : "they are not a member of one of the allowed groups: " + String.join((CharSequence)", ", reviewerGroups);
            String sep = !reviewers.isEmpty() && !reviewerGroups.isEmpty() ? " and " : "";
            Logs.APP_LOG.debug((Object)("The user " + (user != null ? user.toString() : "(anonymous)") + " is not an allowed reviewer in the project " + project.getProjKey() + " because " + reviewersNote + sep + groupsNote));
        }
        return false;
    }

    @Override
    @Transactional
    public int countProjects() {
        return this.projectDAO.countProjects();
    }

    @Override
    @Transactional
    public int countProjects(ProjectSearchCriteria projectSearchCriteria) {
        return this.projectDAO.countProjects(projectSearchCriteria);
    }

    private static void validateProjectKey(String projectKey) {
        Preconditions.checkNotNull((Object)projectKey, (Object)"Project key must not be null.");
        Matcher m2 = PROJECT_KEY_PATTERN.matcher(projectKey);
        Preconditions.checkArgument((boolean)m2.matches(), (String)"Invalid project key: %s, only alphanumeric and uppercase values are allowed: %s", (Object[])new Object[]{projectKey, PROJECT_KEY_PATTERN.pattern()});
    }

    private static void assertStringsNotNullOrEmpty(String ... params) {
        for (int i2 = 0; i2 < params.length; ++i2) {
            if (!Strings.isNullOrEmpty((String)params[i2])) continue;
            throw new IllegalArgumentException("Cannot have null or empty arguments, arg " + i2 + " was null");
        }
    }
}

