/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers.impl;

import com.atlassian.crucible.spi.TxCallback;
import com.atlassian.crucible.spi.services.NotFoundException;
import com.atlassian.crucible.spi.services.PermissionSchemeSearchCriteria;
import com.atlassian.crucible.spi.services.SearchCriteriaType;
import com.atlassian.fecru.page.Page;
import com.atlassian.fecru.page.PageRequest;
import com.atlassian.fecru.page.PagedResourceIterable;
import com.atlassian.fecru.tx.NonTransactional;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.fisheye.user.permissions.GlobalPermissionManager;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.Role;
import com.cenqua.crucible.model.dao.PermissionSchemeDAO;
import com.cenqua.crucible.model.dao.ProjectDAO;
import com.cenqua.crucible.model.dao.ReviewDAO;
import com.cenqua.crucible.model.managers.GroupManager;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.SecureProjectManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.model.principalAssociations.AllUserPA;
import com.cenqua.crucible.model.principalAssociations.AnonymousPA;
import com.cenqua.crucible.model.principalAssociations.GroupPA;
import com.cenqua.crucible.model.principalAssociations.RolePA;
import com.cenqua.crucible.model.principalAssociations.UserPA;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.GroupMembershipManager;
import com.cenqua.fisheye.user.UserManager;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;

@AvailableToPlugins
@Service(value="permissionManager")
public class DefaultPermissionManager
implements PermissionManager {
    private final UserManager userManager;
    private final GroupMembershipManager groupMembershipManager;
    private final EffectiveUserProvider effectiveUserProvider;
    private final PermissionSchemeDAO permissionSchemeDAO;
    private final ProjectDAO projectDAO;
    private final ReviewDAO reviewDAO;
    private final CurrentSessionProvider currentSessionProvider;
    private final GlobalPermissionManager globalPermissionManager;
    private final TxTemplate txTemplate;

    @Autowired
    public DefaultPermissionManager(PermissionSchemeDAO permissionSchemeDAO, ProjectDAO projectDAO, ReviewDAO reviewDAO, CurrentSessionProvider currentSessionProvider, UserManager userManager, GroupMembershipManager groupMembershipManager, EffectiveUserProvider effectiveUserProvider, GlobalPermissionManager globalPermissionManager, TxTemplate txTemplate) {
        this.permissionSchemeDAO = permissionSchemeDAO;
        this.projectDAO = projectDAO;
        this.reviewDAO = reviewDAO;
        this.currentSessionProvider = currentSessionProvider;
        this.userManager = userManager;
        this.groupMembershipManager = groupMembershipManager;
        this.effectiveUserProvider = effectiveUserProvider;
        this.globalPermissionManager = globalPermissionManager;
        this.txTemplate = txTemplate;
    }

    private Session session() {
        return this.currentSessionProvider.currentSession();
    }

    @Override
    public PermissionScheme createPermissionScheme(String name) {
        PermissionScheme ps = this.findPermissionSchemeByName(name);
        if (ps != null) {
            return ps;
        }
        return this.txTemplate.execute(status -> {
            PermissionScheme newPermissionScheme = new PermissionScheme(name);
            this.permissionSchemeDAO.add(newPermissionScheme);
            return newPermissionScheme;
        });
    }

    @Override
    public PermissionScheme findPermissionSchemeByName(String name) {
        return this.txTemplate.execute(status -> this.permissionSchemeDAO.getByName(name));
    }

    @Override
    public PermissionScheme ensurePermissionSchemeExists(String name) throws NotFoundException {
        return this.txTemplate.execute(status -> {
            PermissionScheme permissionScheme = this.permissionSchemeDAO.getByName(name);
            if (permissionScheme != null) {
                return permissionScheme;
            }
            throw new NotFoundException(String.format("Permission scheme: %s not found.", name));
        });
    }

    @Override
    public PermissionScheme findPermissionSchemeById(int permissionSchemeId) {
        return this.txTemplate.execute(status -> this.permissionSchemeDAO.getById(permissionSchemeId));
    }

    @Override
    public Iterable<PermissionScheme> getPermissionSchemes() {
        return this.txTemplate.execute(status -> {
            List<PermissionScheme> list = this.permissionSchemeDAO.list();
            Collections.sort(list);
            return list;
        });
    }

    @Override
    public Iterable<Project> getProjectsUsingPermissionScheme(PermissionScheme ps) {
        return this.txTemplate.execute(status -> {
            this.permissionSchemeDAO.ensureInSession(ps);
            return this.projectDAO.listWithPermissionScheme(ps);
        });
    }

    @Override
    public boolean canEffectivePrincipalDoReviewAction(Review review, UserActionManager.Action action) {
        return this.txTemplate.execute(status -> this.canPrincipalDoAction(review.getProject().getPermissionScheme(), this.effectiveUserProvider.getEffectivePrincipal(), this.effectiveUserProvider.getEffectiveUser(), action.getName(), review));
    }

    @Override
    public boolean canPrincipalDoAction(final PermissionScheme scheme, final Principal p2, final FecruUser user, final String actionName, final Review review) {
        return this.txTemplate.execute(new TxCallback<Boolean>(){

            @Override
            public Boolean doInTransaction(TransactionStatus status) throws Exception {
                List<Role> roles;
                if (DefaultPermissionManager.this.canPrincipalDoActionOnAllReviews(scheme, p2, actionName)) {
                    return true;
                }
                if (review != null && scheme.isAllowedByRole(roles = review.getUsersRoles(this.getUser()), actionName)) {
                    return true;
                }
                return false;
            }

            private FecruUser getUser() {
                if (user == null || !user.getUsername().equals(p2.getUserName())) {
                    return Principal.Anonymous.isAnon((Principal)p2) ? null : DefaultPermissionManager.this.userManager.getLicensedUser(p2.getUserName());
                }
                return user;
            }
        });
    }

    @Override
    public Collection<UserActionManager.Action> canPrincipalDoActions(final PermissionScheme scheme, final Principal p2, final Collection<UserActionManager.Action> actions, final Review review) {
        return this.txTemplate.execute(new TxCallback<Collection<UserActionManager.Action>>(){

            @Override
            public Collection<UserActionManager.Action> doInTransaction(TransactionStatus status) throws Exception {
                HashSet<UserActionManager.Action> allowedActions = new HashSet<UserActionManager.Action>();
                if (review != null) {
                    FecruUser cu = Principal.Anonymous.isAnon((Principal)p2) || Principal.SuperUser.isSuperUser((Principal)p2) ? null : DefaultPermissionManager.this.userManager.getLicensedUser(p2.getUserName());
                    List<Role> roles = review.getUsersRoles(cu);
                    for (UserActionManager.Action action : actions) {
                        if (DefaultPermissionManager.this.canPrincipalDoActionOnAllReviews(scheme, p2, action.getName())) {
                            allowedActions.add(action);
                            continue;
                        }
                        if (DefaultPermissionManager.this.isActionPreventedByLicense(action.getName(), p2) || !scheme.isAllowedByRole(roles, action.getName())) continue;
                        allowedActions.add(action);
                    }
                } else {
                    for (UserActionManager.Action action : actions) {
                        if (!DefaultPermissionManager.this.canPrincipalDoActionOnAllReviews(scheme, p2, action.getName())) continue;
                        allowedActions.add(action);
                    }
                }
                return allowedActions;
            }
        });
    }

    @Override
    public boolean canPrincipalDoActionOnAllReviews(final PermissionScheme scheme, final Principal p2, final String actionName) {
        if (Principal.SuperUser.isSuperUser((Principal)p2)) {
            return true;
        }
        return this.txTemplate.execute(new TxCallback<Boolean>(){

            @Override
            public Boolean doInTransaction(TransactionStatus status) throws Exception {
                if (Principal.Anonymous.isAnon((Principal)p2)) {
                    RootConfig root = AppConfig.getsConfig();
                    return root.getConfig().getSecurity().getAllowAnon() && root.getConfig().getSecurity().getAllowCruAnon() && scheme.isAnonymousAllowed(actionName);
                }
                if (DefaultPermissionManager.this.isActionPreventedByLicense(actionName, p2)) {
                    return false;
                }
                if (scheme.isAllUserAllowed(actionName)) {
                    return true;
                }
                try {
                    List<String> groups = DefaultPermissionManager.this.groupMembershipManager.getGroupsForUser(p2.getUserName());
                    if (groups != null && scheme.isAllowedByGroup(groups, actionName)) {
                        return true;
                    }
                }
                catch (DbException e2) {
                    Logs.APP_LOG.warn((Object)"Problem looking up groups, group based permission skipped (denied).", (Throwable)e2);
                }
                if (scheme.isAllowedByUser(p2.getUserName(), actionName)) {
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public boolean isActionPreventedByLicense(String actionName, Principal principal) {
        boolean crucLicenseRequired;
        UserActionManager.Action action = UserActionManager.Action.getByName(actionName);
        if (action != null) {
            crucLicenseRequired = action.isCrucibleLicenseRequired();
        } else {
            crucLicenseRequired = true;
            Logs.APP_LOG.warn((Object)("Unknown action '" + actionName + "'. Assuming a Crucible license is required to perform it."));
        }
        return crucLicenseRequired && principal != null && principal.getUserName() != null && !this.isCrucibleEnabledUser(principal.getUserName());
    }

    @Override
    public boolean isProjectVisible(final Project project) {
        return this.txTemplate.execute(new TxCallback<Boolean>(){

            @Override
            public Boolean doInTransaction(TransactionStatus status) throws Exception {
                DefaultPermissionManager.this.projectDAO.ensureInSession(project);
                return DefaultPermissionManager.this.isProjectVisible(DefaultPermissionManager.this.effectiveUserProvider.getEffectivePrincipal(), project);
            }
        });
    }

    @Override
    public boolean isProjectVisible(final Principal principal, final Project project) {
        return this.txTemplate.execute(new TxCallback<Boolean>(){

            @Override
            public Boolean doInTransaction(TransactionStatus status) throws Exception {
                DefaultPermissionManager.this.projectDAO.ensureInSession(project);
                return DefaultPermissionManager.this.canPrincipalDoActionOnAllReviews(project.getPermissionScheme(), principal, UserActionManager.ACTION_VIEW);
            }
        });
    }

    @Override
    public boolean canPrincipalCreateIn(final Principal principal, final Project project) {
        return this.txTemplate.execute(new TxCallback<Boolean>(){

            @Override
            public Boolean doInTransaction(TransactionStatus status) throws Exception {
                DefaultPermissionManager.this.projectDAO.ensureInSession(project);
                return DefaultPermissionManager.this.canPrincipalDoActionOnAllReviews(project.getPermissionScheme(), principal, UserActionManager.ACTION_CREATE);
            }
        });
    }

    private boolean isCrucibleEnabledUser(String p2) {
        try {
            return this.globalPermissionManager.hasPermission(p2, GlobalPermissionType.CRUCIBLE_USER);
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)"unable to retrieve user's crucible status.", (Throwable)e2);
            return false;
        }
    }

    public static Set<Project> getProjectsPrincipalCanView(Principal principal) {
        SecureProjectManager secureProjectManager = (SecureProjectManager)SpringContext.getComponent("secureProjectManager");
        return Sets.newHashSet(secureProjectManager.getVisibleProjects(principal));
    }

    public static Set<Project> getProjectsPrincipalCanDoActionIn(Principal principal, String actionName, GroupManager groupManager) {
        UserActionManager.Action action = UserActionManager.Action.getByName(actionName);
        if (action == null) {
            Logs.APP_LOG.warn((Object)("Permission check for unknown action '" + actionName + "'"));
            return Collections.emptySet();
        }
        SecureProjectManager secureProjectManager = (SecureProjectManager)SpringContext.getComponent("secureProjectManager");
        return Sets.newHashSet(secureProjectManager.getProjectsCanDoActionIn(principal, action));
    }

    @Override
    public Set<Integer> getProjectsRoleCanDoActionIn(Role role, String actionName) {
        return this.txTemplate.execute(status -> {
            Query q2 = this.session().createQuery("select p.id from Project p, RolePA r where r.ps = p.permissionScheme and r.actionName = :actionName and r.pid = :principalId");
            q2.setCacheable(true);
            q2.setString("actionName", actionName);
            q2.setString("principalId", role.getName());
            return Sets.newHashSet((Iterable)q2.list());
        });
    }

    @Override
    public PermissionScheme getDefaultPermissionScheme() {
        PermissionScheme ps = this.findPermissionSchemeByName("agile");
        if (ps != null) {
            return ps;
        }
        ps = this.txTemplate.execute(status -> this.permissionSchemeDAO.getById(1));
        if (ps == null) {
            Logs.APP_LOG.error((Object)"No default permission scheme exists");
        }
        return ps;
    }

    @Override
    public PermissionScheme copyPermissionScheme(PermissionScheme ps, String name) {
        PermissionScheme newPS = this.createPermissionScheme(name);
        for (AllUserPA allUserPA : ps.getAllUsersPAs()) {
            newPS.addAllUsersAction(allUserPA.getActionName());
        }
        for (AnonymousPA anonymousPA : ps.getAnonymousPAs()) {
            newPS.addAnonAction(anonymousPA.getActionName());
        }
        for (UserPA userPA : ps.getUserPAs()) {
            newPS.addUserAction(userPA.getPid(), userPA.getActionName());
        }
        for (GroupPA groupPA : ps.getGroupPAs()) {
            newPS.addGroupAction(groupPA.getPid(), groupPA.getActionName());
        }
        for (RolePA rolePA : ps.getReviewRolePAs()) {
            newPS.addReviewRoleAction(rolePA.getPid(), rolePA.getActionName());
        }
        return newPS;
    }

    @Override
    public void deletePermissionSchemeByName(String permissionSchemeName) {
        this.txTemplate.execute(status -> {
            PermissionScheme ps = this.permissionSchemeDAO.getByName(permissionSchemeName);
            this.permissionSchemeDAO.ensureInSession(ps);
            if (this.getDefaultPermissionScheme().equals(ps)) {
                throw new IllegalArgumentException("Not allowed to delete default Permission Scheme");
            }
            this.session().createQuery("delete AllUserPA where ps = :ps").setEntity("ps", (Object)ps).executeUpdate();
            this.session().createQuery("delete AnonymousPA where ps = :ps").setEntity("ps", (Object)ps).executeUpdate();
            this.session().createQuery("delete UserPA where ps = :ps").setEntity("ps", (Object)ps).executeUpdate();
            this.session().createQuery("delete GroupPA where ps = :ps").setEntity("ps", (Object)ps).executeUpdate();
            this.session().createQuery("delete RolePA where ps = :ps").setEntity("ps", (Object)ps).executeUpdate();
            this.permissionSchemeDAO.delete(ps);
            return null;
        });
    }

    @Override
    public Iterable<String> getAllPermissionSchemeNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (PermissionScheme pm : this.getPermissionSchemes()) {
            names.add(pm.getName());
        }
        return names;
    }

    @Override
    public int countPermissionSchemes() {
        return this.countPermissionSchemes(PermissionSchemeSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.EXACT_MATCH).all());
    }

    @Override
    public int countPermissionSchemes(PermissionSchemeSearchCriteria permissionSchemeSearchCriteria) {
        return this.txTemplate.execute(status -> this.permissionSchemeDAO.countPermissionSchemes(permissionSchemeSearchCriteria));
    }

    @Override
    public Page<PermissionScheme> searchPermissionSchemes(PermissionSchemeSearchCriteria permissionSchemeSearchCriteria, PageRequest pageRequest) {
        return this.txTemplate.execute(status -> {
            List<PermissionScheme> permissionSchemes = this.permissionSchemeDAO.list(permissionSchemeSearchCriteria, pageRequest.getStart(), pageRequest.getLimit() + 1);
            return Page.Builder.buildFromLimitPlusOneCollection(permissionSchemes, (PageRequest)pageRequest);
        });
    }

    @Override
    @NonTransactional
    public PagedResourceIterable<PermissionScheme> searchPermissionSchemesIterable(PermissionSchemeSearchCriteria permissionSchemeSearchCriteria) {
        return new PagedResourceIterable<PermissionScheme>(pageRequest -> this.searchPermissionSchemes(permissionSchemeSearchCriteria, pageRequest));
    }

    private void addReviewRoleActions(PermissionScheme ps, String pid, String[] actions) {
        this.txTemplate.execute(status -> {
            this.permissionSchemeDAO.ensureInSession(ps);
            for (String action : actions) {
                ps.addReviewRoleAction(pid, action);
            }
            return null;
        });
    }

    @Override
    public PermissionScheme createAgilePermissionSchemeWithName(String name) throws PermissionManager.DuplicatePermissionSchemeNameException {
        return this.txTemplate.execute(status -> {
            PermissionScheme ps = this.findPermissionSchemeByName(name);
            if (ps != null) {
                throw new PermissionManager.DuplicatePermissionSchemeNameException("A Permission scheme named '" + name + "' already exists.");
            }
            ps = this.createPermissionScheme(name);
            ps.addAllUsersAction(UserActionManager.ACTION_VIEW);
            String[] commonActions = new String[]{UserActionManager.ACTION_ABANDON, UserActionManager.ACTION_APPROVE, UserActionManager.ACTION_CLOSE, UserActionManager.ACTION_COMMENT, UserActionManager.ACTION_DELETE, UserActionManager.ACTION_MOD_FILES, UserActionManager.ACTION_RECOVER, UserActionManager.ACTION_REJECT, UserActionManager.ACTION_REOPEN, UserActionManager.ACTION_SUBMIT, UserActionManager.ACTION_SUMMARIZE, UserActionManager.ACTION_VIEW};
            String[] reviewerActions = new String[]{UserActionManager.ACTION_CLOSE, UserActionManager.ACTION_COMMENT, UserActionManager.ACTION_COMPLETE, UserActionManager.ACTION_MOD_FILES, UserActionManager.ACTION_RECOVER, UserActionManager.ACTION_REOPEN, UserActionManager.ACTION_SUMMARIZE, UserActionManager.ACTION_UNCOMPLETE, UserActionManager.ACTION_VIEW};
            this.addReviewRoleActions(ps, ReviewManager.AUTHOR.getName(), commonActions);
            this.addReviewRoleActions(ps, ReviewManager.MODERATOR.getName(), commonActions);
            this.addReviewRoleActions(ps, ReviewManager.CREATOR.getName(), commonActions);
            this.addReviewRoleActions(ps, ReviewManager.REVIEWER.getName(), reviewerActions);
            ps.addAllUsersAction(UserActionManager.ACTION_VIEW);
            ps.addAllUsersAction(UserActionManager.ACTION_CREATE);
            ps.addAnonAction(UserActionManager.ACTION_VIEW);
            return ps;
        });
    }

    @Override
    public PermissionScheme createAgilePermissionScheme() throws PermissionManager.DuplicatePermissionSchemeNameException {
        return this.createAgilePermissionSchemeWithName(this.createDistinctName("agile"));
    }

    private String createDistinctName(String prefix) {
        Iterable<String> existingNames = this.getAllPermissionSchemeNames();
        return this.findUnusedName(existingNames, prefix, 0);
    }

    private String findUnusedName(Iterable<String> existingNames, String prefix, int suffix) {
        String name = prefix + "-" + suffix;
        return Iterables.contains(existingNames, (Object)name) ? this.findUnusedName(existingNames, prefix, suffix + 1) : name;
    }
}

