/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers.impl;

import com.atlassian.fecru.tx.NonTransactional;
import com.cenqua.crucible.model.dao.ReviewPermaIdDAO;
import com.cenqua.crucible.model.managers.PermaIdCacheManager;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="permaIdCacheManager")
public class DefaultPermaIdCacheManager
implements PermaIdCacheManager {
    private final Cache<String, AtomicInteger> permaIdCache = CacheBuilder.newBuilder().build();
    private final ReviewPermaIdDAO reviewPermaIdDAO;

    @Autowired
    public DefaultPermaIdCacheManager(ReviewPermaIdDAO reviewPermaIdDAO) {
        this.reviewPermaIdDAO = reviewPermaIdDAO;
    }

    @Override
    @Transactional
    public int getNextPermaId(final String projectKey) {
        try {
            final Thread thread = Thread.currentThread();
            String projectKeyToLowerCase = this.convertKeyToLowerCase(projectKey);
            AtomicInteger permaIdCached = (AtomicInteger)this.permaIdCache.get((Object)projectKeyToLowerCase, (Callable)new Callable<AtomicInteger>(){

                @Override
                public AtomicInteger call() throws Exception {
                    Preconditions.checkState((thread == Thread.currentThread() ? 1 : 0) != 0);
                    Integer i2 = DefaultPermaIdCacheManager.this.reviewPermaIdDAO.getMaxNumberForProject(projectKey);
                    return new AtomicInteger(i2 == null ? 0 : i2);
                }
            });
            return permaIdCached.incrementAndGet();
        }
        catch (ExecutionException e2) {
            throw new UncheckedExecutionException((Throwable)e2);
        }
    }

    @Override
    @NonTransactional
    public void removePermaIdFromCache(String projectKey) {
        this.permaIdCache.invalidate((Object)this.convertKeyToLowerCase(projectKey));
    }

    private String convertKeyToLowerCase(String projectKey) {
        return projectKey.toLowerCase(Locale.US);
    }
}

