/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers.impl;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.CrucibleActivityItem;
import com.cenqua.crucible.model.managers.CrucibleActivityItemManager;
import com.cenqua.crucible.model.managers.CrucibleActivityItemParameter;
import com.cenqua.crucible.model.managers.CrucibleUserManager;
import com.cenqua.crucible.model.managers.LogAction;
import com.cenqua.crucible.model.managers.Order;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Component;

@Component(value="crucibleActivityItemManager")
@AvailableToPlugins
public class DefaultCrucibleActivityItemManager
implements CrucibleActivityItemManager {
    private static final EnumSet<CrucibleActivityItemParameter.Operator> NO_VALUE_OPERATOR = EnumSet.of(CrucibleActivityItemParameter.Operator.IS_EMPTY, CrucibleActivityItemParameter.Operator.IS_NOT_EMPTY, CrucibleActivityItemParameter.Operator.IS_NOT_NULL, CrucibleActivityItemParameter.Operator.IS_NULL);
    private static final Function<Object, String> toKeyFunction = new Function<Object, String>(){

        public String apply(Object logAction) {
            if (logAction instanceof LogAction) {
                return ((LogAction)((Object)logAction)).getKey();
            }
            throw new IllegalArgumentException("Object should be of type LogAction but was " + logAction.getClass());
        }
    };
    private static final Function<Object, Integer> toUserIdFunction = new Function<Object, Integer>(){

        public Integer apply(Object username) {
            FecruUser user = CrucibleUserManager.getUserByName(String.valueOf(username));
            return user == null ? 0 : user.getId();
        }
    };
    private static final Function<Object, Long> toDateTimeFunction = new Function<Object, Long>(){

        public Long apply(Object date) {
            if (date instanceof Date) {
                return ((Date)date).getTime();
            }
            throw new IllegalArgumentException("Object should be of type java.util.Date but was " + date.getClass());
        }
    };
    private static final Map<CrucibleActivityItemParameter.ActivityItemKey, Function<Object, ?>> activityItemKeyValueTransforms = ImmutableMap.builder().put((Object)CrucibleActivityItemParameter.ActivityItemKey.USERNAME, toUserIdFunction).put((Object)CrucibleActivityItemParameter.ActivityItemKey.LOG_ACTION, toKeyFunction).put((Object)CrucibleActivityItemParameter.ActivityItemKey.CREATE_DATE, toDateTimeFunction).build();

    private static Session session() {
        return HibernateUtil.currentSession();
    }

    @Override
    public List<CrucibleActivityItem> getActivityForReviewsAndUsers(Iterable<CrucibleActivityItemParameter> parameters, Order order) {
        return this.getActivityForReviewsAndUsers(parameters, null, order);
    }

    @Override
    public List<CrucibleActivityItem> getActivityForReviewsAndUsers(Iterable<CrucibleActivityItemParameter> parameters, Integer maxResults, Order order) {
        Criteria c2 = DefaultCrucibleActivityItemManager.session().createCriteria(CrucibleActivityItem.class).setFetchMode("review", FetchMode.JOIN);
        if (this.hasParam(parameters, CrucibleActivityItemParameter.ActivityItemKey.PROJECT_KEY)) {
            c2.createAlias("review.project", "project");
        }
        for (CrucibleActivityItemParameter param : parameters) {
            Criterion q2;
            if (CollectionUtils.isEmpty(param.getValues()) && !NO_VALUE_OPERATOR.contains((Object)param.getOperator()) || (q2 = this.buildRestriction(param)) == null) continue;
            c2.add(q2);
        }
        if (maxResults != null) {
            c2.setMaxResults(maxResults.intValue());
        }
        if (Order.ASC.equals((Object)order)) {
            c2.addOrder(org.hibernate.criterion.Order.asc((String)"createDateTime"));
        } else {
            c2.addOrder(org.hibernate.criterion.Order.desc((String)"createDateTime"));
        }
        List<CrucibleActivityItem> list = Collections.checkedList(new LinkedList(), CrucibleActivityItem.class);
        list.addAll(c2.list());
        HashSet<String> messages = new HashSet<String>();
        ListIterator<CrucibleActivityItem> iterator = list.listIterator(list.size());
        while (iterator.hasPrevious()) {
            CrucibleActivityItem item = iterator.previous();
            LogAction action = LogAction.getAction(item.getAction());
            if (LogAction.COMMENT_ADDED != action && LogAction.COMMENT_UPDATED != action && LogAction.COMMENT_CHANGED != action) continue;
            if (LogAction.COMMENT_UPDATED == action || !Strings.isNullOrEmpty((String)item.getDescription()) && messages.contains(item.getDescription())) {
                iterator.remove();
                continue;
            }
            messages.add(item.getDescription());
        }
        return list;
    }

    private Criterion buildRestriction(CrucibleActivityItemParameter param) {
        ImmutableSet values;
        ImmutableSet immutableSet = values = activityItemKeyValueTransforms.containsKey((Object)param.getKey()) ? ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform(param.getValues(), activityItemKeyValueTransforms.get((Object)param.getKey())), (Predicate)Predicates.notNull())) : ImmutableSet.copyOf((Iterable)Iterables.filter(param.getValues(), (Predicate)Predicates.notNull()));
        if (Iterables.isEmpty((Iterable)values)) {
            return null;
        }
        switch (param.getOperator()) {
            case EQ: {
                return Restrictions.eq((String)param.getKey().value(), (Object)Iterables.getOnlyElement((Iterable)values));
            }
            case NOT: {
                return Restrictions.not((Criterion)Restrictions.eq((String)param.getKey().value(), (Object)Iterables.getOnlyElement((Iterable)values)));
            }
            case IN: {
                return Restrictions.in((String)param.getKey().value(), (Collection)values);
            }
            case NOT_IN: {
                return Restrictions.not((Criterion)Restrictions.in((String)param.getKey().value(), (Collection)values));
            }
            case GE: {
                return Restrictions.ge((String)param.getKey().value(), (Object)Iterables.getOnlyElement((Iterable)values));
            }
            case GT: {
                return Restrictions.gt((String)param.getKey().value(), (Object)Iterables.getOnlyElement((Iterable)values));
            }
            case LE: {
                return Restrictions.le((String)param.getKey().value(), (Object)Iterables.getOnlyElement((Iterable)values));
            }
            case LT: {
                return Restrictions.lt((String)param.getKey().value(), (Object)Iterables.getOnlyElement((Iterable)values));
            }
            case IS_EMPTY: {
                return Restrictions.isEmpty((String)param.getKey().value());
            }
            case IS_NOT_EMPTY: {
                return Restrictions.isNotEmpty((String)param.getKey().value());
            }
            case IS_NULL: {
                return Restrictions.isNull((String)param.getKey().value());
            }
            case IS_NOT_NULL: {
                return Restrictions.isNotNull((String)param.getKey().value());
            }
        }
        throw new IllegalArgumentException("Invalid operator type");
    }

    private boolean hasParam(Iterable<CrucibleActivityItemParameter> parameters, CrucibleActivityItemParameter.ActivityItemKey activityItemKey) {
        return Iterables.any(parameters, this.withItemKey(activityItemKey));
    }

    private Predicate<CrucibleActivityItemParameter> withItemKey(CrucibleActivityItemParameter.ActivityItemKey activityItemKey) {
        return new WithItemKey(activityItemKey);
    }

    private static final class WithItemKey
    implements Predicate<CrucibleActivityItemParameter> {
        private final CrucibleActivityItemParameter.ActivityItemKey activityItemKey;

        public WithItemKey(CrucibleActivityItemParameter.ActivityItemKey activityItemKey) {
            this.activityItemKey = activityItemKey;
        }

        public boolean apply(CrucibleActivityItemParameter param) {
            return this.activityItemKey == param.getKey() && param.getValues() != null && !Iterables.isEmpty(param.getValues());
        }
    }
}

