/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.UserAppLink;
import com.cenqua.crucible.model.managers.UserAppLinkManager;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.stereotype.Component;

@Component
public class UserAppLinkManagerImpl
implements UserAppLinkManager {
    private Session session() {
        return HibernateUtil.currentSession();
    }

    @Override
    public List<UserAppLink> getUserAppLinks(FecruUser user) {
        Query q2 = this.session().createQuery("select link from UserAppLink link where link.user = :user");
        q2.setEntity("user", (Object)user);
        return new ArrayList<UserAppLink>(q2.list());
    }

    @Override
    public UserAppLink getOrCreateUserAppLink(FecruUser user, ApplicationLink applicationLink) {
        UserAppLink userAppLink = this.getUserAppLink(user, applicationLink);
        if (userAppLink == null) {
            userAppLink = new UserAppLink(applicationLink.getId().get());
            userAppLink.setUser(user);
            this.session().save((Object)userAppLink);
        }
        return userAppLink;
    }

    @Override
    public UserAppLink getUserAppLink(FecruUser user, ApplicationLink applicationLink) {
        if (user == null) {
            return null;
        }
        Query q2 = this.session().createQuery("select link from UserAppLink link where link.user = :user and link.appLinkId = :linkId");
        q2.setEntity("user", (Object)user);
        q2.setString("linkId", applicationLink.getId().get());
        return (UserAppLink)q2.uniqueResult();
    }
}

