/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.atlassian.crucible.spi.services.NotFoundException;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.tags.ReviewUtil;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class UserActionManager {
    private static UserActionManager INSTANCE;
    public static final String ACTION_VIEW;
    public static final String ACTION_CREATE;
    public static final String ACTION_ABANDON;
    public static final String ACTION_DELETE;
    public static final String ACTION_SUBMIT;
    public static final String ACTION_APPROVE;
    public static final String ACTION_REJECT;
    public static final String ACTION_SUMMARIZE;
    public static final String ACTION_CLOSE;
    public static final String ACTION_REOPEN;
    public static final String ACTION_RECOVER;
    public static final String ACTION_COMPLETE;
    public static final String ACTION_UNCOMPLETE;
    public static final String ACTION_COMMENT;
    public static final String ACTION_MOD_FILES;
    private Map<String, Action> actionMap = new HashMap<String, Action>();
    private Map<Review.ReviewType, Set<Action>> mapByType = new EnumMap<Review.ReviewType, Set<Action>>(Review.ReviewType.class);

    public static synchronized UserActionManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new UserActionManager();
        }
        return INSTANCE;
    }

    public static void resetForTests() {
        INSTANCE = null;
    }

    private UserActionManager() {
        this.setUpActions();
    }

    private void setUpActions() {
        for (Action a2 : Action.values()) {
            this.putAction(a2);
        }
    }

    private void putAction(Action a2) {
        this.actionMap.put(a2.getName(), a2);
        for (Review.ReviewType type : a2.reviewType) {
            Set<Action> typeActions = this.mapByType.get((Object)type);
            if (typeActions == null) {
                typeActions = EnumSet.noneOf(Action.class);
                this.mapByType.put(type, typeActions);
            }
            typeActions.add(a2);
        }
    }

    public Action ensureActionExists(String actionName) throws NotFoundException {
        Preconditions.checkNotNull((Object)actionName, (Object)"Action name is null");
        Action action = this.getAction(actionName);
        if (action != null) {
            return action;
        }
        throw new NotFoundException(String.format("Action: %s not found. Following actions are defined: %s", actionName, StringUtils.join(Action.mapByName.keySet(), (String)", ")));
    }

    public Action getAction(String name) {
        return this.actionMap.get(name);
    }

    public Collection<Action> getActions() {
        return this.actionMap.values();
    }

    public Collection<Action> getAllowedActions(Principal principal, Review review, ReviewUtil.AllowedActionsCache permissionCache) {
        return ReviewUtil.actionsAllowedForPrincipal(principal, (Collection<Action>)this.mapByType.get((Object)review.getType()), review, permissionCache);
    }

    static {
        ACTION_VIEW = Action.ACTION_VIEW.getName();
        ACTION_CREATE = Action.ACTION_CREATE.getName();
        ACTION_ABANDON = Action.ACTION_ABANDON.getName();
        ACTION_DELETE = Action.ACTION_DELETE.getName();
        ACTION_SUBMIT = Action.ACTION_SUBMIT.getName();
        ACTION_APPROVE = Action.ACTION_APPROVE.getName();
        ACTION_REJECT = Action.ACTION_REJECT.getName();
        ACTION_SUMMARIZE = Action.ACTION_SUMMARIZE.getName();
        ACTION_CLOSE = Action.ACTION_CLOSE.getName();
        ACTION_REOPEN = Action.ACTION_REOPEN.getName();
        ACTION_RECOVER = Action.ACTION_RECOVER.getName();
        ACTION_COMPLETE = Action.ACTION_COMPLETE.getName();
        ACTION_UNCOMPLETE = Action.ACTION_UNCOMPLETE.getName();
        ACTION_COMMENT = Action.ACTION_COMMENT.getName();
        ACTION_MOD_FILES = Action.ACTION_MOD_FILES.getName();
    }

    public static enum Action {
        ACTION_VIEW("action:viewReview", "View", "view a review or snippet", false, false, true, Review.ReviewType.REVIEW, Review.ReviewType.SNIPPET),
        ACTION_CREATE("action:createReview", "Create", "create a review or snippet", false, true, false, Review.ReviewType.REVIEW, Review.ReviewType.SNIPPET),
        ACTION_ABANDON("action:abandonReview", "Abandon", "abandon (i.e. cancel) a review", false),
        ACTION_DELETE("action:deleteReview", "Delete", "permanently delete a review or snippet", false, true, false, Review.ReviewType.REVIEW, Review.ReviewType.SNIPPET),
        ACTION_SUBMIT("action:submitReview", "Submit", "submit a review to the moderator for approval", false),
        ACTION_APPROVE("action:approveReview", "Approve", "approve a review (i.e. issue it to the reviewers)", false),
        ACTION_REJECT("action:rejectReview", "Reject", "reject a review submitted for approval", false),
        ACTION_SUMMARIZE("action:summarizeReview", "Summarize", "summarize a review", false),
        ACTION_CLOSE("action:closeReview", "Close", "close a review or snippet once it has been summarized", true, true, false, Review.ReviewType.REVIEW, Review.ReviewType.SNIPPET),
        ACTION_REOPEN("action:reopenReview", "Re-Open", "re-open a closed review or snippet", false, true, false, Review.ReviewType.REVIEW, Review.ReviewType.SNIPPET),
        ACTION_RECOVER("action:recoverReview", "Recover", "recover an abandoned review", false),
        ACTION_COMPLETE("action:completeReview", "Complete", "indicate they have completed a review", true, true, false, Review.ReviewType.REVIEW),
        ACTION_UNCOMPLETE("action:uncompleteReview", "Uncomplete", "indicate they have not completed a review, after indicating they have completed a review", false),
        ACTION_COMMENT("action:commentOnReview", "Comment", "add or remove a comment on a review", false),
        ACTION_MOD_FILES("action:modifyReviewFiles", "Edit Review Details", "change review details including the set of revisions being reviewed", false);

        private final String name;
        private final String displayName;
        private final String permissionDescription;
        private final boolean confirmationNeeded;
        private static Map<String, Action> mapByName;
        private final boolean crucibleLicenseRequired;
        private EnumSet<Review.ReviewType> reviewType;
        private final boolean allowsAnonymousPermission;

        private Action(String name, String displayName, String permissionDescription, boolean allowsAnonymousPermission) {
            this(name, displayName, permissionDescription, false, true, allowsAnonymousPermission, Review.ReviewType.REVIEW);
        }

        private Action(String name, String displayName, String permissionDescription, boolean confirmationNeeded, boolean crucibleLicenseRequired, boolean allowsAnonymousPermission, Review.ReviewType ... reviewTypes) {
            this.name = name;
            this.displayName = displayName;
            this.permissionDescription = permissionDescription;
            this.confirmationNeeded = confirmationNeeded;
            this.crucibleLicenseRequired = crucibleLicenseRequired;
            this.allowsAnonymousPermission = allowsAnonymousPermission;
            this.reviewType = EnumSet.copyOf(Arrays.asList(reviewTypes));
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getPermissionDescription() {
            return this.permissionDescription;
        }

        public String getPermissionViolationMsg() {
            return "you are not authorized to " + this.permissionDescription;
        }

        public boolean isConfirmationNeeded() {
            return this.confirmationNeeded;
        }

        public boolean isCrucibleLicenseRequired() {
            return this.crucibleLicenseRequired;
        }

        public static Action getByName(String name) {
            return mapByName.get(name);
        }

        public boolean allowsAnonymousPermission() {
            return this.allowsAnonymousPermission;
        }

        static {
            mapByName = new HashMap<String, Action>();
            for (Action a2 : Action.values()) {
                mapByName.put(a2.getName(), a2);
            }
        }
    }
}

