/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.CommentReadStatus;
import com.cenqua.crucible.model.FRXComment;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.InlineComment;
import com.cenqua.crucible.model.Review;
import org.hibernate.Session;
import org.springframework.stereotype.Component;

@Component(value="unreadManager")
public class UnreadManager {
    private static Session session() {
        return HibernateUtil.currentSession();
    }

    private static boolean checkArguments(FecruUser user, Comment comment) {
        if (user == null) {
            return false;
        }
        if (comment == null) {
            throw new NullPointerException("Comment cannot be null.");
        }
        return true;
    }

    public boolean isMarkedLeaveUnread(FecruUser user, Comment comment) {
        if (!UnreadManager.checkArguments(user, comment)) {
            return false;
        }
        if (!comment.getReview().checkWriteAccess(user)) {
            return false;
        }
        CommentReadStatus read = comment.getReadStatus(user);
        return read != null && !read.isRead();
    }

    public CommentReadStatus markAsRead(FecruUser user, Comment comment) {
        return this.updateReadStatus(user, comment, true);
    }

    public CommentReadStatus markAsLeaveUnread(FecruUser user, Comment comment) {
        return this.updateReadStatus(user, comment, false);
    }

    private CommentReadStatus updateReadStatus(FecruUser user, Comment comment, boolean markAsRead) {
        if (!UnreadManager.checkArguments(user, comment)) {
            return null;
        }
        CommentReadStatus crs = comment.getReadStatus(user);
        if (crs == null) {
            crs = new CommentReadStatus();
            crs.setUser(user);
            crs.setComment(comment);
            comment.getCommentReadStatus().add(crs);
        }
        crs.setRead(markAsRead);
        UnreadManager.session().save((Object)crs);
        return crs;
    }

    public void markFRXCommentsAsRead(FecruUser user, FileRevisionExtraInfo frx) {
        for (FRXComment fRXComment : frx.getFrxComments()) {
            this.changeCommentStatusToRead(user, fRXComment.getComment());
            for (Comment reply : fRXComment.getComment().getComments()) {
                this.changeCommentStatusToRead(user, reply);
            }
        }
        for (InlineComment inlineComment : frx.getInlineComments()) {
            this.changeCommentStatusToRead(user, inlineComment.getComment());
            for (Comment reply : inlineComment.getComment().getComments()) {
                this.changeCommentStatusToRead(user, reply);
            }
        }
    }

    private boolean changeCommentStatusToRead(FecruUser user, Comment comment) {
        if (comment == null || comment.isDraft() || comment.getUser().equals(user) || comment.isRead(user) || this.isMarkedLeaveUnread(user, comment)) {
            return false;
        }
        this.markAsRead(user, comment);
        return true;
    }

    public void markReviewCommentsAsRead(FecruUser user, Review review) {
        for (Comment comment : review.getComments()) {
            this.changeCommentStatusToRead(user, comment);
            for (Comment reply : comment.getComments()) {
                this.changeCommentStatusToRead(user, reply);
            }
        }
    }
}

