/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.FileReadStatus;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.ReviewParticipant;
import com.cenqua.crucible.model.managers.UnreadManager;
import java.util.Date;
import org.hibernate.Session;
import org.springframework.stereotype.Component;

@Component
public class UnreadFileManager {
    private static Session session() {
        return HibernateUtil.currentSession();
    }

    private static boolean checkArguments(ReviewParticipant participant, FileRevisionExtraInfo frx) {
        if (participant == null) {
            return false;
        }
        if (frx == null) {
            throw new NullPointerException("FileRevisionExtraInfo cannot be null.");
        }
        return true;
    }

    public boolean isMarkedLeaveUnread(ReviewParticipant participant, FileRevisionExtraInfo frx) {
        if (!UnreadFileManager.checkArguments(participant, frx)) {
            return false;
        }
        if (!frx.getReview().checkWriteAccess(participant.getUser())) {
            return false;
        }
        FileReadStatus read = participant.getReadStatus(frx);
        return read != null && read.getRead() != null && read.getRead() == false;
    }

    public FileReadStatus markAsRead(ReviewParticipant participant, FileRevisionExtraInfo frx) {
        return this.updateReadStatus(participant, frx, true);
    }

    public FileReadStatus markAsLeaveUnread(ReviewParticipant participant, FileRevisionExtraInfo frx) {
        new UnreadManager().markFRXCommentsAsRead(participant.getUser(), frx);
        return this.updateReadStatus(participant, frx, false);
    }

    public FileReadStatus markAsUnread(ReviewParticipant participant, FileRevisionExtraInfo frx, Date unreadDate, boolean forceSetUnreadDate) {
        if (!forceSetUnreadDate && participant.getFileReadStatus().size() == 0) {
            return null;
        }
        return this.updateReadStatus(participant, frx, null, unreadDate, forceSetUnreadDate);
    }

    private FileReadStatus updateReadStatus(ReviewParticipant participant, FileRevisionExtraInfo frx, Boolean markAsRead) {
        return this.updateReadStatus(participant, frx, markAsRead, null, false);
    }

    private FileReadStatus updateReadStatus(ReviewParticipant participant, FileRevisionExtraInfo frx, Boolean markAsRead, Date unreadDate, boolean forceSetUnreadDate) {
        if (!UnreadFileManager.checkArguments(participant, frx)) {
            return null;
        }
        FileReadStatus frs = participant.getReadStatus(frx);
        if (frs == null) {
            frs = new FileReadStatus();
            frs.setParticipant(participant);
            frs.setFrx(frx);
            participant.getFileReadStatus().add(frs);
        }
        if (forceSetUnreadDate || frs.getRead() != null && markAsRead == null && unreadDate != null) {
            frs.setLastUnreadDateTime(unreadDate.getTime());
        }
        frs.setRead(markAsRead);
        UnreadFileManager.session().save((Object)frs);
        return frs;
    }

    private boolean changeFileStatusToRead(ReviewParticipant participant, FileRevisionExtraInfo frx) {
        if (frx == null || frx.getReview().getState().isDraftMetaState() || participant.isRead(frx) || this.isMarkedLeaveUnread(participant, frx)) {
            return false;
        }
        this.markAsRead(participant, frx);
        return true;
    }

    public void deleteReadStatuses(FileRevisionExtraInfo frx) {
        for (ReviewParticipant p2 : frx.getReview().getParticipants()) {
            FileReadStatus status = p2.getReadStatus(frx);
            if (status == null) continue;
            HibernateUtil.currentSession().delete((Object)status);
        }
    }
}

