/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.SuggestedReviewer;
import com.cenqua.crucible.revision.source.RepositorySource;
import java.util.Comparator;
import java.util.Map;

public interface SuggestedReviewerManager {
    public Map<FecruUser, SuggestedReviewer> setReviewCount(Map<FecruUser, SuggestedReviewer> var1);

    public Map<FecruUser, SuggestedReviewer> addToSuggestedReviewers(Map<FecruUser, SuggestedReviewer> var1, CrucibleRevision var2, Review var3, RepositorySource var4) throws Exception;

    public static class SuggestedReviewerComparator
    implements Comparator<SuggestedReviewer> {
        private final int locWeight;
        private final int openWeight;
        private final int totalLOC;
        private final int totalCommits;
        private final int commitsWeight;

        public SuggestedReviewerComparator(int totalLOC, int totalCommits, int locWeight, int openWeight, int commitsWeight) {
            this.totalLOC = totalLOC == 0 ? 1 : totalLOC;
            this.totalCommits = totalCommits == 0 ? 1 : totalCommits;
            this.locWeight = locWeight;
            this.openWeight = openWeight;
            this.commitsWeight = commitsWeight;
        }

        @Override
        public int compare(SuggestedReviewer s1, SuggestedReviewer s2) {
            double s1Value = (double)(100 * s1.getLoc()) / (double)this.totalLOC * ((double)(100 * s1.getLoc()) / (double)this.totalLOC) * (double)this.locWeight + (double)(100 * s1.getNumberOfCommits()) / (double)this.totalCommits * ((double)(100 * s1.getNumberOfCommits()) / (double)this.totalCommits) * (double)this.commitsWeight - (double)(s1.getOpenReviews() * s1.getOpenReviews() * this.openWeight);
            double s2Value = (double)(100 * s2.getLoc()) / (double)this.totalLOC * ((double)(100 * s2.getLoc()) / (double)this.totalLOC) * (double)this.locWeight + (double)(100 * s2.getNumberOfCommits()) / (double)this.totalCommits * ((double)(100 * s2.getNumberOfCommits()) / (double)this.totalCommits) * (double)this.commitsWeight - (double)(s2.getOpenReviews() * s2.getOpenReviews() * this.openWeight);
            return (int)(s2Value - s1Value);
        }
    }
}

