/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.atlassian.crucible.spi.data.ReviewData;
import com.cenqua.crucible.model.Role;
import com.cenqua.crucible.model.State;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.fisheye.logging.Logs;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class StateManager {
    public static final StateManager INSTANCE = new StateManager();
    private LinkedHashMap<String, State> states = new LinkedHashMap();
    private Map<MetaState, Set<String>> metaGroups = new EnumMap<MetaState, Set<String>>(MetaState.class);
    private State unknown;

    private StateManager() {
        this.setupStates();
    }

    private void setupStates() {
        State draft = this.addState("Draft", "Draft", States.DRAFT_STATE, MetaState.DRAFT);
        State approval = this.addState("Approval", "Pending Approval", States.APPROVAL_STATE, MetaState.DRAFT);
        State review = this.addState("Review", "Under Review", States.REVIEW_STATE, MetaState.OPEN);
        State summarize = this.addState("Summarize", "Summarize", States.SUMMARIZE_STATE, MetaState.OPEN);
        State closed = this.addState("Closed", "Closed", States.CLOSED_STATE, MetaState.CLOSED);
        State dead = this.addState("Dead", "Abandoned", States.DEAD_STATE, MetaState.TRASH);
        State rejected = this.addState("Rejected", "Rejected", States.REJECTED_STATE, MetaState.TRASH);
        this.unknown = this.addState("Unknown", "Needs Fixing", States.NONE_STATE, null);
        draft.addTransition(approval, UserActionManager.ACTION_SUBMIT, "Send to Moderator");
        draft.addTransition(review, UserActionManager.ACTION_APPROVE, "Start Review", 10);
        draft.addTransition(dead, UserActionManager.ACTION_ABANDON, "Abandon Review");
        approval.addTransition(review, UserActionManager.ACTION_APPROVE, "Start Review", 10);
        approval.addTransition(rejected, UserActionManager.ACTION_REJECT, "Reject");
        approval.addTransition(dead, UserActionManager.ACTION_ABANDON, "Abandon Review");
        review.addTransition(summarize, UserActionManager.ACTION_SUMMARIZE, "Summarize", 20);
        review.addTransition(closed, UserActionManager.ACTION_CLOSE, "Close", 10);
        review.addTransition(dead, UserActionManager.ACTION_ABANDON, "Abandon Review");
        summarize.addTransition(closed, UserActionManager.ACTION_CLOSE, "Close", 10);
        summarize.addTransition(review, UserActionManager.ACTION_REOPEN, "Reopen");
        summarize.addTransition(dead, UserActionManager.ACTION_ABANDON, "Abandon Review");
        rejected.addTransition(draft, UserActionManager.ACTION_REOPEN, "Re-create Review", 10);
        rejected.addTransition(dead, UserActionManager.ACTION_ABANDON, "Abandon Review");
        closed.addTransition(review, UserActionManager.ACTION_REOPEN, "Reopen");
        dead.addTransition(draft, UserActionManager.ACTION_RECOVER, "Recover Dead Review");
        this.unknown.addTransition(review, UserActionManager.ACTION_REOPEN, "Set to Review");
        this.unknown.addTransition(review, UserActionManager.ACTION_ABANDON, "Delete Review");
        this.unknown.addTransition(review, UserActionManager.ACTION_CLOSE, "Close Review");
        summarize.addEntryScript("cleanup:");
        closed.addEntryScript("cleanup:");
        closed.addEntryScript("markReviewed:");
        approval.addStateChangeNotifactionRole(ReviewManager.MODERATOR);
        review.addStateChangeNotifactionRole(ReviewManager.AUTHOR);
        review.addStateChangeNotifactionRole(ReviewManager.REVIEWER);
        summarize.addStateChangeNotifactionRole(ReviewManager.AUTHOR);
        summarize.addStateChangeNotifactionRole(ReviewManager.REVIEWER);
        closed.addStateChangeNotifactionRole(ReviewManager.AUTHOR);
        closed.addStateChangeNotifactionRole(ReviewManager.REVIEWER);
        rejected.addStateChangeNotifactionRole(ReviewManager.AUTHOR);
        this.unknown.addStateChangeNotifactionRole(ReviewManager.MODERATOR);
        State openSnippet = this.addState("Open Snippet", "Open", States.OPEN_SNIPPET_STATE, MetaState.OPEN);
        State closedSnippet = this.addState("Closed Snippet", "Closed", States.CLOSED_SNIPPET_STATE, MetaState.CLOSED);
        openSnippet.addTransition(closedSnippet, UserActionManager.ACTION_CLOSE, "Close", 10);
        closedSnippet.addTransition(openSnippet, UserActionManager.ACTION_REOPEN, "Reopen", 10);
    }

    private State addState(String stateName, String verbage, States stateType, MetaState ms) {
        State state = new State(stateName, verbage, stateType, ms);
        this.states.put(stateName.toLowerCase(Locale.US), state);
        if (ms != null) {
            Set<String> set = this.metaGroups.get((Object)ms);
            if (set == null) {
                set = new LinkedHashSet<String>();
                this.metaGroups.put(ms, set);
            }
            set.add(stateName);
        }
        return state;
    }

    public List<Role> getStateChangeNotificationRules(String state) {
        return this.getStateByName(state).getStateChangeNotificationRoles();
    }

    public State getStateByName(String stateName) {
        State ret = this.states.get(StringUtils.defaultString((String)stateName).toLowerCase(Locale.US));
        if (ret == null) {
            Logs.APP_LOG.warn((Object)("Crucible State (" + stateName + ") not defined, returning \"Unknown\" state"), new Throwable());
            ret = this.unknown;
        }
        return ret;
    }

    public State getFirstState() {
        return this.states.values().iterator().next();
    }

    public List<State> getStates() {
        return new LinkedList<State>(this.states.values());
    }

    private State getStateByType(States stateType) {
        for (State state : this.states.values()) {
            if (state.getStateType() != stateType) continue;
            return state;
        }
        return null;
    }

    public State getDraftState() {
        return this.getStateByType(States.DRAFT_STATE);
    }

    public State getApprovalState() {
        return this.getStateByType(States.APPROVAL_STATE);
    }

    public State getReviewState() {
        return this.getStateByType(States.REVIEW_STATE);
    }

    public State getSummarizeState() {
        return this.getStateByType(States.SUMMARIZE_STATE);
    }

    public State getClosedState() {
        return this.getStateByType(States.CLOSED_STATE);
    }

    public State getRejectedState() {
        return this.getStateByType(States.REJECTED_STATE);
    }

    public State getDeadState() {
        return this.getStateByType(States.DEAD_STATE);
    }

    public State getUnknownState() {
        return this.getStateByType(States.NONE_STATE);
    }

    public State getSnippetOpenState() {
        return this.getStateByType(States.OPEN_SNIPPET_STATE);
    }

    public String[] getDraftStateNames() {
        Set<String> set = this.metaGroups.get((Object)MetaState.DRAFT);
        return set.toArray(new String[set.size()]);
    }

    public String[] getOpenStateNames() {
        Set<String> set = this.metaGroups.get((Object)MetaState.OPEN);
        return set.toArray(new String[set.size()]);
    }

    public String[] getClosedStateNames() {
        Set<String> set = this.metaGroups.get((Object)MetaState.CLOSED);
        return set.toArray(new String[set.size()]);
    }

    private State[] getStatesForNames(Set<String> set) {
        State[] states = new State[set.size()];
        int i2 = 0;
        for (String s2 : set) {
            states[i2++] = this.getStateByName(s2);
        }
        return states;
    }

    public State[] getDraftStates() {
        Set<String> set = this.metaGroups.get((Object)MetaState.DRAFT);
        return this.getStatesForNames(set);
    }

    public State[] getOpenStates() {
        Set<String> set = this.metaGroups.get((Object)MetaState.OPEN);
        return this.getStatesForNames(set);
    }

    public String[] getNotDeadStateNames() {
        return new String[]{this.getDraftState().getName(), this.getApprovalState().getName(), this.getReviewState().getName(), this.getSummarizeState().getName(), this.getClosedState().getName(), this.getRejectedState().getName(), this.getUnknownState().getName()};
    }

    public boolean isStateName(String name) {
        return this.states.keySet().contains(name.toLowerCase(Locale.US));
    }

    public static enum States {
        NONE_STATE(ReviewData.State.Unknown),
        DRAFT_STATE(ReviewData.State.Draft),
        APPROVAL_STATE(ReviewData.State.Approval),
        REVIEW_STATE(ReviewData.State.Review),
        SUMMARIZE_STATE(ReviewData.State.Summarize),
        CLOSED_STATE(ReviewData.State.Closed),
        DEAD_STATE(ReviewData.State.Dead, true),
        REJECTED_STATE(ReviewData.State.Rejected),
        OPEN_SNIPPET_STATE(ReviewData.State.OpenSnippet, true),
        CLOSED_SNIPPET_STATE(ReviewData.State.ClosedSnippet, true);

        private boolean deletable;
        private ReviewData.State reviewDataState;

        private States(ReviewData.State reviewDataState) {
            this(reviewDataState, false);
        }

        private States(ReviewData.State reviewDataState, boolean deletable) {
            this.deletable = deletable;
            this.reviewDataState = reviewDataState;
        }

        public boolean isDeletable() {
            return this.deletable;
        }

        public ReviewData.State getReviewDataState() {
            return this.reviewDataState;
        }
    }

    public static enum MetaState {
        DRAFT,
        OPEN,
        CLOSED,
        TRASH;

    }
}

