/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.atlassian.crucible.spi.data.ReviewData;
import com.google.common.collect.ImmutableList;

public class ReviewPropertiesSearchCriteria {
    private final String reviewPermaId;
    private final Iterable<String> names;
    private final String namePrefix;
    private final Iterable<ReviewData.State> reviewStates;
    private final int limit;

    public ReviewPropertiesSearchCriteria(String reviewPermaId, Iterable<String> names, String namePrefix, Iterable<ReviewData.State> reviewStates, int limit) {
        this.reviewPermaId = reviewPermaId;
        this.names = names;
        this.namePrefix = namePrefix;
        this.reviewStates = reviewStates;
        this.limit = limit;
    }

    public String getReviewPermaId() {
        return this.reviewPermaId;
    }

    public Iterable<String> getNames() {
        return this.names;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public Iterable<ReviewData.State> getReviewStates() {
        return this.reviewStates;
    }

    public int getLimit() {
        return this.limit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String reviewPermaId;
        private Iterable<String> names;
        private String namePrefix;
        private Iterable<ReviewData.State> reviewStates;
        private int limit = 1000;

        Builder() {
        }

        public Builder reviewPermaId(String reviewPermaId) {
            this.reviewPermaId = reviewPermaId;
            return this;
        }

        public Builder names(Iterable<String> names) {
            this.names = names;
            return this;
        }

        public Builder names(String ... names) {
            return this.names((Iterable<String>)ImmutableList.copyOf((Object[])names));
        }

        public Builder namePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
            return this;
        }

        public Builder reviewStates(Iterable<ReviewData.State> reviewStates) {
            this.reviewStates = reviewStates;
            return this;
        }

        public Builder reviewStates(ReviewData.State ... reviewStates) {
            return this.reviewStates((Iterable<ReviewData.State>)ImmutableList.copyOf((Object[])reviewStates));
        }

        public Builder limit(int limit) {
            this.limit = limit;
            return this;
        }

        public ReviewPropertiesSearchCriteria build() {
            return new ReviewPropertiesSearchCriteria(this.reviewPermaId, this.names, this.namePrefix, this.reviewStates, this.limit);
        }
    }
}

