/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.atlassian.crucible.spi.services.NotFoundException;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.Visitor;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.PermaIdFormatException;
import com.cenqua.crucible.model.PermaIdKey;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewParticipant;
import com.cenqua.crucible.model.Role;
import com.cenqua.crucible.model.managers.LogRecordProcessor;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.model.managers.ReviewIterator;
import com.cenqua.crucible.util.ReviewSort;
import com.cenqua.crucible.view.reviewfilters.ReviewFilterDef;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.DbException;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public interface ReviewManager {
    public static final Role AUTHOR = new Role("Author", 1);
    public static final Role MODERATOR = new Role("Moderator", 2);
    public static final Role REVIEWER = new Role("Reviewer", 3);
    public static final Role CREATOR = new Role("Creator", 4);
    public static final String PERMAID_KEY_PATTERN = "([A-Z0-9\\-]+)";
    public static final String PERMAID_PATTERN = "([A-Z0-9\\-]+)-(\\d{1,9})";
    public static final Pattern PERMAID_PROG = Pattern.compile("([A-Z0-9\\-]+)-(\\d{1,9})");

    public Review createSnippetReviewWithDefaults(ProjectManager var1, Project var2, String var3, FecruUser var4);

    public Review createReviewWithDefaults(ProjectManager var1, Project var2, String var3, FecruUser var4) throws DbException;

    public Review createReview(ProjectManager var1, Project var2, String var3, FecruUser var4);

    public Collection<Review> getReviews();

    public Object2LongMap<String> getReviewCountForUsers(Path var1, String var2, Set<String> var3);

    public Collection<Review> getMatchingReviews(ReviewFilterDef var1, String var2);

    public Collection<Integer> getMatchingReviewIds(ReviewFilterDef var1, String var2);

    public List<Integer> getMatchingReviewIds(ReviewFilterDef var1, String var2, ReviewSort var3);

    public int getMatchingReviewCount(ReviewFilterDef var1);

    public int getMatchingReviewCount(ReviewFilterDef var1, String var2);

    public List<Review> findReviewsByDueDate(Project var1, Date var2);

    public List<Review> getReviewsWithLinkedJira(String var1);

    public Map<String, Long> countStatesOn(Date var1, Project var2);

    public void processLogRecords(Date var1, Date var2, Project var3, LogRecordProcessor var4);

    public Collection<Review> getReviewsInStates(String[] var1);

    public Collection<Review> getReviewsInStates(Project var1, String[] var2);

    public List<Object[]> getRevisionDetailsConsideredInReviews(String var1);

    public boolean isConsideredInReview(CrucibleRevision var1, Integer var2);

    public int countReviewsCreatedInPeriod(Date var1, Date var2, Project var3);

    public List<Review> getReviewChildren(Review var1);

    public List<Review> getReviewChildren(Review var1, String[] var2, boolean var3);

    public Review getReviewById(int var1);

    public Review getReviewByPermaId(String var1) throws PermaIdFormatException;

    public PermaIdKey parsePermaId(String var1);

    public Review getReviewByPermaId(PermaIdKey var1);

    public boolean reviewExists(String var1);

    public boolean reviewExists(PermaIdKey var1);

    public Collection<Review> getReviewsByIds(Collection<Integer> var1);

    public List<Review> getReviewsOrderedByIds(List<Integer> var1);

    public ReviewIterator getReviewIteratorForIds(Collection<Integer> var1);

    public ReviewIterator getReviewIteratorForIds(Collection<Integer> var1, int var2);

    public Review getReviewById(Integer var1);

    public boolean isVisible(Review var1, Principal var2);

    public ReviewParticipant addReviewer(Review var1, FecruUser var2);

    public boolean deleteReview(Review var1, FecruUser var2);

    public void changeState(Review var1, String var2, FecruUser var3) throws Exception;

    public void visitAllReviews(Visitor<Review> var1);

    public Set searchReviewForTerm(String var1, String var2, String var3, Integer var4);

    public List searchReviewForTerms(List<String> var1, String var2, String var3, Integer var4, String var5);

    public Role ensureReviewRoleExists(String var1) throws NotFoundException;

    public void completeReview(Review var1, FecruUser var2, boolean var3);
}

