/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.atlassian.fecru.iterators.PrefetchIterator;
import com.atlassian.fecru.iterators.PrefetchIteratorValueProvider;
import com.atlassian.fecru.iterators.SkippableIterator;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.ReviewManager;
import java.util.Collection;
import java.util.List;

public class ReviewIterator
implements SkippableIterator<Review> {
    private static final int DEFAULT_STEP = 100;
    private SkippableIterator<Review> prefetchIterator;

    public ReviewIterator(Collection<Integer> ids, ReviewManager reviewManager) {
        this(ids, reviewManager, 100);
    }

    public ReviewIterator(Collection<Integer> ids, final ReviewManager reviewManager, int prefetchSize) {
        this.prefetchIterator = new PrefetchIterator<Integer, Review>(ids, new PrefetchIteratorValueProvider<Integer, Review>(){

            @Override
            public List<Review> values(List<Integer> keys) {
                return reviewManager.getReviewsOrderedByIds(keys);
            }
        }, prefetchSize);
    }

    @Override
    public boolean hasNext() {
        return this.prefetchIterator.hasNext();
    }

    @Override
    public int skip(int n2) {
        return this.prefetchIterator.skip(n2);
    }

    @Override
    public Review next() {
        return (Review)this.prefetchIterator.next();
    }

    @Override
    public void remove() {
        this.prefetchIterator.remove();
    }
}

