/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.atlassian.crucible.spi.services.ProjectSearchCriteria;
import com.atlassian.fecru.page.Page;
import com.atlassian.fecru.page.PageRequest;
import com.atlassian.fecru.page.PagedResourceIterable;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewPermaId;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.fisheye.model.ContentRoot;
import com.google.common.base.Predicate;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public interface ProjectManager {
    public Page<Project> searchAllProjects(ProjectSearchCriteria var1, PageRequest var2);

    public PagedResourceIterable<Project> searchAllProjectsIterable(ProjectSearchCriteria var1);

    public int countProjects(ProjectSearchCriteria var1);

    public List<Project> getAllProjects();

    public int countProjects();

    public List<Project> getProjects(Predicate<Project> var1);

    public Project getProjectById(int var1);

    public Page<FecruUser> getProjectDefaultReviewerUsers(String var1, PageRequest var2);

    public boolean addProjectDefaultReviewerUser(String var1, FecruUser var2);

    public boolean deleteProjectDefaultReviewerUser(String var1, FecruUser var2);

    public Page<String> getProjectDefaultReviewerGroups(String var1, PageRequest var2);

    public boolean addProjectDefaultReviewerGroup(String var1, String var2);

    public boolean deleteProjectDefaultReviewerGroup(String var1, String var2);

    public Page<FecruUser> getProjectAllowedReviewerUsers(String var1, PageRequest var2);

    public boolean addProjectAllowedReviewerUser(String var1, FecruUser var2);

    public boolean deleteProjectAllowedReviewerUser(String var1, FecruUser var2);

    public Page<String> getProjectAllowedReviewerGroups(String var1, PageRequest var2);

    public boolean addProjectAllowedReviewerGroup(String var1, String var2);

    public boolean deleteProjectAllowedReviewerGroup(String var1, String var2);

    public boolean deleteProject(Project var1);

    public Project createProject(String var1, String var2);

    public Project getProjectByKey(String var1);

    public Project getDefaultProject();

    public boolean isDefaultProject(String var1);

    public ReviewPermaId getNextPermaId(Project var1, Review var2);

    public void changeProjectKey(Project var1, String var2);

    public List<String> getAllCurrentAndHistoricalProjectKeys();

    public List<String> getAllCurrentProjectKeys();

    public void moveAllReviews(@Nonnull Project var1, @Nonnull Project var2) throws IllegalArgumentException;

    public void moveReviewToProject(Review var1, Project var2);

    public void deleteAllReviews(Project var1, FecruUser var2, ReviewManager var3);

    public int countReviewsInProject(Project var1);

    public ContentRoot addRepToProject(String var1, String var2);

    public Set<String> getAllRepositoriesInProject(Project var1);

    public ContentRoot addPathToProject(String var1, String var2, String var3);

    public void deletePathFromProject(String var1, String var2, String var3);

    public boolean projectExists(int var1);

    public boolean projectExists(String var1);

    public void removeRepositoryMappings(String var1);

    public boolean isAllowedReviewer(Project var1, FecruUser var2);

    public boolean deleteProjectByKey(String var1);
}

