/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.atlassian.crucible.spi.services.NotFoundException;
import com.atlassian.crucible.spi.services.PermissionSchemeSearchCriteria;
import com.atlassian.fecru.page.Page;
import com.atlassian.fecru.page.PageRequest;
import com.atlassian.fecru.page.PagedResourceIterable;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.Role;
import com.cenqua.crucible.model.managers.UserActionManager;
import java.util.Collection;
import java.util.Set;

public interface PermissionManager {
    public boolean canPrincipalDoAction(PermissionScheme var1, Principal var2, FecruUser var3, String var4, Review var5);

    public Collection<UserActionManager.Action> canPrincipalDoActions(PermissionScheme var1, Principal var2, Collection<UserActionManager.Action> var3, Review var4);

    public boolean canPrincipalDoActionOnAllReviews(PermissionScheme var1, Principal var2, String var3);

    public boolean canEffectivePrincipalDoReviewAction(Review var1, UserActionManager.Action var2);

    public boolean isActionPreventedByLicense(String var1, Principal var2);

    public boolean isProjectVisible(Project var1);

    public boolean isProjectVisible(Principal var1, Project var2);

    public boolean canPrincipalCreateIn(Principal var1, Project var2);

    public PermissionScheme findPermissionSchemeById(int var1);

    public PermissionScheme createAgilePermissionScheme() throws DuplicatePermissionSchemeNameException;

    public PermissionScheme createAgilePermissionSchemeWithName(String var1) throws DuplicatePermissionSchemeNameException;

    public PermissionScheme copyPermissionScheme(PermissionScheme var1, String var2);

    public void deletePermissionSchemeByName(String var1);

    public PermissionScheme createPermissionScheme(String var1);

    public PermissionScheme getDefaultPermissionScheme();

    public PermissionScheme findPermissionSchemeByName(String var1);

    public PermissionScheme ensurePermissionSchemeExists(String var1) throws NotFoundException;

    public Iterable<Project> getProjectsUsingPermissionScheme(PermissionScheme var1);

    public Iterable<PermissionScheme> getPermissionSchemes();

    @Deprecated
    public Iterable<String> getAllPermissionSchemeNames();

    public int countPermissionSchemes();

    public int countPermissionSchemes(PermissionSchemeSearchCriteria var1);

    public Page<PermissionScheme> searchPermissionSchemes(PermissionSchemeSearchCriteria var1, PageRequest var2);

    public PagedResourceIterable<PermissionScheme> searchPermissionSchemesIterable(PermissionSchemeSearchCriteria var1);

    public Set<Integer> getProjectsRoleCanDoActionIn(Role var1, String var2);

    public static class DuplicatePermissionSchemeNameException
    extends Exception {
        public DuplicatePermissionSchemeNameException(String message) {
            super(message);
        }
    }
}

