/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.FileReadStatus;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewParticipant;
import org.hibernate.Session;

public class ParticipantManager {
    private static Session session() {
        return HibernateUtil.currentSession();
    }

    public static ReviewParticipant getOrCreateParticipant(Review review, FecruUser user) {
        ReviewParticipant p2 = review.getParticipant(user);
        if (p2 != null) {
            return p2;
        }
        p2 = new ReviewParticipant();
        p2.setReview(review);
        p2.setUser(user);
        ParticipantManager.session().save((Object)p2);
        review.getParticipants().add(p2);
        return p2;
    }

    public static void deleteParticipant(ReviewParticipant p2) {
        for (FileReadStatus status : p2.getFileReadStatus()) {
            ParticipantManager.session().delete((Object)status);
        }
        p2.getFileReadStatus().clear();
        ParticipantManager.session().delete((Object)p2);
    }
}

