/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.cenqua.crucible.model.managers.Order;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;

public class LogItemSearchCriteria {
    private Collection<Integer> reviewIds;
    private Collection<String> actions;
    private Date minDate;
    private Date maxDate;
    private Integer start;
    private Integer limit;
    private Order order;

    private LogItemSearchCriteria() {
    }

    public Collection<Integer> getReviewIds() {
        return this.reviewIds;
    }

    public Collection<String> getActions() {
        return this.actions;
    }

    public Date getMinDate() {
        return this.minDate;
    }

    public Date getMaxDate() {
        return this.maxDate;
    }

    public Integer getStart() {
        return this.start;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Order getOrder() {
        return this.order;
    }

    public LogItemSearchCriteria reviewIds(Collection<Integer> reviewIds) {
        this.reviewIds = reviewIds;
        return this;
    }

    public LogItemSearchCriteria reviewIds(Integer ... reviewIds) {
        return this.reviewIds(Arrays.asList(reviewIds));
    }

    public LogItemSearchCriteria actions(Collection<String> actions) {
        this.actions = actions;
        return this;
    }

    public LogItemSearchCriteria minDate(Date minDate) {
        this.minDate = minDate;
        return this;
    }

    public LogItemSearchCriteria minDate(ZonedDateTime minDate) {
        if (minDate != null) {
            Instant instant = minDate.toInstant();
            this.minDate = Date.from(instant);
        } else {
            this.minDate = null;
        }
        return this;
    }

    public LogItemSearchCriteria maxDate(Date maxDate) {
        this.maxDate = maxDate;
        return this;
    }

    public LogItemSearchCriteria maxDate(ZonedDateTime maxDate) {
        if (maxDate != null) {
            Instant instant = maxDate.toInstant();
            this.maxDate = Date.from(instant);
        } else {
            this.maxDate = null;
        }
        return this;
    }

    public LogItemSearchCriteria start(Integer start) {
        this.start = start;
        return this;
    }

    public LogItemSearchCriteria limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public LogItemSearchCriteria order(Order order) {
        this.order = order;
        return this;
    }

    public static LogItemSearchCriteria create() {
        return new LogItemSearchCriteria();
    }
}

