/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FRXRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.LogItem;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.State;
import com.cenqua.crucible.model.managers.LogAction;
import com.cenqua.crucible.model.managers.ReviewMutableProperties;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nullable;

public class LogItemBuilder {
    private final String action;
    private Integer id;
    private Integer reviewId;
    @Nullable
    private Integer userId;
    private String entityString;
    private Integer entityId;
    private Integer entityId2;
    private String newValue;
    private String oldValue;

    private LogItemBuilder(String action) {
        this.action = action;
    }

    public static LogItemBuilder create(String action) {
        return new LogItemBuilder(action);
    }

    public static LogItemBuilder create(LogAction action) {
        return LogItemBuilder.create(action.getKey());
    }

    public static LogItemBuilder from(LogItem logItem) {
        return LogItemBuilder.create(logItem.getAction()).id(logItem.getId()).reviewId(logItem.getReviewId()).userId(logItem.getUserId()).entityId(logItem.getEntityId()).entityId2(logItem.getEntityId2()).entityString(logItem.getEntityString()).newValue(logItem.getNewValue()).oldValue(logItem.getOldValue());
    }

    public LogItem build() {
        LogItem logItem = new LogItem(this.action, this.reviewId, this.userId, this.entityString, this.entityId, this.entityId2, this.oldValue, this.newValue);
        logItem.setId(this.id);
        return logItem;
    }

    public LogItemBuilder reviewId(Integer reviewId) {
        this.reviewId = reviewId;
        return this;
    }

    public LogItemBuilder id(Integer logItemId) {
        this.id = logItemId;
        return this;
    }

    public LogItemBuilder reviewId(Review review) {
        this.reviewId = review.getId();
        return this;
    }

    public LogItemBuilder userId(@Nullable Integer userId) {
        this.userId = userId;
        return this;
    }

    public LogItemBuilder userId(FecruUser user) {
        this.userId = user != null ? user.getId() : null;
        return this;
    }

    public LogItemBuilder entityString(String entityString) {
        this.entityString = entityString;
        return this;
    }

    public LogItemBuilder entityId(Integer entityId) {
        this.entityId = entityId;
        return this;
    }

    public LogItemBuilder entityId(Comment comment) {
        return this.entityId(comment.getId());
    }

    public LogItemBuilder entityId(FecruUser user) {
        return this.entityId(user.getId());
    }

    public LogItemBuilder entityId(FileRevisionExtraInfo frx) {
        return this.entityId(frx.getId());
    }

    public LogItemBuilder entityId(FRXRevision frxRev) {
        return this.entityId(frxRev.getId());
    }

    public LogItemBuilder newValue(String newValue) {
        this.newValue = newValue;
        return this;
    }

    public LogItemBuilder oldValue(String oldValue) {
        this.oldValue = oldValue;
        return this;
    }

    public LogItemBuilder entityId2(Integer entityId2) {
        this.entityId2 = entityId2;
        return this;
    }

    public LogItemBuilder entityId2(FileRevisionExtraInfo frx) {
        return this.entityId2(frx.getId());
    }

    public static LogItem buildCommentChanged(Review review, Comment comment, String newText) {
        return LogItemBuilder.create(LogAction.COMMENT_CHANGED).reviewId(review).userId(comment.getUser()).entityId(comment).oldValue(comment.getMessage()).newValue(newText).build();
    }

    public static LogItem buildCommentAdded(Review review, Comment comment) {
        return LogItemBuilder.create(LogAction.COMMENT_ADDED).reviewId(review).userId(comment.getUser()).entityId(comment).newValue(comment.getMessage()).build();
    }

    public static LogItem buildJiraIssueDeleted(Review review, FecruUser user, Comment comment) {
        return LogItemBuilder.create(LogAction.JIRA_ISSUE_DELETED).reviewId(review).userId(user).entityString(String.format(comment.getJiraIssueKey(), new Object[0])).build();
    }

    public static LogItem buildJiraIssueNotDeleted(Review review, FecruUser user, Comment comment, String errorMessage) {
        return LogItemBuilder.create(LogAction.JIRA_ISSUE_NOT_DELETED).reviewId(review).userId(user).entityString(String.format("%s: %s", comment.getJiraIssueKey(), errorMessage)).build();
    }

    public static LogItem buildReviewPropertyChanged(ReviewMutableProperties property, Review review, FecruUser user, String oldValue, String newValue) {
        return LogItemBuilder.create(property.getLogAction()).reviewId(review).userId(user).oldValue(oldValue).newValue(newValue).build();
    }

    public static LogItem buildReviewReviewerRemove(Review review, FecruUser currentUser, FecruUser removedUser, boolean isReviewOpen) {
        LogAction action = isReviewOpen ? LogAction.REVIEW_REVIEWER_REMOVED_MID_REVIEW : LogAction.REVIEW_REVIEWER_REMOVED;
        return LogItemBuilder.create(action).reviewId(review).userId(currentUser).entityId(removedUser).build();
    }

    public static LogItem buildReviewReviewerAdd(Review review, FecruUser currentUser, FecruUser user, boolean isReviewOpen) {
        LogAction action = isReviewOpen ? LogAction.REVIEW_REVIEWER_ADDED_MID_REVIEW : LogAction.REVIEW_REVIEWER_ADDED;
        return LogItemBuilder.create(action).reviewId(review).userId(currentUser).entityId(user).build();
    }

    public static LogItem buildReviewCompleted(Review review, FecruUser user) {
        return LogItemBuilder.create(LogAction.REVIEW_COMPLETED).reviewId(review).userId(user).build();
    }

    public static LogItem buildReviewUncompleted(Review review, FecruUser user) {
        return LogItemBuilder.create(LogAction.REVIEW_UNCOMPLETED).reviewId(review).userId(user).build();
    }

    public static LogItem buildCommentDeleted(Comment comment) {
        return LogItemBuilder.create(LogAction.COMMENT_DELETED).reviewId(comment.getReview()).userId(comment.getUser()).entityId(comment).oldValue(comment.getMessage()).build();
    }

    public static LogItem buildReviewFrxRemoved(Review review, FecruUser currentUser, FileRevisionExtraInfo frx, List<CrucibleRevision> revisions) {
        StringBuilder sb = new StringBuilder();
        String path = "";
        for (CrucibleRevision rev : revisions) {
            sb.append(rev.getRevision()).append(" ");
            path = rev.getPath();
        }
        return LogItemBuilder.create(LogAction.REVIEW_FRX_REMOVED).reviewId(review).userId(currentUser).entityId(frx).oldValue(sb.toString()).entityString(path).build();
    }

    public static LogItem buildReviewFrxAdded(Review review, FecruUser currentUser, FileRevisionExtraInfo frx) {
        return LogItemBuilder.create(LogAction.REVIEW_FRX_ADDED).reviewId(review).userId(currentUser).entityId(frx).entityString(frx.getFePath().toString()).newValue(LogItemBuilder.getDescription(frx)).build();
    }

    public static LogItem buildReviewRevisionAdded(Review review, FecruUser currentUser, FRXRevision frxRev) {
        return LogItemBuilder.create(LogAction.REVIEW_REVISION_ADDED).reviewId(review).userId(currentUser).entityId(frxRev).entityId2(frxRev.getFrx()).entityString(frxRev.getRevision().getPath()).newValue(frxRev.getRevision().getRevision()).build();
    }

    public static LogItem buildReviewRevisionRemoved(Review review, FecruUser currentUser, FRXRevision frxRev, FileRevisionExtraInfo frx) {
        return LogItemBuilder.create(LogAction.REVIEW_REVISION_REMOVED).reviewId(review).userId(currentUser).entityId(frxRev).entityId2(frx).entityString(frxRev.getRevision().getPath()).oldValue(frxRev.getRevision().getRevision()).build();
    }

    private static String getDescription(FileRevisionExtraInfo frx) {
        StringBuilder sb = new StringBuilder();
        List<FRXRevision> revisions = frx.getFrxRevisions();
        for (FRXRevision rev : revisions) {
            sb.append(rev.getRevision().getRevision()).append(" ");
        }
        return sb.toString();
    }

    public static LogItem buildReviewCreated(Review review, FecruUser creator) {
        return LogItemBuilder.create(LogAction.REVIEW_CREATED).reviewId(review).userId(creator).build();
    }

    public static LogItem buildReviewStateChange(Review review, FecruUser user, String action, State nextState) {
        return LogItemBuilder.create(LogAction.REVIEW_STATE_CHANGE).reviewId(review).userId(user).entityString(action).oldValue(review.getState().getName()).newValue(nextState.getName()).build();
    }

    public static LogItem buildReviewSearchAdded(Review review, FecruUser currentUser, String search) {
        return LogItemBuilder.create(LogAction.REVIEW_SEARCH_ADDED).reviewId(review).userId(currentUser).entityString(search).build();
    }

    public static LogItem buildReviewInvitation(Review review, FecruUser currentUser, String invitee) {
        return LogItemBuilder.create(LogAction.REVIEW_REVIEWER_INVITED).reviewId(review).userId(currentUser).entityString(invitee).build();
    }

    public static LogItem buildReviewInvitationCancelled(Review review, FecruUser currentUser, String invitee) {
        return LogItemBuilder.create(LogAction.REVIEW_REVIEWER_UNINVITED).reviewId(review).userId(currentUser).entityString(invitee).build();
    }

    public static LogItem buildReviewReviewerInviteError(Review review, FecruUser currentUser, String message) {
        return LogItemBuilder.create(LogAction.REVIEW_REVIEWER_INVITE_ERROR).reviewId(review).userId(currentUser).entityString(message).build();
    }

    public static LogItem buildExternalAction(Review review, FecruUser currentUser, String externalActionName, String oldValue, String newValue) {
        Preconditions.checkArgument((externalActionName != null ? 1 : 0) != 0, (Object)"externalActionName cannot be null");
        return LogItemBuilder.create(LogAction.EXTERNAL).reviewId(review).userId(currentUser).entityString(externalActionName).oldValue(oldValue).newValue(newValue).build();
    }

    public static LogItem buildMentionEventSent(Review review, FecruUser user, String mentionedUserName, String url) {
        return LogItemBuilder.create(LogAction.MENTION_SENT).reviewId(review).userId(user).entityString(url + ", " + mentionedUserName).build();
    }
}

