/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import java.util.HashMap;
import java.util.Map;

public enum LogAction {
    REVIEW_CREATED("REVIEW_CREATED", "created the review", null),
    REVIEW_COMPLETED("REVIEW_COMPLETED", "completed the review", null),
    REVIEW_UNCOMPLETED("REVIEW_UNCOMPLETED", "resumed reviewing", null),
    REVIEW_STATE_CHANGE("REVIEW_STATE_CHANGE", "changed the review's state", null),
    REVIEW_REVIEWER_ADDED("REVIEW_REVIEWER_ADDED", "added a reviewer", "added reviewers"),
    REVIEW_REVIEWER_ADDED_MID_REVIEW("REVIEW_REVIEWER_ADDED_MID_REVIEW", "added a reviewer mid review", "added reviewers mid review"),
    REVIEW_REVIEWER_REMOVED("REVIEW_REVIEWER_REMOVED", "removed a reviewer from the review", "removed reviewers from the review"),
    REVIEW_REVIEWER_REMOVED_MID_REVIEW("REVIEW_REVIEWER_REMOVED_MID_REVIEW", "removed a reviewer from the open review", "removed reviewers from the open review"),
    REVIEW_REVIEWER_INVITED("REVIEW_REVIEWER_INVITED", "sent an invitation to join the review", "sent invitations to join the review"),
    REVIEW_REVIEWER_UNINVITED("REVIEW_REVIEWER_UNINVITED", "cancelled an invitation to join the review", "cancelled invitations to join the review"),
    REVIEW_REPOSITORY_CHANGED("REVIEW_REPOSITORY_CHANGED", "changed the review's associated repository", null),
    REVIEW_TITLE_CHANGED("REVIEW_TITLE_CHANGED", "changed the review's title", null),
    REVIEW_DESCRIPTION_CHANGED("REVIEW_DESCRIPTION_CHANGED", "changed the review's description", null),
    REVIEW_ALLOW_JOIN_CHANGED("REVIEW_ALLOW_JOIN_CHANGED", "changed the review's \"Allow anyone to join review\" flag", null),
    REVIEW_DUE_DATE_CHANGED("REVIEW_DUE_DATE_CHANGED", "changed the review's due date", null),
    REVIEW_REMINDER_DATE_CHANGED("REVIEW_REMINDER_DATE_CHANGED", "changed the review's reminder date", null),
    REVIEW_AUTHOR_CHANGED("REVIEW_AUTHOR_CHANGED", "changed the review's author", null),
    REVIEW_JIRA_KEY_CHANGED("REVIEW_JIRA_KEY_CHANGED", "changed the review's JIRA key", null),
    REVIEW_MODERATOR_CHANGED("REVIEW_MODERATOR_CHANGED", "changed the review's moderator", null),
    REVIEW_PARENT_REVIEW_CHANGED("REVIEW_PARENT_REVIEW_CHANGED", "changed the review's parent review", null),
    REVIEW_SUMMARY_CHANGED("REVIEW_SUMMARY_CHANGED", "changed the review's summary", null),
    REVIEW_JIRA_KEY_DELETED("REVIEW_JIRA_KEY_DELETED", "deleted the review's JIRA key", null),
    REVIEW_SEARCH_ADDED("REVIEW_SEARCH_ADDED", "added a search to the review", "added searches to the review"),
    REVIEW_FRX_REMOVED("REVIEW_FRX_REMOVED", "removed a file from the review", "removed files from the review"),
    REVIEW_REVISION_REMOVED("REVIEW_REVISION_REMOVED", "removed a revision from the review", "removed revisions from the review"),
    REVIEW_REVISION_ADDED("REVIEW_REVISION_ADDED", "added a revision to the review", "added revisions to the review"),
    REVIEW_REVISION_UPDATED("REVIEW_REVISION_UPDATED", "changed a revision", "changed revisions"),
    REVIEW_REWORK_CREATED("REVIEW_REWORK_CREATED", "created rework", null),
    COMMENT_CHANGED("COMMENT_CHANGED", "changed a comment", "changed comments"),
    COMMENT_REDRAFTED("COMMENT_REDRAFTED", "moved a comment back to draft state", "moved comments back to draft state"),
    COMMENT_ADDED("COMMENT_ADDED", "added a comment", "added comments"),
    COMMENT_DELETED("COMMENT_DELETED", "deleted a comment", "deleted comments"),
    COMMENT_UPDATED("COMMENT_UPDATED", "updated a comment", "updated comments"),
    JIRA_ISSUE_DELETED("JIRA_ISSUE_DELETED", "deleted a JIRA issue", "deleted JIRA issues"),
    SCRIPT_EXECUTED("SCRIPT_EXECUTED", "Script executed", null),
    JIRA_ISSUE_NOT_DELETED("JIRA_ISSUE_NOT_DELETED", "JIRA issue not deleted", null),
    REVIEW_REVIEWER_INVITE_ERROR("REVIEW_REVIEWER_INVITE_ERROR", "Error inviting reviewer", null),
    REVIEW_FRX_ADDED("REVIEW_FRX_ADDED", "added a file to the review", "added files to the review"),
    UNKNOWN("UNKNOWN", "unknown action", null),
    MENTION_SENT("MENTION_SENT", "mentioned a user", null),
    EXTERNAL("EXTERNAL", "external action", null);

    private static final Map<String, LogAction> keyToActionMap;
    private final String key;
    private final String description;
    private final String pluralDescription;

    private LogAction(String key, String description, String pluralDescription) {
        this.key = key;
        this.description = description;
        this.pluralDescription = pluralDescription;
    }

    public String getKey() {
        return this.key;
    }

    public String getDescription() {
        return this.description;
    }

    public static LogAction getAction(String key) {
        return keyToActionMap.get(key);
    }

    public String getPluralDescription() {
        return this.pluralDescription;
    }

    public boolean supportsConsolidation() {
        return this.pluralDescription != null;
    }

    static {
        keyToActionMap = new HashMap<String, LogAction>();
        for (LogAction e2 : LogAction.values()) {
            keyToActionMap.put(e2.getKey(), e2);
        }
    }
}

