/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.atlassian.fecru.template.TemplateManager;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.spi.data.MailMessageData;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.StateTransition;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.util.FreemarkerUtil;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.mail.Mailer;
import com.cenqua.fisheye.rep.DbException;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.hibernate.Query;

public class InviteManager {
    private static TemplateManager getTemplateManager() {
        return SpringContext.getComponent(TemplateManager.class, "templateManager");
    }

    private static Mailer getMailer() {
        return SpringContext.getComponentByClass(Mailer.class);
    }

    private static ProjectManager getProjectManager() {
        return SpringContext.getComponent(ProjectManager.class, "projectManager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteCrucibleInviteUser(String address, FecruUser user) throws DbException {
        if (address != null && user != null) {
            List<Review> reviews = InviteManager.getReviewsByInvitee(address);
            HibernateUtil.beginTransaction();
            try {
                for (Review review : reviews) {
                    review.removeInviteReviewer(address);
                    if (InviteManager.getProjectManager().isAllowedReviewer(review.getProject(), user)) {
                        review.addReviewer(user);
                        continue;
                    }
                    Logs.APP_LOG.warn((Object)String.format("Invited user %s has no permission to join review %s", user, review.getPermaId()));
                }
                HibernateUtil.commitTransaction();
            }
            finally {
                HibernateUtil.rollbackTransactionIfNotCommitted();
            }
        }
    }

    public static List<String> inviteReviewer(String addressString, Review review, FecruUser inviter) throws Exception {
        List<InternetAddress> addresses;
        ArrayList<String> actionErrors = new ArrayList<String>();
        try {
            addresses = Arrays.asList(InternetAddress.parse((String)addressString));
        }
        catch (AddressException e2) {
            actionErrors.add(addressString + " is not a valid email address, and was not added.");
            return actionErrors;
        }
        for (InternetAddress iAddress : addresses) {
            String error = InviteManager.inviteReviewer(iAddress, review, inviter);
            if (error == null) continue;
            actionErrors.add(error);
        }
        return actionErrors;
    }

    public static String inviteReviewer(InternetAddress iAddress, Review review, FecruUser inviter) throws Exception {
        try {
            iAddress.validate();
            if (AppConfig.getsConfig().getUserManager().getUsernameByEmail(iAddress.getAddress()) != null) {
                return iAddress.getAddress() + " is already in the user database.";
            }
            if (review.getInvitees().contains(iAddress.getAddress())) {
                return iAddress.getAddress() + " is already invited to this review.";
            }
            review.inviteReviewer(iAddress.getAddress());
            InviteManager.sendInviteEmail(iAddress.getAddress(), review, inviter);
        }
        catch (AddressException e2) {
            return iAddress.getAddress() + " is not a valid email address, and was not added.";
        }
        return null;
    }

    public static void sendInviteEmail(String user, Review review, FecruUser inviter) throws IOException, TemplateException {
        if (!review.getState().isDraftMetaState()) {
            Template csTmpl = InviteManager.getTemplateManager().getCrucibleTemplate("invite.ftl", true);
            Map<String, Object> root = FreemarkerUtil.init();
            root.put("link", AppConfig.getsConfig().getSiteURL() + "/login/acceptInvite.do?invited=true&address=" + user);
            root.put("inviter", inviter);
            root.put("review", review);
            StringWriter msg = new StringWriter();
            csTmpl.process(root, (Writer)msg);
            msg.flush();
            MailMessageData mail = new MailMessageData();
            mail.addRecipient(user);
            mail.setSubject("You have been invited to review " + review.getPermaId());
            mail.setBodyText("text/html; charset=UTF-8", msg.toString());
            InviteManager.getMailer().sendMessage(mail);
        }
    }

    public static void sendUninviteEmail(String address, Review review) throws IOException, TemplateException {
        if (!review.getState().isDraftMetaState()) {
            MailMessageData mail = new MailMessageData();
            mail.addRecipient(address);
            mail.setSubject("You have been uninvited from review " + review.getPermaId());
            String body = "You are no longer required to participate in this review.";
            int reviewCount = InviteManager.getReviewsByInvitee(address).size();
            if (reviewCount > 0) {
                body = body + "\n\nYour invitations to " + reviewCount + " reviews still stand.";
            }
            mail.setBodyText("text/plain; charset=UTF-8", body);
            InviteManager.getMailer().sendMessage(mail);
        }
    }

    public static void processReviewStateChange(StateTransition st, Review review, FecruUser inviter) throws IOException, TemplateException {
        if (st.getState().isDraftMetaState() && !st.getNextState().isDraftMetaState()) {
            for (String address : review.getInvitees()) {
                InviteManager.sendInviteEmail(address, review, inviter);
            }
        }
    }

    public static List<Review> getReviewsByInvitee(String address) {
        if (address == null) {
            return null;
        }
        Query q2 = HibernateUtil.currentSession().createQuery("select review from Review review left join review.invitees as invites where invites = :address");
        q2.setString("address", address);
        return q2.list();
    }
}

