/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.FRXRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.InlineComment;
import com.cenqua.crucible.model.InlineCommentRevisionDetail;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.Map;
import org.hibernate.Session;

public class InlineCommentManager {
    private static Session session() {
        return HibernateUtil.currentSession();
    }

    public static InlineComment createInlineComment(FileRevisionExtraInfo frx, Comment comment, Map<FRXRevision, String> revisionLineRanges) {
        InlineComment ic = InlineCommentManager.getInlineCommentById(comment.getId());
        if (ic == null) {
            ic = new InlineComment(frx, comment);
        }
        InlineCommentManager.session().save((Object)ic);
        frx.getInlineComments().add(ic);
        for (InlineCommentRevisionDetail icrd : ic.getDetails()) {
            FRXRevision frxRev = icrd.getFrxRevision();
            if (!revisionLineRanges.containsKey(frxRev)) continue;
            String newlineRange = revisionLineRanges.get(frxRev);
            if (Strings.isNullOrEmpty((String)newlineRange)) {
                InlineCommentManager.session().delete((Object)icrd);
            } else {
                icrd.setLineRange(newlineRange);
            }
            revisionLineRanges.remove(frxRev);
        }
        for (FRXRevision frxRev : revisionLineRanges.keySet()) {
            String lineRange = revisionLineRanges.get(frxRev);
            if (Strings.isNullOrEmpty((String)lineRange)) continue;
            InlineCommentManager.createInlineCommentDetail(ic, frxRev, lineRange);
        }
        return ic;
    }

    private static void createInlineCommentDetail(InlineComment comment, FRXRevision frxRev, String lineRange) {
        InlineCommentRevisionDetail icrd = new InlineCommentRevisionDetail(frxRev, comment, lineRange);
        InlineCommentManager.session().save((Object)icrd);
        frxRev.addInlineComment(icrd);
        comment.getDetails().add(icrd);
    }

    public static InlineCommentRevisionDetail getById(Integer id) {
        return (InlineCommentRevisionDetail)InlineCommentManager.session().get(InlineCommentRevisionDetail.class, (Serializable)id);
    }

    public static InlineComment getInlineCommentById(Integer id) {
        return (InlineComment)InlineCommentManager.session().get(InlineComment.class, (Serializable)id);
    }

    public static void delete(InlineComment ic) {
        for (InlineCommentRevisionDetail detail : ic.getDetails()) {
            InlineCommentManager.session().delete((Object)detail);
        }
        ic.getDetails().clear();
        InlineCommentManager.session().delete((Object)ic);
    }
}

