/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.atlassian.fisheye.StoppableVisitor;
import com.atlassian.fugue.Option;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.revision.FileRevisionInfo;
import com.cenqua.crucible.revision.managers.CrucibleRevisionCreator;
import com.cenqua.crucible.revision.source.DisplayRevisionMapper;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.util.HqlBatchedInClauseHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Query;
import org.hibernate.Session;

public class FileRevisionManager {
    private static final int COUNT_WARNING = 500;

    private static Session session() {
        return HibernateUtil.currentSession();
    }

    public static CrucibleRevision createRevision(String source, String path, String revision, String revisionDisplayName, Date createDate) {
        return CrucibleRevisionCreator.createRevision(FileRevisionManager.session(), source, null, path, revision, revisionDisplayName, createDate, null, null);
    }

    public static CrucibleRevision createRevision(String source, String path, String revision, String revisionDisplayName, Date createDate, boolean deleted, Map<String, String> maybeDetails) {
        return CrucibleRevisionCreator.createRevision(FileRevisionManager.session(), source, null, path, revision, revisionDisplayName, createDate, deleted, maybeDetails);
    }

    public static CrucibleRevision createRevision(String source, FileRevisionInfo fri, Date createDate) {
        return CrucibleRevisionCreator.createRevision(FileRevisionManager.session(), source, fri, fri.getPath(), fri.getRevision(), fri.getRevisionDisplayName(), createDate, null, null);
    }

    public static Map<FileRevisionInfo, CrucibleRevision> createRevisionsFromFRIs(Source source, Collection<FileRevisionInfo> fris, Date createDate) {
        final HashMap<RevInfoKey, FileRevisionInfo> friMap = new HashMap<RevInfoKey, FileRevisionInfo>(fris.size());
        for (FileRevisionInfo fri : fris) {
            friMap.put(fri.getRevInfoKey(), fri);
        }
        Function<RevInfoKey, FileRevisionInfo> fileRevisionInfoLookup = new Function<RevInfoKey, FileRevisionInfo>(){

            public FileRevisionInfo apply(RevInfoKey revInfoKey) {
                return (FileRevisionInfo)friMap.get(revInfoKey);
            }
        };
        Map<RevInfoKey, CrucibleRevision> rikRevs = CrucibleRevisionCreator.createRevisions(FileRevisionManager.session(), source.getName(), friMap.keySet(), source, createDate, (Option<Function<RevInfoKey, FileRevisionInfo>>)Option.some((Object)fileRevisionInfoLookup));
        HashMap<FileRevisionInfo, CrucibleRevision> results = new HashMap<FileRevisionInfo, CrucibleRevision>(rikRevs.size());
        for (Map.Entry<RevInfoKey, CrucibleRevision> entry : rikRevs.entrySet()) {
            results.put((FileRevisionInfo)friMap.get(entry.getKey()), entry.getValue());
        }
        return results;
    }

    public static Map<RevInfoKey, CrucibleRevision> createRevisions(String source, Set<RevInfoKey> keys, DisplayRevisionMapper mapper, Date createDate, Option<Function<RevInfoKey, FileRevisionInfo>> fileRevInfoLoader) {
        return CrucibleRevisionCreator.createRevisions(FileRevisionManager.session(), source, keys, mapper, createDate, fileRevInfoLoader);
    }

    public static CrucibleRevision getById(Integer id) {
        return (CrucibleRevision)FileRevisionManager.session().get(CrucibleRevision.class, (Serializable)id);
    }

    public static CrucibleRevision findRevision(String source, RevInfoKey rk) {
        return FileRevisionManager.findRevision(source, rk.getPath().getPath(), rk.getRev());
    }

    public static Integer findCrucibleRevisionId(String source, String path, String rev) {
        CrucibleRevision cr = FileRevisionManager.findRevision(source, path, rev);
        if (cr != null) {
            return cr.getId();
        }
        return null;
    }

    public static CrucibleRevision findRevision(String source, String path, String rev) {
        return CrucibleRevisionCreator.findRevision(FileRevisionManager.session(), source, path, rev);
    }

    public static Map<String, CrucibleRevision> getChangesetRevisions(String sourceName, String csid) {
        Query revQuery = FileRevisionManager.session().createQuery("from CrucibleRevision fileRevision where fileRevision.spr.revision = :rev and fileRevision.spr.sourceName = :source").setString("rev", csid).setString("source", sourceName);
        revQuery.setCacheable(true);
        revQuery.setCacheRegion("com.cenqua.crucible.model.CrucibleRevision.QUERY");
        List<CrucibleRevision> results = HibernateUtil.typedList(revQuery);
        if (results.size() > 500) {
            Logs.APP_LOG.info((Object)String.format("Requesting more than %d revisions may have a negative impact on performance and memory usage of Crucible. %d revisions selected.", 500, results.size()));
        }
        HashMap<String, CrucibleRevision> resultMap = new HashMap<String, CrucibleRevision>();
        for (CrucibleRevision result : results) {
            resultMap.put(result.getPath(), result);
        }
        return resultMap;
    }

    public static List<CrucibleRevision> getRevisions(CrucibleRevision crucibleRevision, boolean before) {
        Query q2 = FileRevisionManager.session().createQuery("select fileRevision from CrucibleRevision fileRevision where fileRevision.spr.sourceName = :source and fileRevision.spr.storedPath.path = :path and fileRevision.createDateTime " + (before ? " < " : ">") + " :date " + "order by fileRevision.createDateTime desc");
        q2.setString("source", crucibleRevision.getSourceName());
        q2.setString("path", crucibleRevision.getPath());
        q2.setLong("date", crucibleRevision.getCreateDateTime().longValue());
        q2.setCacheable(true);
        q2.setCacheRegion("com.cenqua.crucible.model.CrucibleRevision.QUERY");
        List<CrucibleRevision> results = HibernateUtil.typedList(q2);
        if (results.size() > 500) {
            Logs.APP_LOG.info((Object)String.format("Requesting more than %d revisions may have a negative impact on performance and memory usage of Crucible. %d revisions selected.", 500, results.size()));
        }
        return results;
    }

    public static List<Object[]> getReviewsAndRevisionsForPath(Source source, String path) {
        Query q2 = FileRevisionManager.session().createQuery("select review, rev from Review review join review.frxs frx join frx.frxRevisions fr join fr.revision rev where rev.spr.sourceName = :source and rev.spr.storedPath.path = :path");
        q2.setString("source", source.getName());
        q2.setString("path", path);
        List<Object[]> results = HibernateUtil.typedList(q2);
        if (results.size() > 500) {
            Logs.APP_LOG.info((Object)String.format("Requesting more than %d revisions may have a negative impact on performance and memory usage of Crucible. %d revisions selected.", 500, results.size()));
        }
        return results;
    }

    public static Multimap<String, Object[]> getReviewsAndRevisionsForPaths(Source source, List<String> paths) {
        Query q2 = FileRevisionManager.session().createQuery("select review, rev from Review review join review.frxs frx join frx.frxRevisions fr join fr.revision rev where rev.spr.sourceName = :source and rev.spr.storedPath.path in (:paths)");
        q2.setString("source", source.getName());
        ArrayListMultimap result = ArrayListMultimap.create();
        HqlBatchedInClauseHelper<String> helper = new HqlBatchedInClauseHelper<String>(q2, "paths", paths);
        helper.execute(new StoppableVisitor<Object[]>((Multimap)result){
            final /* synthetic */ Multimap val$result;
            {
                this.val$result = multimap;
            }

            @Override
            public boolean visit(Object[] array) {
                CrucibleRevision crucibleRevision = (CrucibleRevision)array[1];
                String path = crucibleRevision.getPath();
                this.val$result.put((Object)path, (Object)array);
                return true;
            }
        }, false);
        return result;
    }

    public static List<String> getUserNamesForStoredRevisionPath(String path) {
        Query q2 = FileRevisionManager.session().createQuery("select user.username from CrucibleRevision fr join fr.uploadItem ui join ui.user user where ui != null and fr.spr.storedPath.path = :path");
        q2.setString("path", path);
        return HibernateUtil.typedList(q2);
    }

    public static List<CrucibleRevision> getRevisions(String source) {
        Query q2 = FileRevisionManager.session().createQuery("select fileRevision from CrucibleRevision fileRevision where fileRevision.spr.sourceName = :source");
        q2.setString("source", source);
        List<CrucibleRevision> results = HibernateUtil.typedList(q2);
        if (results.size() > 500) {
            Logs.APP_LOG.info((Object)String.format("Requesting more than %d revisions may have a negative impact on performance and memory usage of Crucible. %d revisions selected.", 500, results.size()));
        }
        return results;
    }

    public static void deleteCruRevision(CrucibleRevision cruRev) {
        FileRevisionManager.session().delete((Object)cruRev);
    }
}

