/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FRXRevision;
import com.cenqua.crucible.model.FileReadStatus;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewParticipant;
import com.cenqua.crucible.model.managers.UnreadFileManager;
import com.cenqua.fisheye.config.SpringContext;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.hibernate.Session;

public class FRXRevisionManager {
    private UnreadFileManager unreadFileManager;

    public FRXRevision getById(Integer id) {
        return (FRXRevision)this.session().get(FRXRevision.class, (Serializable)id);
    }

    public FRXRevision createFRXRevisionAndUnread(FileRevisionExtraInfo frx, int insertAt, CrucibleRevision fr) {
        FRXRevision frxRevision = this.createFRXRevision(frx, insertAt, fr, new Date());
        if (frxRevision != null) {
            this.markAsUnread(frx, frxRevision.getDateAdded(), false);
            this.resetDueDateIfOld(frx.getReview());
        }
        return frxRevision;
    }

    public FRXRevision createFRXRevision(FileRevisionExtraInfo frx, int insertAt, CrucibleRevision fr, Date createDate) {
        if (fr == null || frx == null || createDate == null) {
            throw new NullPointerException("Parameters to createAndAddFRXRevision must not be null");
        }
        if (frx.getReview().isSnippet() && !frx.getCrucibleRevisions().isEmpty()) {
            throw new UnsupportedOperationException("Snippet review files can only contain 1 revision");
        }
        if (insertAt == -1) {
            return null;
        }
        List<FRXRevision> frxRevs = frx.getFrxRevisions();
        if (insertAt < 0 || insertAt > frxRevs.size()) {
            throw new ArrayIndexOutOfBoundsException("Cant insert into size = " + frxRevs.size() + " at index = " + insertAt);
        }
        if (frx.getFRXRevision(fr) != null) {
            return null;
        }
        FRXRevision addedFrxRev = new FRXRevision(frx, fr, createDate);
        addedFrxRev.setOrder(insertAt);
        this.session().save((Object)addedFrxRev);
        frxRevs.add(insertAt, addedFrxRev);
        for (int i2 = insertAt + 1; i2 < frxRevs.size(); ++i2) {
            frxRevs.get(i2).setOrder(i2);
        }
        return addedFrxRev;
    }

    public void markAsUnread(FileRevisionExtraInfo frx, Date unreadDate) {
        this.markAsUnread(frx, unreadDate, false);
    }

    void markAsUnread(FileRevisionExtraInfo frx, Date unreadDate, boolean forceSetUnreadDate) {
        for (ReviewParticipant participant : frx.getReview().getParticipants()) {
            FileReadStatus status = participant.getReadStatus(frx);
            if (forceSetUnreadDate) {
                this.getUnreadFileManager().markAsUnread(participant, frx, unreadDate, true);
                continue;
            }
            if (status == null) {
                this.getUnreadFileManager().markAsUnread(participant, frx, unreadDate, false);
                continue;
            }
            if (status.getRead() == null || !status.getRead().booleanValue() || !participant.getUser().getUserProfile().getUncompleteOnRevisionAdded()) continue;
            this.getUnreadFileManager().markAsUnread(participant, frx, unreadDate, false);
        }
    }

    public void markAsUnreadFromRevision(FRXRevision fromRevision, boolean inclusive) {
        FileRevisionExtraInfo frx = fromRevision.getFrx();
        Date unreadDate = inclusive ? fromRevision.getDateAdded() : new Date(fromRevision.getDateAdded().getTime() + 1000L);
        int revisionStartPos = fromRevision.getOrder() + 1;
        this.setFrxRevisionCreateDate(frx, unreadDate, revisionStartPos);
        this.markAsUnread(frx, unreadDate, true);
    }

    public void resetDueDateIfOld(Review review) {
        Long dueDateTime = review.getDueDateTime();
        if (dueDateTime != null) {
            Long defaultDurationInMillis = review.getProject().getDefaultDurationInMillis();
            if (defaultDurationInMillis == null) {
                defaultDurationInMillis = 86400000L;
            }
            if (dueDateTime.compareTo(System.currentTimeMillis() - defaultDurationInMillis) < 0) {
                review.setDueDateTime(System.currentTimeMillis() + defaultDurationInMillis);
            }
        }
    }

    private void setFrxRevisionCreateDate(FileRevisionExtraInfo frx, Date createDate, int revisionStartPos) {
        List<FRXRevision> frxRevisions = frx.getFrxRevisions();
        for (FRXRevision frxRevision : frxRevisions.subList(revisionStartPos, frxRevisions.size())) {
            frxRevision.setDateAdded(createDate);
            this.session().save((Object)frxRevision);
        }
    }

    @VisibleForTesting
    Session session() {
        return HibernateUtil.currentSession();
    }

    @VisibleForTesting
    UnreadFileManager getUnreadFileManager() {
        if (this.unreadFileManager == null) {
            this.unreadFileManager = SpringContext.getComponentByClass(UnreadFileManager.class);
        }
        return this.unreadFileManager;
    }
}

