/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FRXRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.FRXRevisionManager;
import com.cenqua.crucible.view.FRXNavList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;

public class FRXManager {
    private static Session session() {
        return HibernateUtil.currentSession();
    }

    public static FileRevisionExtraInfo getByPermaId(String permaId) {
        return FRXManager.getById(FileRevisionExtraInfo.getIdFromPermaId(permaId));
    }

    public static FileRevisionExtraInfo getById(Integer id) {
        return id == null ? null : (FileRevisionExtraInfo)FRXManager.session().get(FileRevisionExtraInfo.class, (Serializable)id);
    }

    public static void delete(FRXRevision frxRev) {
        FRXManager.session().delete((Object)frxRev);
    }

    public static List<FileRevisionExtraInfo> filterNodesForFrxs(List<FRXNavList.FRXNavListNode> sortedNodes) {
        ArrayList<FileRevisionExtraInfo> sortedFrxs = new ArrayList<FileRevisionExtraInfo>();
        for (FRXNavList.FRXNavListNode node : sortedNodes) {
            if (!node.isInReview()) continue;
            sortedFrxs.add(node.getFrxDO().getFrx());
        }
        return sortedFrxs;
    }

    public static FileRevisionExtraInfo createAndAddFRX(CrucibleRevision fr, Review review) {
        if (review.isSnippet() && !review.getFrxs().isEmpty()) {
            throw new UnsupportedOperationException("Snippet reviews can only contain 1 file");
        }
        if (fr == null) {
            throw new IllegalArgumentException("Can't create an frx from a null cruciblerevision");
        }
        FileRevisionExtraInfo frx = review.getFRX(fr);
        if (frx == null) {
            frx = FRXManager.createFRX(review);
            FRXRevisionManager frxRevManager = new FRXRevisionManager();
            frxRevManager.createFRXRevisionAndUnread(frx, frx.getFrxRevisions().size(), fr);
        }
        return frx;
    }

    public static FileRevisionExtraInfo createFRX(Review review) {
        FileRevisionExtraInfo frx = new FileRevisionExtraInfo(review, new Date());
        FRXManager.session().save((Object)frx);
        review.getFrxs().add(frx);
        return frx;
    }

    public static List<FileRevisionExtraInfo> getFRExtraInfos(String path, Review review) {
        Query q2 = FRXManager.session().createQuery("select frx from FileRevisionExtraInfo frx join frx.frxRevisions frxRev join frxRev.revision rev where frx.review = :review and :path = rev.spr.storedPath.path");
        q2.setEntity("review", (Object)review);
        q2.setString("path", path);
        return q2.list();
    }

    public static List<FileRevisionExtraInfo> getFRExtraInfos(String path, Review review, String sourceName) {
        Query q2 = FRXManager.session().createQuery("select distinct frx from FileRevisionExtraInfo frx join frx.frxRevisions frxRev join frxRev.revision rev where frx.review = :review and :path = rev.spr.storedPath.path and :sourceName = rev.sourceName");
        q2.setEntity("review", (Object)review);
        q2.setString("path", path);
        q2.setString("sourceName", sourceName);
        return q2.list();
    }

    public static List<FileRevisionExtraInfo> getFRExtraInfos(CrucibleRevision crucibleRevision) {
        Query q2 = FRXManager.session().createQuery("select frx from FileRevisionExtraInfo frx join frx.frxRevisions frxRev where frxRev.revision.id = :revId");
        q2.setParameter("revId", (Object)crucibleRevision.getId());
        return q2.list();
    }

    public static List<FileRevisionExtraInfo> getFRXs(Review review, Date whenAdded, boolean before) {
        String qstr = "select frx from FileRevisionExtraInfo frx where frx.review = :review";
        if (whenAdded != null) {
            qstr = qstr + " and frx.whenAddedTime " + (before ? "<=" : ">=") + " :timeStamp";
        }
        Query q2 = FRXManager.session().createQuery(qstr);
        q2.setEntity("review", (Object)review);
        if (whenAdded != null) {
            q2.setLong("timeStamp", whenAdded.getTime());
        }
        List l2 = q2.list();
        return Collections.unmodifiableList(l2);
    }

    public static int getFRXCount(Review review) {
        Query q2 = FRXManager.session().createQuery("select count(*) from FileRevisionExtraInfo frx where frx.review = :review ");
        q2.setEntity("review", (Object)review);
        return ((Long)q2.uniqueResult()).intValue();
    }
}

