/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.cenqua.crucible.model.FRXComment;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.InlineComment;
import com.cenqua.crucible.model.discussion.CommentOperator;
import com.cenqua.crucible.model.discussion.FRXDiscussionBrowser;
import com.cenqua.crucible.model.managers.DiscussionBrowserImpl;

abstract class FRXDiscussionBrowserImpl
extends DiscussionBrowserImpl
implements FRXDiscussionBrowser {
    private boolean includeFRXComments = true;
    private boolean includeInlineComments = true;

    FRXDiscussionBrowserImpl() {
    }

    @Override
    public FRXDiscussionBrowser excludeFRXComments() {
        this.includeFRXComments = false;
        return this;
    }

    @Override
    public FRXDiscussionBrowser includeFRXComments() {
        this.includeFRXComments = true;
        return this;
    }

    @Override
    public FRXDiscussionBrowser excludeInlineComments() {
        this.includeInlineComments = false;
        return this;
    }

    @Override
    public FRXDiscussionBrowser includeInlineComments() {
        this.includeInlineComments = true;
        return this;
    }

    protected void traverseFRXDiscussions(FileRevisionExtraInfo frx, CommentOperator operator) {
        if (this.includeFRXComments) {
            for (FRXComment frxcomment : frx.getFrxComments()) {
                this.traverseDiscussion(frxcomment.getComment(), operator);
            }
        }
        if (this.includeInlineComments) {
            for (InlineComment ic : frx.getInlineComments()) {
                this.traverseDiscussion(ic.getComment(), operator);
            }
        }
    }
}

