/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.FRXComment;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;

public class FRXCommentManager {
    private static Session session() {
        return HibernateUtil.currentSession();
    }

    public static FRXComment createAndAddFrxComment(Comment comment, FileRevisionExtraInfo frx) {
        if (frx.getReview().isSnippet()) {
            throw new IllegalStateException("File comments are not currently supported for snippet reviews. Add a general comment.");
        }
        FRXComment rc = FRXCommentManager.getFRXComment(comment, frx);
        if (rc != null) {
            return rc;
        }
        rc = new FRXComment(frx);
        rc.setComment(comment);
        FRXCommentManager.session().save((Object)rc);
        frx.addFrxComment(rc);
        return rc;
    }

    public static FRXComment getById(Integer id) {
        return (FRXComment)FRXCommentManager.session().get(FRXComment.class, (Serializable)id);
    }

    private static FRXComment getFRXComment(Comment comment, FileRevisionExtraInfo frx) {
        Query q2 = FRXCommentManager.session().createQuery("select frxComment from FRXComment frxComment where frxComment.comment = :comment and frxComment.frx = :frx");
        q2.setEntity("comment", (Object)comment);
        q2.setEntity("frx", (Object)frx);
        return (FRXComment)q2.uniqueResult();
    }

    public static List getFrxComments() {
        return FRXCommentManager.session().createQuery("from FRXComment").list();
    }

    public static void deleteFrxComment(FRXComment rc) {
        FRXCommentManager.session().delete((Object)rc);
    }
}

