/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.CommentList;
import com.cenqua.crucible.model.CommentVisitor;
import com.cenqua.crucible.model.CommentVisitorContext;
import com.cenqua.crucible.model.discussion.CommentOperator;
import com.cenqua.crucible.model.discussion.DiscussionBrowser;
import com.cenqua.crucible.model.discussion.DiscussionClause;
import com.cenqua.crucible.model.discussion.DiscussionClauses;
import com.cenqua.crucible.model.discussion.DiscussionResult;
import java.util.ArrayList;
import java.util.List;

abstract class DiscussionBrowserImpl
implements DiscussionBrowser {
    private DiscussionClause clause = null;
    private boolean prune = false;

    DiscussionBrowserImpl() {
    }

    @Override
    public DiscussionResult where(DiscussionClause clause) {
        this.clause = clause == null ? DiscussionClauses.isTrue() : clause;
        return this;
    }

    @Override
    public DiscussionResult prune() {
        this.prune = true;
        return this;
    }

    protected DiscussionClause getClause() {
        return this.clause == null ? DiscussionClauses.isTrue() : this.clause;
    }

    protected final void traverseDiscussion(CommentList comment, final CommentOperator operator) {
        comment.visit(new CommentVisitor(){

            @Override
            public void visit(CommentVisitorContext ctx) {
                Comment c2 = ctx.getComment();
                boolean matched = DiscussionBrowserImpl.this.getClause().test(c2, ctx.getDepth());
                if (matched) {
                    operator.operate(c2);
                }
                if (matched || !DiscussionBrowserImpl.this.prune) {
                    ctx.proceed();
                }
            }
        });
    }

    @Override
    public boolean isEmpty() {
        return this.collect().isEmpty();
    }

    @Override
    public int count() {
        return this.collect().size();
    }

    @Override
    public List<Comment> collect() {
        final ArrayList<Comment> comments = new ArrayList<Comment>();
        this.visit(new CommentOperator(){

            @Override
            public void operate(Comment comment) {
                comments.add(comment);
            }
        });
        return comments;
    }
}

