/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.user.permissions.GlobalPermissionManager;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.SuggestedReviewer;
import com.cenqua.crucible.model.managers.SuggestedReviewerManager;
import com.cenqua.crucible.revision.source.RepositorySource;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.tags.ReviewUtil;
import com.cenqua.crucible.view.reviewfilters.ReviewFilterState;
import com.cenqua.crucible.view.reviewfilters.ReviewFilters;
import com.cenqua.fisheye.FishEyeSysProps;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.BlameAndLinecountCalculator;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.History;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.util.SumMap;
import com.cenqua.fisheye.util.Timer;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="suggestedReviewerManager")
public class DefaultSuggestedReviewerManager
implements SuggestedReviewerManager {
    private final CommitterUserMappingManager committerUserMappingManager;
    private final GlobalPermissionManager globalPermissionManager;

    @Autowired
    public DefaultSuggestedReviewerManager(CommitterUserMappingManager committerUserMappingManager, GlobalPermissionManager globalPermissionManager) {
        this.committerUserMappingManager = committerUserMappingManager;
        this.globalPermissionManager = globalPermissionManager;
    }

    @Override
    public Map<FecruUser, SuggestedReviewer> setReviewCount(Map<FecruUser, SuggestedReviewer> existingList) {
        for (SuggestedReviewer reviewer : existingList.values()) {
            ReviewFilterState filterState = new ReviewFilterState(reviewer.getCrucibleUser(), ReviewFilters.FilterKey.TO_REVIEW, "ReviewQueryAction");
            reviewer.setOpenReviews(filterState.countFilteredReviews(ReviewFilters.FilterKey.TO_REVIEW));
        }
        return existingList;
    }

    @Override
    public Map<FecruUser, SuggestedReviewer> addToSuggestedReviewers(Map<FecruUser, SuggestedReviewer> existingList, CrucibleRevision r2, Review review, RepositorySource source) throws Exception {
        FileRevision fr = source.getRepoEngine().getRevisionCache().getFileRevision(r2.getRevInfoKey());
        try {
            History history = DefaultSuggestedReviewerManager.getHistory(r2.getRevInfoKey(), source);
            if (history == null) {
                return existingList;
            }
            SumMap<String> authorLinecount = history.getAuthorLinecount();
            for (String author : authorLinecount.keySet()) {
                FecruUser user = this.committerUserMappingManager.getUserForCommitter(source.getRepositoryHandle().getName(), author);
                if (user == null) {
                    Logs.APP_LOG.debug((Object)("Suggest Reviewers: cant find user: " + author));
                    continue;
                }
                if (!this.globalPermissionManager.hasPermission(user.getUsername(), GlobalPermissionType.CRUCIBLE_USER)) continue;
                boolean add = true;
                if (review.isModerated() && review.getModerator().equals(user) || review.getAuthor().equals(user) || review.getReviewers().contains(user) || !ReviewUtil.isAllowedParticipant(review, user)) continue;
                SuggestedReviewer suggested = existingList.get(user);
                if (suggested != null) {
                    add = false;
                    suggested.addPath(fr.getPath(), authorLinecount.get(author), fr.getLineCount(), 0);
                }
                if (!add) continue;
                suggested = new SuggestedReviewer(user);
                suggested.addPath(fr.getPath(), authorLinecount.get(author), fr.getLineCount(), 0);
                existingList.put(user, suggested);
            }
        }
        catch (Exception e2) {
            Logs.APP_LOG.debug((Object)("Suggest Reviewers: can't get blame data for '" + r2.getPath() + "' - ignoring."));
        }
        return existingList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static History getHistory(RevInfoKey revInfoKey, Source source) {
        Timer timer = new Timer("Getting history of " + revInfoKey);
        try {
            if (revInfoKey == null || source == null || !(source instanceof RepositorySource)) {
                History history = null;
                return history;
            }
            History history = null;
            try {
                RepositoryEngine engine = ((RepositorySource)source).getRepoEngine();
                BlameAndLinecountCalculator calculator = engine.getLinecountCalculator();
                history = FishEyeSysProps.ENABLE_REQUEST_BLAME_CALCULATION ? calculator.getHistoryWithFallback(revInfoKey) : calculator.getHistory(revInfoKey);
                history.initialiseInfo();
            }
            catch (Exception e2) {
                Logs.APP_LOG.debug((Object)("Could not get blame history for " + revInfoKey));
            }
            History history2 = history;
            return history2;
        }
        finally {
            timer.end();
        }
    }
}

