/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.StateChangeLog;
import com.cenqua.crucible.model.managers.StateChangeLogManager;
import com.cenqua.crucible.util.HqlBatchedInClauseHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="stateChangeLogManager")
public class DefaultStateChangeLogManager
implements StateChangeLogManager {
    private final CurrentSessionProvider currentSessionProvider;

    @Autowired
    public DefaultStateChangeLogManager(CurrentSessionProvider currentSessionProvider) {
        this.currentSessionProvider = currentSessionProvider;
    }

    @Override
    @Transactional
    public StateChangeLog getStateChangeById(int stateChangeId) {
        return (StateChangeLog)this.session().get(StateChangeLog.class, (Serializable)Integer.valueOf(stateChangeId));
    }

    @Override
    @Transactional
    public List<StateChangeLog> getStateChangeByIds(Collection<Integer> ids) {
        Query q2 = this.session().createQuery("from StateChangeLog stateChangeLog where stateChangeLog.id in (:ids)");
        HqlBatchedInClauseHelper helper = new HqlBatchedInClauseHelper(q2, "ids", ImmutableList.copyOf(ids));
        return helper.executeAndFetchAll();
    }

    @Override
    @Transactional
    public StateChangeLog addStateChange(String newState, Integer reviewId, FecruUser user) {
        Preconditions.checkNotNull((Object)reviewId);
        StateChangeLog stateChangeLog = new StateChangeLog(newState, reviewId, user);
        this.session().save((Object)stateChangeLog);
        return stateChangeLog;
    }

    @Override
    @Transactional
    public List<StateChangeLog> getStateChanges(Integer reviewId, boolean descending) {
        Query q2 = this.session().createQuery("select stateChange from StateChangeLog as stateChange Where stateChange.reviewId = :match order by stateChange.dateTimeStamp " + (descending ? "desc" : "asc"));
        q2.setInteger("match", reviewId.intValue());
        return HibernateUtil.typedList(q2);
    }

    private Session session() {
        return this.currentSessionProvider.currentSession();
    }
}

