/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.SnippetManager;
import com.cenqua.crucible.revision.FileRevisionInfo;
import com.cenqua.crucible.revision.managers.ContentManager;
import com.cenqua.crucible.upload.UploadItem;
import com.cenqua.crucible.upload.UploadManager;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component(value="snippetManager")
public class DefaultSnippetManager
implements SnippetManager {
    public static final String GENERATED_NAME_PATTERN = "\\d+ lines?( of .*)?";

    @Override
    public Review addFileToSnippet(Review review, String filename, String snippet, String contentType, ContentManager contentManager, String extension) throws IOException {
        String sourceName = "UPLOAD:" + review.getId();
        UploadItem ui = UploadManager.createUploadItem(review.getAuthor(), filename, snippet, contentType, "snippet");
        FileRevisionInfo fri = UploadManager.getToFRI(ui, null, review.getAuthor().getUsername(), filename, "snippet", contentType, null);
        CrucibleRevision fr = contentManager.makeCrucibleRevision(sourceName, fri);
        fr.setSnippetSyntax(extension);
        fr.setUploadItem(ui);
        FileRevisionExtraInfo frx = review.addRevision(fr);
        frx.setShowAsDiff(false);
        return review;
    }

    @Override
    public CrucibleRevision getSnippetRevision(Review review) {
        List<CrucibleRevision> revisions = this.getSnippetFRX(review).getCrucibleRevisions();
        if (revisions.size() != 1) {
            throw new IllegalStateException("Snippets must only have 1 revision.");
        }
        return revisions.get(0);
    }

    @Override
    public FileRevisionExtraInfo getSnippetFRX(Review review) {
        if (!review.isSnippet()) {
            throw new IllegalArgumentException("This method should only be called on snippets.");
        }
        Set<FileRevisionExtraInfo> frxs = review.getFrxs();
        if (frxs.size() != 1) {
            throw new IllegalStateException("Snippets must have only 1 FRX.");
        }
        return frxs.iterator().next();
    }

    @Override
    public String constructSnippetName(String title, String syntax, String syntaxName, String uploadText) {
        if (!Strings.isNullOrEmpty((String)title) && !Strings.isNullOrEmpty((String)title.trim())) {
            return title;
        }
        if (!Strings.isNullOrEmpty((String)syntax) && !Strings.isNullOrEmpty((String)uploadText)) {
            int lineCount = 0;
            try {
                LineNumberReader numberReader = new LineNumberReader(new StringReader(uploadText));
                while (numberReader.readLine() != null) {
                    ++lineCount;
                }
                numberReader.close();
            }
            catch (IOException e2) {
                throw new RuntimeException("Could not read line count for snippet", e2);
            }
            String noun = lineCount == 1 ? "line" : "lines";
            return String.valueOf(lineCount) + " " + noun + (!Strings.isNullOrEmpty((String)syntaxName) ? " of " + syntaxName : "");
        }
        return "Untitled";
    }

    @Override
    public String reconstructSnippetName(String name, String oldSynhiName, String newSynhiName) {
        String title = null;
        String middle = null;
        if (Strings.isNullOrEmpty((String)name) || Strings.isNullOrEmpty((String)oldSynhiName) || !name.matches(GENERATED_NAME_PATTERN)) {
            return name;
        }
        if (oldSynhiName.equals("None") && (name.endsWith("line") || name.endsWith("lines"))) {
            return name + " of " + newSynhiName;
        }
        if (name.endsWith(" line of " + oldSynhiName.trim())) {
            middle = " line";
        } else if (name.endsWith(" lines of " + oldSynhiName.trim())) {
            middle = " lines";
        } else {
            return name;
        }
        boolean isNone = "None".equals(newSynhiName.trim());
        if (!isNone) {
            middle = middle + " of ";
        }
        title = name.substring(0, name.lastIndexOf(middle) + middle.length()) + (isNone ? "" : newSynhiName.trim());
        return title;
    }
}

