/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.atlassian.crucible.spi.services.ChangeSetContentTooLargeException;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.CrucibleSysProps;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Patch;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.dao.PatchDAO;
import com.cenqua.crucible.model.managers.FileRevisionManager;
import com.cenqua.crucible.model.managers.PatchManager;
import com.cenqua.crucible.revision.FileRevisionInfo;
import com.cenqua.crucible.revision.diff.DiffRevisionsInfo;
import com.cenqua.crucible.revision.diff.patchDiff.PatchException;
import com.cenqua.crucible.revision.source.PatchRevision;
import com.cenqua.crucible.revision.source.PatchSource;
import com.cenqua.crucible.upload.UploadItem;
import com.cenqua.crucible.util.ReviewCreationHelper;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="patchManager")
@AvailableToPlugins
public class DefaultPatchManager
implements PatchManager {
    private final PatchDAO patchDAO;
    private final EffectiveUserProvider effectiveUserProvider;

    @Autowired
    public DefaultPatchManager(PatchDAO patchDAO, EffectiveUserProvider effectiveUserProvider) {
        this.patchDAO = patchDAO;
        this.effectiveUserProvider = effectiveUserProvider;
    }

    @Override
    @Transactional
    public Patch createPatch(Review review, UploadItem upload) throws IOException, PatchException, ChangeSetContentTooLargeException {
        Patch patch = new Patch();
        patch.setUploadItem(upload);
        patch.setReview(review);
        this.checkPatchSizeAcceptable(patch);
        this.patchDAO.savePatch(patch);
        this.createFileRevisions(patch);
        return patch;
    }

    private void checkPatchSizeAcceptable(Patch p2) throws IOException, PatchException, ChangeSetContentTooLargeException {
        int limit = CrucibleSysProps.REVIEW_CONTENT_SIZE_LIMIT;
        if (p2.getDiffRevisions().size() > limit) {
            throw new ChangeSetContentTooLargeException(limit);
        }
    }

    @Override
    @Transactional
    public void createFileRevisions(Patch p2) throws IOException, PatchException {
        List<DiffRevisionsInfo> files = p2.getDiffRevisions();
        ArrayList<CrucibleRevision> cruRevs = new ArrayList<CrucibleRevision>();
        for (DiffRevisionsInfo dri : files) {
            if (dri.getFromRevisionName() != null) {
                cruRevs.add(this.makeFromRevision(p2, dri));
            }
            cruRevs.add(this.makeToRevision(p2, dri));
        }
        p2.setFileRevisions(cruRevs);
    }

    private CrucibleRevision makeFromRevision(Patch p2, DiffRevisionsInfo dri) {
        FileRevisionInfo fri = PatchSource.makeFileRevisionInfo(p2, dri, true, null, null);
        return FileRevisionManager.createRevision("PATCH:" + p2.getId(), fri, new Date());
    }

    private CrucibleRevision makeToRevision(Patch p2, DiffRevisionsInfo dri) {
        FileRevisionInfo fri = PatchSource.makeFileRevisionInfo(p2, dri, false, null, null);
        return FileRevisionManager.createRevision("PATCH:" + p2.getId(), fri, new Date());
    }

    @Override
    public Patch getPatchById(Integer id) {
        return this.patchDAO.getPatchById(id);
    }

    @Override
    public Patch findPatch(CrucibleRevision rev) {
        if (rev == null || !rev.getSourceName().startsWith("PATCH:")) {
            return null;
        }
        PatchRevision patchRevision = PatchRevision.fromCrucibleRevision(rev);
        return this.patchDAO.getPatchById(patchRevision.patchId);
    }

    @Override
    public List<Patch> findReviewPatches(Review review) {
        return this.patchDAO.findReviewPatches(review);
    }

    @Override
    @Transactional
    public void deleteReviewPatches(Review review) {
        this.patchDAO.deleteReviewPatches(review);
    }

    @Override
    @Transactional
    public void transferPatchToExistingSource(Patch patch, PatchSource existingSource) throws PatchException {
        if (patch.isAnchored() && existingSource != null) {
            ImmutableList existingPatchIds = ImmutableList.copyOf(this.patchDAO.getPatchIdsForSource(existingSource.getName()));
            if (existingPatchIds.isEmpty()) {
                throw new PatchException("Failed to find patches for source " + existingSource.getName());
            }
            int patchCount = existingPatchIds.size();
            Patch existingPatch = this.getPatchById((Integer)existingPatchIds.get(0));
            if (!existingPatch.isAnchored()) {
                throw new PatchException("Cannot append to an unanchored patch.");
            }
            if (!patch.getAnchorSource().equals(existingPatch.getAnchorSource())) {
                throw new PatchException("Cannot append to a patch anchored to a different repository.");
            }
            for (CrucibleRevision revision : patch.getFileRevisions()) {
                revision.setSourceName(existingSource.getName());
                if (PatchRevision.fromCrucibleRevision((CrucibleRevision)revision).isFrom) continue;
                revision.setRevisionDisplayName(DiffRevisionsInfo.getToRevisionName(patchCount + 1));
            }
        }
    }

    @Override
    @Transactional
    public void removePatchRevision(PatchSource source, FileRevisionExtraInfo frx, CrucibleRevision revision) {
        PatchRevision patchRevision = PatchRevision.fromCrucibleRevision(revision);
        Review review = frx.getReview();
        ReviewCreationHelper ch = source.createReviewCreationHelper(review);
        FecruUser user = this.effectiveUserProvider.getEffectiveUser();
        boolean revisionRemovable = !patchRevision.isFrom;
        boolean wouldLeaveLastRevision = revision.isAdded() == false && frx.getCrucibleRevisions().size() == 2;
        boolean success = revisionRemovable && !wouldLeaveLastRevision ? ch.removeRevisions(user, Collections.singletonList(revision), false) : ch.removeFrx(user, frx.getId());
        if (!success) {
            throw new IllegalStateException(Joiner.on((String)"; ").join(ch.getMessages()));
        }
    }

    @Override
    @Transactional
    public Iterable<Patch> getActivePatchesForSource(String sourceName) {
        return this.patchDAO.getActivePatchesForSource(sourceName);
    }
}

