/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.model.LogItem;
import com.cenqua.crucible.model.managers.LogAction;
import com.cenqua.crucible.model.managers.LogItemManager;
import com.cenqua.crucible.model.managers.LogItemSearchCriteria;
import com.cenqua.crucible.util.HqlBatchedInClauseHelper;
import com.cenqua.crucible.util.HqlUtil;
import com.cenqua.fisheye.user.UserManager;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="logItemManager")
public class DefaultLogItemManager
implements LogItemManager {
    private final CurrentSessionProvider currentSessionProvider;
    private final UserManager userManager;

    @Autowired
    public DefaultLogItemManager(CurrentSessionProvider currentSessionProvider, UserManager userManager) {
        this.currentSessionProvider = currentSessionProvider;
        this.userManager = userManager;
    }

    @Override
    @Transactional
    public LogItem getLogItemById(Integer logItemId) {
        return (LogItem)this.session().get(LogItem.class, (Serializable)logItemId);
    }

    @Override
    @Transactional
    public void addLogItem(LogItem logItem) {
        this.session().save((Object)logItem);
    }

    @Override
    @Transactional
    public List<LogItem> getLogItemsByIds(Collection<Integer> ids) {
        Query q2 = this.session().createQuery("from LogItem logItem where logItem.id in (:ids)");
        HqlBatchedInClauseHelper helper = new HqlBatchedInClauseHelper(q2, "ids", ImmutableList.copyOf(ids));
        return helper.executeAndFetchAll();
    }

    @Override
    @Transactional
    public List<LogItem> getLogItems(LogItemSearchCriteria searchCriteria) {
        StringBuilder sb = new StringBuilder("from LogItem logItem ");
        String where = null;
        if (!CollectionUtils.isEmpty(searchCriteria.getReviewIds())) {
            where = HqlUtil.whereBuilder(where, "logItem.reviewId in (:reviews)", "and");
        }
        if (!CollectionUtils.isEmpty(searchCriteria.getActions())) {
            where = HqlUtil.whereBuilder(where, "logItem.action in (:actions)", "and");
        }
        if (searchCriteria.getMinDate() != null) {
            where = HqlUtil.whereBuilder(where, "logItem.createDateTime > :date", "and");
        }
        if (searchCriteria.getMaxDate() != null) {
            where = HqlUtil.whereBuilder(where, "logItem.createDateTime < :maxDate", "and");
        }
        if (where != null) {
            sb.append(where);
        }
        sb.append(" order by logItem.createDateTime");
        if (searchCriteria.getOrder() != null) {
            sb.append(" ").append((Object)searchCriteria.getOrder());
        }
        Query q2 = this.session().createQuery(sb.toString());
        if (searchCriteria.getStart() != null) {
            q2.setFirstResult(searchCriteria.getStart().intValue());
        }
        if (searchCriteria.getLimit() != null) {
            q2.setMaxResults(searchCriteria.getLimit().intValue());
        }
        if (!CollectionUtils.isEmpty(searchCriteria.getReviewIds())) {
            q2.setParameterList("reviews", searchCriteria.getReviewIds());
        }
        if (!CollectionUtils.isEmpty(searchCriteria.getActions())) {
            q2.setParameterList("actions", searchCriteria.getActions());
        }
        if (searchCriteria.getMinDate() != null) {
            q2.setParameter("date", (Object)searchCriteria.getMinDate().getTime());
        }
        if (searchCriteria.getMaxDate() != null) {
            q2.setParameter("maxDate", (Object)searchCriteria.getMaxDate().getTime());
        }
        List list = q2.list();
        HashSet<String> messages = new HashSet<String>();
        ListIterator iterator = list.listIterator(list.size());
        while (iterator.hasPrevious()) {
            LogItem item = (LogItem)iterator.previous();
            LogAction action = LogAction.getAction(item.getAction());
            if (LogAction.COMMENT_ADDED != action && LogAction.COMMENT_UPDATED != action && LogAction.COMMENT_CHANGED != action) continue;
            if (LogAction.COMMENT_UPDATED == action || !StringUtils.isEmpty((String)item.getDescription()) && messages.contains(item.getDescription())) {
                iterator.remove();
                continue;
            }
            messages.add(item.getDescription());
        }
        return list;
    }

    private Session session() {
        return this.currentSessionProvider.currentSession();
    }
}

